.VM 2 2 54 2
.HE "|D2D/98|Free Disc Copy Program|D2D/98|"
.FO "|Ulrich Windl|Last change: 26 December 1998|%|"
.
.SH NAME
.in +5
d2d \- disc-to-disc copy program
.
.SH SYNOPSIS
.in +5
.ad l
\fBd2d\fP
\fIfrom\fP
\fIto\fP
[\fB/\fP\fInumber\fP]
[\fB/a\fP]
[\fB/b\fP\fIstring\fP]
[\fB/D\fP]
[\fB/e\fP\fInumber\fP]
[\fB/n\fP]
[\fB/o\fP]
[\fB/q\fP]
[\fB/r\fP]
[\fB/t\fP\fIdrive\fP\fB:\fP[\fIdirectory\fP]]
[\fB/u\fP]
[\fB/v\fP[\fBs\fP]]
[\fB/w\fP]
[\fB/x\fP\fInumber\fP]
[\fB/?\fP]
.ad b
.
.SH DESCRIPTION
.in +5
.RS
.in -5
.I D2D/98
is a program to copy floppy discs.
.
.LP
The first specified disc
denotes the source whereas the second disc denotes the
destination of the copy operation.
.
.LP
Source and destination may be identical.
.I D2D/98
reads in the source and writes the contents of it to the
destination. Both, the source and destination disc's drive must be
physically compatible as
.I D2D/98
only can produce physical copies (as opposed to file-by-file copies) of a
disc.
.
.LP
When reading in the source disc,
.I D2D/98
can use several kinds of memory to store data. First it uses
conventional RAM (real-mode RAM). If there is no more RAM available,
.I D2D/98
can use Extended Memory via XMS 2.0 or Expanded Memory via EMS 4.0.
If the program still needs more memory, it can store information
on a fixed disc or a RAM-disc.
.
.LP
A special algorithm enables
.I D2D/98
to copy only the actually needed tracks on MS\-DOS discs. This speeds up
both, reading and wri\%ting. Formatting is not affected, as
.I D2D/98
always formats the entire disc (if formatting is required at all).
.
.LP
.I D2D/98
can create multiple copies of a single disc, with only reading the
source disc once. This greatly increases the speed of the copy pro\%cess.
.
.LP
The destination disc will be formatted automatically if necessary. If
one of the destination discs is de\%fec\%tive,
.I D2D/98
will try the process again with another disc.
.RE
.
.SH OPTIONS
.in +5
.RS
.
.in -5
\fB/\fP\fInumber\fP
.IP ""
The process of writing the destination disc will be repeated
.I number
times. Only successful copies are counted.
.
.LP
.B /a
.IP ""
Copy
.I all
tracks on the disc and do not use the optimizing algorithm.
.
.LP
\fB/b\fP\fIstring\fP
.IP ""
.I String
specifies the physical format (BPB, BIOS Parameter Block) of the source
disc. This option is required if the disc to be copied is not a MS-DOS disc.
The disc formats are encoded as fol\%lows (exact spelling required):
.RS
.IP 160k
160kB (40 cylinders, 8 sectors, one side, MFM)
.IP 180k
180kB (40 cylinders, 9 sectors, one side, MFM)
.IP 320k
320kB (40 cylinders, 8 sectors, two sides, MFM)
.IP 320S
320kB (80 cylinders, 8 sectors, one side, MFM)
.IP 360k
360kB (40 cylinders, 9 sectors, two sides, MFM)
.IP 360S
360kB (80 cylinders, 9 sectors, one side, MFM)
.IP 720k
720kB (80 cylinders, 9 sectors, two sides, MFM)
.IP 1.2M
1.2MB (80 cylinders, 15 sectors, two sides, MFM)
.IP 1.4M
1.44MB (80 cylinders, 18 sectors, two sides, MFM)
.IP 2.8M
2.88MB (80 cylinders, 36 sectors, two sides, MFM)
.RE
.LP
.
.LP
.B /D
.IP ""
This switch enables deactivation of the boot code on each destination
disc. Just a simple measure against boot virusses!
.
.LP
\fB/e\fP\fInumber\fP
.IP ""
.I number
specifies the amount of expanded memory in kB that may be used to store the
source disc's data. If
.I number
is equal to zero, no EMS will be used. The amount of memory can only be
decreased, but never increased. If there is less memory available than
specified, only the available memory will be used.
.
.LP
.B /n
.IP ""
Tells
.I D2D/98
that the machine is not 100% IBM com\%pa\%ti\%ble. Some\%times this option can
help if problems are en\%countered. This option is obsolete.
.
.LP
.B /o
.IP ""
Inhibits creating a new volume serial number for each destination disc.
This is normally done when the source disc has a serial number.
.
.LP
.B /q
.IP ""
Normally a bell is heard whenever the program tries to attract the
users's attention. This option disables the bell (except for fatal
errors).
.
.LP
.B /r
.IP ""
This flag enables the read recovery processing option of
.I D2D/98 .
Normally the program aborts reading the source disc on the first read
error. In recovery mode
.I D2D/98
gives each sector on a bad track an extra try. Whether the try was
successful or not, the program always continues reading.
.
.LP
\fB/t\fP\fIdrive\fP\fB:\fP[\fIdirectory\fP]
.IP ""
When there is not enough memory addressable by the CPU,
.I D2D/98
will create a file in the specified fixed drive's directory to store
data in it.
.
.LP
.B /u
.IP ""
Normally
.I D2D/98
decides whether the destination disc is suitable formatted; in that case
the destination disc is not formatted again. This option forces the
program to format the destination disc.
.
.LP
\fB/v\fP[\fBs\fP]
.IP ""
Instructs
.I D2D/98
to verify each track after having written it. If smart verify
(\fB/vs\fP) is selected, the tracks are only verified if they are not
formatted. This option does not affect the automatic verification that
follows formatting.
.
.LP
.B /w
.IP ""
The program asks for confirmation if a destination disc contains any
valid data. With this option the arising question is automatically
confirmed.
.
.LP
\fB/x\fP\fInumber\fP
.IP ""
.I number
specifies the amount of extended memory in kB that may be used to store the
source disc's data. If
.I number
is equal to zero, no XMS will be used. The amount of memory can only be
decreased, but never increased. If there is less memory available than
specified, only the available memory will be used.
.
.LP
\fB/?\fP
.IP ""
makes
.I D2D/98
display a short explanation of each option.
.RE
.
.SH EXAMPLES
.in +5
.RS
.in -5
.ne 4
Copy the disc in drive A: to the disc in drive B:, and use drive C: to swap
.DS I
d2d a: b: /tc:
.DE
.
.ne 4
Copy the non-DOS disc (360kB) in drive A: and produce 3 copies in drive A:
.DS I
d2d A: A: /3 /b360k
.DE
.
.ne 5
Copy the disc in drive B: to the disc in drive B:, do not use extended
memory (if present), copy all tracks and do not create a new volume serial
number
.DS I
d2d a: b: /x0 /a /o
.DE
.
.RE
.
.SH BUGS
.
.in +5
.RS
.in -5
.I D2D
cannot copy a disc with defective sectors on it automatically. You must
specify option
.B /r .
If the first track on the disc is damaged, you must also use the
.B /b
option to select the format of the disc. In that case the destination
disc is always formatted.
.
.LP
.ne 6
The command line parser is inconsistent: Drive specifications must be
arguments while several options can be in one argument. That is why
.DS I
d2d a: b:/a /o
.DE
is not accepted while
.DS I
d2d a: b: /a/o
.DE
is correct syntax. Try to make each option an individual argument. The
parser also allows to specify all arguments in any order. That is why
.ne 4
.DS
d2d /a a: b: /x128 /v
.DE
and
.DS
d2d /x128 /a a: b: /v
.DE
produce the same result. The only exception are drive specifications:
The first drive is always the source drive.
.
.LP
The specified path for the temporary swap file is only checked if it is
needed. Invalid paths from environment variables are silently ignored.
.
.LP
Paths for images and temporary swap files must begin with a drive letter
prefix.
.
.LP
Almost every message from
.I D2D/98
is written to
.I stderr ;
therefore they can't be redirected with
.B COMMAND.COM .
.RE
