VERSION 2.00
Begin Form Form1 
   BackColor       =   &H00C0C0C0&
   BorderStyle     =   1  'Fixed Single
   ClientHeight    =   5790
   ClientLeft      =   1665
   ClientTop       =   2055
   ClientWidth     =   6975
   Height          =   6165
   Icon            =   DRSPCC.FRX:0000
   Left            =   1620
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   386
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   465
   Top             =   1725
   Width           =   7065
   Begin CommandButton View 
      Caption         =   "Sho&w log-file"
      Height          =   315
      Left            =   3240
      TabIndex        =   45
      Top             =   3270
      Width           =   1335
   End
   Begin CommandButton Stop_t 
      Caption         =   "S&top"
      Enabled         =   0   'False
      Height          =   375
      Left            =   2640
      TabIndex        =   47
      Top             =   5280
      Width           =   1695
   End
   Begin Frame Parameters 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Parameters"
      Height          =   1935
      Left            =   1920
      TabIndex        =   53
      Top             =   1320
      Width           =   4815
      Begin VScrollBar TScroll 
         Height          =   285
         Left            =   2400
         Max             =   3
         Min             =   999
         TabIndex        =   55
         TabStop         =   0   'False
         Top             =   720
         Value           =   3
         Width           =   255
      End
      Begin VScrollBar SScroll 
         Height          =   285
         Left            =   2400
         Max             =   1
         Min             =   999
         TabIndex        =   54
         TabStop         =   0   'False
         Tag             =   "5"
         Top             =   360
         Value           =   5
         Width           =   255
      End
      Begin CommandButton Batch_Help 
         Caption         =   " ?"
         Height          =   255
         Left            =   3360
         TabIndex        =   44
         Top             =   720
         Width           =   255
      End
      Begin CommandButton Log_Help 
         Caption         =   " ?"
         Height          =   255
         Left            =   2760
         TabIndex        =   43
         Top             =   1080
         Width           =   255
      End
      Begin CommandButton Turns_Help 
         Caption         =   " ?"
         Height          =   255
         Left            =   2760
         TabIndex        =   42
         Top             =   720
         Width           =   255
      End
      Begin CommandButton Size_Help 
         Caption         =   " ?"
         Height          =   255
         Left            =   2760
         TabIndex        =   41
         Top             =   360
         Width           =   255
      End
      Begin CheckBox Batch 
         BackColor       =   &H00C0C0C0&
         Caption         =   "&Batch mode"
         Height          =   255
         Left            =   3360
         TabIndex        =   40
         Top             =   360
         Width           =   1335
      End
      Begin TextBox Size 
         Alignment       =   1  'Right Justify
         Height          =   285
         Left            =   1680
         MaxLength       =   6
         TabIndex        =   34
         Text            =   "1"
         Top             =   360
         Width           =   735
      End
      Begin TextBox Turns 
         Alignment       =   1  'Right Justify
         Height          =   285
         Left            =   1680
         MaxLength       =   3
         TabIndex        =   36
         Text            =   "3"
         Top             =   720
         Width           =   735
      End
      Begin TextBox Log_f 
         Height          =   285
         Left            =   120
         MaxLength       =   80
         TabIndex        =   39
         Top             =   1440
         Width           =   4575
      End
      Begin CommandButton Log_sel 
         Caption         =   "Se&lect"
         Height          =   278
         Left            =   1680
         TabIndex        =   38
         Top             =   1080
         Width           =   975
      End
      Begin Line Line3 
         X1              =   3195
         X2              =   3195
         Y1              =   300
         Y2              =   1340
      End
      Begin Label Label2 
         BackColor       =   &H00FFFFFF&
         BackStyle       =   0  'Transparent
         Caption         =   "Test-file s&ize:"
         Height          =   255
         Left            =   120
         TabIndex        =   33
         Top             =   360
         Width           =   1215
      End
      Begin Label Turn_lbl 
         BackColor       =   &H00FFFFFF&
         BackStyle       =   0  'Transparent
         Caption         =   "Number of &turns:"
         Height          =   255
         Left            =   120
         TabIndex        =   35
         Top             =   720
         Width           =   1455
      End
      Begin Label Label4 
         BackColor       =   &H00FFFFFF&
         BackStyle       =   0  'Transparent
         Caption         =   "&Log-file to use:"
         Height          =   255
         Left            =   120
         TabIndex        =   37
         Top             =   1080
         Width           =   1455
      End
   End
   Begin TextBox Status 
      Height          =   1335
      Left            =   1920
      MultiLine       =   -1  'True
      ScrollBars      =   3  'Both
      TabIndex        =   52
      TabStop         =   0   'False
      Top             =   3600
      Width           =   4815
   End
   Begin CommandButton Quit 
      Caption         =   "&Quit"
      Height          =   375
      Left            =   4920
      TabIndex        =   48
      Top             =   5280
      Width           =   1695
   End
   Begin CommandButton Drsp_do 
      Caption         =   "R&un test(s)"
      Height          =   375
      Left            =   360
      TabIndex        =   46
      Top             =   5280
      Width           =   1695
   End
   Begin Frame RO 
      BackColor       =   &H00C0C0C0&
      Height          =   1095
      Left            =   1920
      TabIndex        =   49
      Top             =   120
      Width           =   2295
      Begin CommandButton RO_Help 
         Caption         =   " ?"
         Height          =   255
         Left            =   1920
         TabIndex        =   32
         Top             =   240
         Width           =   255
      End
      Begin OptionButton RSW 
         BackColor       =   &H00C0C0C0&
         Caption         =   "&Multi-pass"
         Enabled         =   0   'False
         Height          =   255
         Index           =   1
         Left            =   120
         TabIndex        =   31
         Top             =   720
         Width           =   1695
      End
      Begin OptionButton RSW 
         BackColor       =   &H00C0C0C0&
         Caption         =   "&Single-pass"
         Enabled         =   0   'False
         Height          =   255
         Index           =   0
         Left            =   120
         TabIndex        =   30
         Top             =   360
         Value           =   -1  'True
         Width           =   1695
      End
      Begin CheckBox RO_tgl 
         BackColor       =   &H00C0C0C0&
         Caption         =   "&Read-only mode"
         Height          =   255
         Left            =   120
         TabIndex        =   29
         Top             =   0
         Width           =   1695
      End
   End
   Begin Frame Drives 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Drives"
      Height          =   4815
      Left            =   240
      TabIndex        =   0
      Top             =   120
      Width           =   1455
      Begin CommandButton Drv_Help 
         Caption         =   " ?"
         Height          =   255
         Left            =   600
         TabIndex        =   28
         Top             =   360
         Width           =   255
      End
      Begin CheckBox Drv_all 
         BackColor       =   &H00C0C0C0&
         Caption         =   "Select &all"
         Height          =   255
         Left            =   120
         TabIndex        =   27
         Top             =   4320
         Width           =   1215
      End
      Begin CheckBox Drv 
         BackColor       =   &H00C0C0C0&
         Caption         =   "Z:"
         Enabled         =   0   'False
         Height          =   255
         Index           =   25
         Left            =   840
         TabIndex        =   26
         Top             =   3840
         Width           =   495
      End
      Begin CheckBox Drv 
         BackColor       =   &H00C0C0C0&
         Caption         =   "Y:"
         Enabled         =   0   'False
         Height          =   255
         Index           =   24
         Left            =   840
         TabIndex        =   25
         Top             =   3600
         Width           =   495
      End
      Begin CheckBox Drv 
         BackColor       =   &H00C0C0C0&
         Caption         =   "X:"
         Enabled         =   0   'False
         Height          =   255
         Index           =   23
         Left            =   840
         TabIndex        =   24
         Top             =   3360
         Width           =   495
      End
      Begin CheckBox Drv 
         BackColor       =   &H00C0C0C0&
         Caption         =   "W:"
         Enabled         =   0   'False
         Height          =   255
         Index           =   22
         Left            =   840
         TabIndex        =   23
         Top             =   3120
         Width           =   495
      End
      Begin CheckBox Drv 
         BackColor       =   &H00C0C0C0&
         Caption         =   "V:"
         Enabled         =   0   'False
         Height          =   255
         Index           =   21
         Left            =   840
         TabIndex        =   22
         Top             =   2880
         Width           =   495
      End
      Begin CheckBox Drv 
         BackColor       =   &H00C0C0C0&
         Caption         =   "U:"
         Enabled         =   0   'False
         Height          =   255
         Index           =   20
         Left            =   840
         TabIndex        =   21
         Top             =   2640
         Width           =   495
      End
      Begin CheckBox Drv 
         BackColor       =   &H00C0C0C0&
         Caption         =   "T:"
         Enabled         =   0   'False
         Height          =   255
         Index           =   19
         Left            =   840
         TabIndex        =   20
         Top             =   2400
         Width           =   495
      End
      Begin CheckBox Drv 
         BackColor       =   &H00C0C0C0&
         Caption         =   "S:"
         Enabled         =   0   'False
         Height          =   255
         Index           =   18
         Left            =   840
         TabIndex        =   19
         Top             =   2160
         Width           =   495
      End
      Begin CheckBox Drv 
         BackColor       =   &H00C0C0C0&
         Caption         =   "R:"
         Enabled         =   0   'False
         Height          =   255
         Index           =   17
         Left            =   840
         TabIndex        =   18
         Top             =   1920
         Width           =   495
      End
      Begin CheckBox Drv 
         BackColor       =   &H00C0C0C0&
         Caption         =   "Q:"
         Enabled         =   0   'False
         Height          =   255
         Index           =   16
         Left            =   840
         TabIndex        =   17
         Top             =   1680
         Width           =   495
      End
      Begin CheckBox Drv 
         BackColor       =   &H00C0C0C0&
         Caption         =   "P:"
         Enabled         =   0   'False
         Height          =   255
         Index           =   15
         Left            =   840
         TabIndex        =   16
         Top             =   1440
         Width           =   495
      End
      Begin CheckBox Drv 
         BackColor       =   &H00C0C0C0&
         Caption         =   "O:"
         Enabled         =   0   'False
         Height          =   255
         Index           =   14
         Left            =   840
         TabIndex        =   15
         Top             =   1200
         Width           =   495
      End
      Begin CheckBox Drv 
         BackColor       =   &H00C0C0C0&
         Caption         =   "N:"
         Enabled         =   0   'False
         Height          =   255
         Index           =   13
         Left            =   840
         TabIndex        =   14
         Top             =   960
         Width           =   495
      End
      Begin CheckBox Drv 
         BackColor       =   &H00C0C0C0&
         Caption         =   "M:"
         Enabled         =   0   'False
         Height          =   255
         Index           =   12
         Left            =   120
         TabIndex        =   13
         Top             =   3840
         Width           =   495
      End
      Begin CheckBox Drv 
         BackColor       =   &H00C0C0C0&
         Caption         =   "L:"
         Enabled         =   0   'False
         Height          =   255
         Index           =   11
         Left            =   120
         TabIndex        =   12
         Top             =   3600
         Width           =   495
      End
      Begin CheckBox Drv 
         BackColor       =   &H00C0C0C0&
         Caption         =   "K:"
         Enabled         =   0   'False
         Height          =   255
         Index           =   10
         Left            =   120
         TabIndex        =   11
         Top             =   3360
         Width           =   495
      End
      Begin CheckBox Drv 
         BackColor       =   &H00C0C0C0&
         Caption         =   "J:"
         Enabled         =   0   'False
         Height          =   255
         Index           =   9
         Left            =   120
         TabIndex        =   10
         Top             =   3120
         Width           =   495
      End
      Begin CheckBox Drv 
         BackColor       =   &H00C0C0C0&
         Caption         =   "I:"
         Enabled         =   0   'False
         Height          =   255
         Index           =   8
         Left            =   120
         TabIndex        =   9
         Top             =   2880
         Width           =   495
      End
      Begin CheckBox Drv 
         BackColor       =   &H00C0C0C0&
         Caption         =   "H:"
         Enabled         =   0   'False
         Height          =   255
         Index           =   7
         Left            =   120
         TabIndex        =   8
         Top             =   2640
         Width           =   495
      End
      Begin CheckBox Drv 
         BackColor       =   &H00C0C0C0&
         Caption         =   "G:"
         Enabled         =   0   'False
         Height          =   255
         Index           =   6
         Left            =   120
         TabIndex        =   7
         Top             =   2400
         Width           =   495
      End
      Begin CheckBox Drv 
         BackColor       =   &H00C0C0C0&
         Caption         =   "F:"
         Enabled         =   0   'False
         Height          =   255
         Index           =   5
         Left            =   120
         TabIndex        =   6
         Top             =   2160
         Width           =   495
      End
      Begin CheckBox Drv 
         BackColor       =   &H00C0C0C0&
         Caption         =   "E:"
         Enabled         =   0   'False
         Height          =   255
         Index           =   4
         Left            =   120
         TabIndex        =   5
         Top             =   1920
         Width           =   495
      End
      Begin CheckBox Drv 
         BackColor       =   &H00C0C0C0&
         Caption         =   "D:"
         Enabled         =   0   'False
         Height          =   255
         Index           =   3
         Left            =   120
         TabIndex        =   4
         Top             =   1680
         Width           =   495
      End
      Begin CheckBox Drv 
         BackColor       =   &H00C0C0C0&
         Caption         =   "C:"
         Enabled         =   0   'False
         Height          =   255
         Index           =   2
         Left            =   120
         TabIndex        =   3
         Top             =   1440
         Width           =   495
      End
      Begin CheckBox Drv 
         BackColor       =   &H00C0C0C0&
         Caption         =   "B:"
         Enabled         =   0   'False
         Height          =   255
         Index           =   1
         Left            =   120
         TabIndex        =   2
         Top             =   1200
         Width           =   495
      End
      Begin CheckBox Drv 
         BackColor       =   &H00C0C0C0&
         Caption         =   "A:"
         Enabled         =   0   'False
         ForeColor       =   &H00000000&
         Height          =   255
         Index           =   0
         Left            =   120
         TabIndex        =   1
         Top             =   960
         Width           =   495
      End
      Begin Line Line1 
         X1              =   720
         X2              =   720
         Y1              =   960
         Y2              =   4080
      End
   End
   Begin Line Line4 
      BorderColor     =   &H00FFFFFF&
      X1              =   8
      X2              =   456
      Y1              =   345
      Y2              =   345
   End
   Begin Label Label6 
      Alignment       =   2  'Center
      BackStyle       =   0  'Transparent
      Caption         =   "DriveSpeed 3.10"
      FontBold        =   -1  'True
      FontItalic      =   -1  'True
      FontName        =   "Times New Roman"
      FontSize        =   18
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   915
      Left            =   4680
      TabIndex        =   50
      Top             =   240
      Width           =   1815
   End
   Begin Line Line2 
      BorderWidth     =   3
      X1              =   8
      X2              =   456
      Y1              =   344
      Y2              =   344
   End
   Begin Label Label5 
      BackColor       =   &H00FFFFFF&
      BackStyle       =   0  'Transparent
      Caption         =   "Latest status:"
      Height          =   255
      Left            =   1920
      TabIndex        =   51
      Top             =   3360
      Width           =   1215
   End
End
'
'  DRSPCC - DriveSpeed Control Center for DriveSpeed version 3.10 (GPL FREEWARE)
'  Copyleft (l) Stanislav Sokolov, May 2000 and onwards.
'
'  This program is subject to GNU General Public License ver. 2 of June 1991
'  and any later version.
'
'  You may use this source with your programs, provided
'  due credits are given.
'
'  Contact the author by e-mail: stanislavs@hotmail.com
'
'  Internet:  http://members.tripod.com/~stanislavs/prog/prog.htm
'

DefInt A-Z
Option Explicit

Dim Params(0 To 25) As Parameters
Dim NL As String
Dim CurDrv As Integer
Dim Stopped As Integer
Dim Running As Integer
Dim DrspHWnd As Integer

Sub Batch_Help_Click ()
    Dim t As String

    t = "Check this box if you want DRSP to run in batch mode." & NL & NL
    t = t & "In batch mode DRSP will not go interactive if any of the parameters are wrong. It will neither ask for comments before writing the results to the log-file." & NL & NL
    t = t & "It is highly recommended to choose batch mode in case you are testing multiple drives. (Remember to choose this mode for all the drives that you are going to test!)"

    MsgBox t, 64, "Help on ""Batch mode"""

End Sub

Sub Drsp_do_Click ()
    Dim i, RetVal
    Dim Coml As String
    Dim ResPath As String, tmp As String
    Static res(-2 To 13) As String
    
    res(-2) = "Can't execute"
    res(-1) = "Not available"
    res(0) = "Normal exit"
    res(1) = "Aborted by user"
    res(2) = "Can't write results to the log-file"
    res(3) = "Can't open file"
    res(4) = "Can't write to file"
    res(5) = "Can't close a file"
    res(6) = "Can't delete a file"
    res(7) = "DOS ver too old"
    res(8) = "Out of memory"
    res(9) = "Math error - select a larger test-file size"
    res(10) = "No such drive or drive not ready"
    res(11) = "Test-size too small or too large - too few files on drive in read-only test"
    res(12) = "Bad number of turns selected"
    
    'Update data
    Drv_MouseDown CurDrv, 2, 0, 0, 0
    Stopped = False
    Running = True
    
    Drsp_do.Enabled = False
    Quit.Enabled = False
    Drives.Enabled = False
    RO.Enabled = False
    Parameters.Enabled = False

    stop_t.Enabled = True


    Status.Text = ""

    For i = 0 To 25
        If Drv(i).Value = 1 Then
            Coml = LCase$(Drv(i).Caption) & " " & "/s" & Trim$(Str$(Params(i).Size)) & " "
            If Params(i).RO = 0 Or Params(i).Mode = 2 Then Coml = Coml + "/t" & Trim$(Str$(Params(i).Turns)) & " "
            If Params(i).RO = 1 Then
                If Params(i).Mode = 1 Then
                    Coml = Coml & "/rs "
                Else
                    Coml = Coml & "/rm "
                End If
            End If
            If Params(i).Batch = 1 Then Coml = Coml & "/b "
            If Log_f.Text <> "" Then Coml = Coml & "/l" & LCase$(Log_f.Text) & " "
            
            Status.SelText = "Staring test:" + NL + "  drsp " + Coml + NL
            
            'Run DRSP and wait until it is finished.
            RetVal = 0
            DrspHWnd = WinExec(AppPath & RunFile & " " & Coml & "/f /k", 8)
            If DrspHWnd < 32 Then
                RetVal = -2
            Else
                Do: DoEvents: Loop Until GetModuleUsage(DrspHWnd) = 0
                DoEvents
                On Error GoTo ResTrap
                
                'Generate the path & filename, where the result value is stored.
                'If you find how to make Windows to report the return status of program,
                'please e-mail me.
                ResPath = "C:\"
                tmp = Environ$("TEMP")
                If tmp = "" Then tmp = Environ$("TMP")

                If tmp <> "" Then ResPath = tmp
                If Right$(ResPath, 1) <> "\" Then ResPath = ResPath & "\"
                
                'Read the result
                Open ResPath & ResFile For Input As #1
                    Input #1, RetVal
                Close #1
                Kill ResPath & ResFile
NoResFile:
                On Error GoTo 0
            End If
            
            Status.SelText = "  Result: " & res(RetVal) & "." & NL & "Done." & NL & NL

            SearchFile  'Read log-file
            
            'Check if the Stop-button is pressed
            If Stopped Then Exit For

        End If
    Next i
    
    stop_t.Enabled = False

    Drives.Enabled = True
    RO.Enabled = True
    Parameters.Enabled = True
    Drsp_do.Enabled = True
    Quit.Enabled = True

    Running = False
    Exit Sub

ResTrap:
    RetVal = -1
    Resume NoResFile

End Sub

Sub Drv_all_Click ()
    Dim i
    For i = 0 To 25
        If Drv(i).Enabled Then Drv(i).Value = Drv_all.Value
    Next i

End Sub

Sub Drv_Help_Click ()
    Dim t As String

    t = "Here you select the drives you wish to test" & NL & NL
    t = t & "You may select multiple drives from the ones that are available." & NL & NL
    t = t & "When you click a check-box, the parameters that you selected for that drive will be loaded. The modified parameters are saved when you select another drive. The currently active drive is marked with red." & NL & NL
    t = t & "Right-click the check-boxes to edit a new drive's parameters without changing its on/off status."

    MsgBox t, 64, "Help on ""Drives"""

End Sub

Sub Drv_MouseDown (Index As Integer, Button As Integer, Shift As Integer, X As Single, Y As Single)
    If CurDrv <> -1 Then
        Drv(CurDrv).ForeColor = 0
        RemChar Size, ",", "."
        Params(CurDrv).Size = Val(Size.Text)
        Params(CurDrv).Turns = Val(Turns.Text)
        Params(CurDrv).Batch = Batch.Value
        Params(CurDrv).RO = RO_tgl.Value
        If RSW(0).Value Then
            Params(CurDrv).Mode = 1
        Else
            Params(CurDrv).Mode = 2
        End If
    End If

    Drv(Index).ForeColor = &HFF
    CurDrv = Index
    Size.Text = Trim$(Str$(Params(CurDrv).Size))
    Turns.Text = Params(CurDrv).Turns
    TScroll.Value = Params(CurDrv).Turns
    Batch.Value = Params(CurDrv).Batch
    
    RO_tgl.Value = Params(CurDrv).RO
    If Params(CurDrv).Mode = 1 Then
        RSW(0).Value = True
    Else
        RSW(1).Value = True
    End If
    RO_tgl_Click
End Sub

Sub Form_Load ()
    Dim i

    If App.PrevInstance Then
        MsgBox "Can't run two instances of " & ProgName & " at once!", 48 + 4096, ProgName
        End
    End If

    Left = (Screen.Width - Width) / 2
    Top = (Screen.Height - Height) / 2
    NL = Chr$(13) & Chr$(10)
    AppPath = App.Path
    If Right$(AppPath, 1) <> "\" Then AppPath = AppPath & "\"

    Form1.Caption = ProgName
    Form2.Caption = ProgName & " - Select the log-file"
    Form3.Caption = ProgName & " - Log-file viewer"

    i = SendMessage(Status.hWnd, EM_SETREADONLY, True, 0)
    i = SendMessage(Form3.Viewer.hWnd, EM_SETREADONLY, True, 0)
    
    For i = 0 To Form2.Drive1.ListCount - 1
        Drv(Asc(Form2.Drive1.List(i)) - 97).Enabled = True
    Next i

    'Load defaults
    For i = 0 To 25
        Params(i).Size = 1
        Params(i).Turns = 3
        Params(i).Batch = 0
        Params(i).RO = 0
        Params(i).Mode = 1
    Next i

    'Load saved data
    On Error GoTo Trap
    Open AppPath & SavFile For Input As #1: Close #1
    Open AppPath & SavFile For Random As #1 Len = RecLen
        For i = 0 To 25
            Get #1, i + 1, Params(i)
        Next i
    Close #1
    On Error GoTo 0

NoFile:
    
    'Select active drive
    CurDrv = -1
    For i = 0 To 25
        If Drv(i).Enabled Then
            Drv_MouseDown i, 2, 0, 0, 0
            Exit For
        End If
    Next i

    Exit Sub
Trap:
    Resume NoFile

End Sub

Sub Form_QueryUnload (Cancel As Integer, UnloadMode As Integer)
    If Running Then
        MsgBox "You can't quit " & ProgName & " while the tests are running. Press Stop first!", 16, ProgName
        Cancel = True
        Exit Sub
    End If

    If MsgBox("Do you really wish to quit " & ProgName & "?", 4 + 32, ProgName) = 7 Then Cancel = True
End Sub

Sub Form_Unload (Cancel As Integer)
    Dim i

    Unload Form2

    'Update drive parameters
    Drv_MouseDown CurDrv, 2, 0, 0, 0

    'Load saved data
    On Error GoTo Trap1
    Open AppPath & SavFile For Random As #1 Len = RecLen
        For i = 0 To 25
            Put #1, i + 1, Params(i)
        Next i
    Close #1
    
Trap1:
    End

End Sub

Sub Label6_Click ()
    Dim t As String

    t = ProgName & ", ver. 3.10, GPL Freeware." & NL
    t = t & "Copyleft (l) Stanislav Sokolov, May 2000 and onwards." & NL & NL
    t = t & "This is a Windows front-end for DriveSpeed 3.10, designed to make testings easier and less scary..."

    MsgBox t, , ProgName
End Sub

Sub Log_f_LostFocus ()
    RemChar Log_f, " ", ""
    Log_f.Text = UCase$(Log_f.Text)
    SearchFile
End Sub

Sub Log_Help_Click ()
    Dim t As String

    t = "Here you can select the log-file that DRSP will append the test results to. If the file does not exist, it will be created." & NL & NL
    t = t & "If, for some reason, DRSP fails to write to the file, it will attempt using the default DRSP.LOG, placing it in the same directory as the DRSP.EXE. Leave the field blank to make DRSP use the default filename and location." & NL & NL
    t = t & "Please, keep to the 8.3 convention. Note that the log-file is common for all the drives that you test."

    MsgBox t, 64, "Help on ""Select log-file"""

End Sub

Sub Log_sel_Click ()
    'Brows base directory
    Form2.Show 1
    If Form2.Ok_btn.Tag <> "" Then Log_f.Text = UCase$(Form2.Ok_btn.Tag)
    SearchFile
End Sub

Sub Quit_Click ()
    Unload Form1
End Sub

Sub ReadFile (LogFile As String)
    Dim Text As String, tmp As String
    Dim i, j
    Dim start As Long
    ReDim s(9) As String, r(9) As String
    
    s(1) = "": r(1) = "-"
    s(2) = "": r(2) = "|"
    s(3) = "": r(3) = "+"
    s(4) = "": r(4) = "+"
    s(5) = "": r(5) = "+"
    s(6) = "": r(6) = "+"
    s(7) = "": r(7) = "+"
    s(8) = "": r(8) = "+"
    s(9) = "": r(9) = "+"

    On Error GoTo View_Trap

    Form3.Viewer.Text = ""

    Open LogFile For Input As #1: Close #1
    Open LogFile For Binary As #1
        If LOF(1) > 32600 Then
            Form3.Viewer.Text = "Log-file is larger than 32600 bytes!" & NL & "Displaying the last 32600 bytes." & NL & NL & NL
            start = LOF(1) - 32599
            Text = Space$(32600)
        Else
            start = 1
            Text = Space$(LOF(1))
        End If

        Get #1, start, Text
    Close #1
    On Error GoTo 0

    'Go through the file and replace DOS pseudo-graphics
    For i = 1 To 9
        j = InStr(Text, s(i))
        While j <> 0
            Mid$(Text, j, 1) = r(i)
            j = InStr(j + 1, Text, s(i))
        Wend
    Next i

    Form3.Viewer.Text = Form3.Viewer.Text + Text
    Form3.Viewer.SelStart = Len(Form3.Viewer.Text)
    Form3.LogName.Caption = UCase$(LogFile)
    Form3.DoPrint.Enabled = True
    
    Exit Sub

View_Trap:
    Form3.Viewer.Text = "Log-file not found or it has not been created yet." & NL & "Errorcode:" & Str$(Err)
    Form3.LogName.Caption = ""
    Close #1
    Exit Sub

End Sub

Sub RemChar (C As Control, in As String, out As String)
    Dim i
    
    C.Text = Trim$(C.Text)

    i = InStr(C.Text, in)
    While i <> 0
        C.Text = Left$(C.Text, i - 1) & out & Mid$(C.Text, i + 1)
        i = InStr(C.Text, in)
    Wend
End Sub

Sub RO_Help_Click ()
    Dim t As String

    t = "Check the ""Read-only mode"" box if you want to run a read-only test on a spesific drive. Select then one of the two modes of testing. Note that in ""single-pass"" mode the ""Number of turns"" text-box is greyed out." & NL & NL
    t = t & """Single-pass mode"" is more accurate. It is performed by finding 17 largest files on the drive and reading them in seqence. Thus, caching does not affect this test." & NL & NL
    t = t & """Multi-pass mode"" gives slightly faster results due to caching. It finds the largest file on the drive and reads it ""Number of turns"" times." & NL & NL
    t = t & "If you attempt running DRSP on a read-only drive without first selecting a read-only mode, DRSP will automaticly run in the multi-pass mode. This mode is chosen for compatibility reasons."

    MsgBox t, 64, "Help on ""Read-only mode"""

End Sub

Sub RO_tgl_Click ()
    If RO_tgl.Value = 1 Then
        RSW(0).Enabled = True
        RSW(1).Enabled = True
        RSW_Click (0)
    Else
        RSW(0).Enabled = False
        RSW(1).Enabled = False
        RSW_Click (0)
    End If
End Sub

Sub RSW_Click (Index As Integer)
   If RSW(1).Value And RO_tgl.Value = 1 Then
        Turns.Enabled = True
        TScroll.Enabled = True
   ElseIf RSW(0).Value And RO_tgl.Value = 1 Then
        Turns.Enabled = False
        TScroll.Enabled = False
   Else
        Turns.Enabled = True
        TScroll.Enabled = True
   End If

End Sub

Sub SearchFile ()
    Dim LogFile As String, TryPath As String, Path As String
    Dim ErrFlag, i, start_t, stop_t

    On Error GoTo Try
    Form3.DoPrint.Enabled = False
    
    'Try selected file
    ErrFlag = False
    LogFile = Form1.Log_f.Text
    Open LogFile For Input As #1: Close #1
    If Not ErrFlag Then
        ReadFile LogFile
        Exit Sub
    End If

    'Try current dir
    ErrFlag = False
    Open ".\DRSP.EXE" For Input As #1: Close #1
    If Not ErrFlag Then
        ReadFile ".\DRSP.LOG"
        Exit Sub
    End If

    'Try WINDOWS dir
    ErrFlag = False
    TryPath = Space(80)
    i = GetWindowsDirectory(TryPath, 80)
    If i > 0 Then
        TryPath = Trim$(TryPath)
        TryPath = Left$(TryPath, Len(TryPath) - 1)
        If Right$(TryPath, 1) <> "\" Then TryPath = TryPath & "\"
        Open TryPath & "DRSP.EXE" For Input As #1: Close #1
        If Not ErrFlag Then
            ReadFile TryPath & "DRSP.LOG"
            Exit Sub
        End If
    End If

    'Try SYSTEM dir
    ErrFlag = False
    TryPath = Space(80)
    i = GetSystemDirectory(TryPath, 80)
    If i > 0 Then
        TryPath = Trim$(TryPath)
        TryPath = Left$(TryPath, Len(TryPath) - 1)
        If Right$(TryPath, 1) <> "\" Then TryPath = TryPath & "\"
        Open TryPath & "DRSP.EXE" For Input As #1: Close #1
        If Not ErrFlag Then
            ReadFile TryPath & "DRSP.LOG"
            Exit Sub
        End If
    End If

    'Try module dir
    ErrFlag = False
    Open AppPath & "DRSP.EXE" For Input As #1: Close #1
    If Not ErrFlag Then
        ReadFile AppPath & "DRSP.LOG"
        Exit Sub
    End If

    'Try PATH envir
    Path = Environ$("PATH")
    start_t = 1
    stop_t = InStr(Path, ";")
    If stop_t = 0 Then stop_t = Len(Path)
    Do
        ErrFlag = False

        TryPath = Mid$(Path, start_t, stop_t - start_t)
        If Right$(TryPath, 1) <> "\" Then TryPath = TryPath & "\"
        Open TryPath & "DRSP.EXE" For Input As #1: Close #1
        If Not ErrFlag Then
            ReadFile TryPath & "DRSP.LOG"
            Exit Sub
        End If
        
        start_t = stop_t + 1
        stop_t = InStr(start_t + 1, Path, ";")
        If stop_t = 0 Then stop_t = Len(Path) + 1

    Loop While start_t <> Len(Path) + 2

    On Error GoTo 0

    Form3.Viewer.Text = "Log-file not found or it has not been created yet."
    Form3.LogName.Caption = ""
    Form3.DoPrint.Enabled = True

Exit Sub


Try:
    ErrFlag = True
    Resume Next

End Sub

Sub Size_Help_Click ()
    Dim t As String

    t = "Here you specify the size of a test-file or a selection of files." + NL + NL
    t = t & "In read-write mode this is the size of the file that DRSP will generate in the root directory of the selected drive. If the size is too big, DRSP will ajust it to fit in." & NL & NL
    t = t & "In read-only multi-pass mode DRSP will search for a file that is no larger than the specified size." & NL & NL
    t = t & "In read-only sigle-pass mode DRSP will search for 17 largest files so that the total sum of the sizes does not exceed the size specified." & NL & NL
    t = t & "The valid range is 0.2MB through 999.99MB."

    MsgBox t, 64, "Help on ""Test-file size"""
End Sub

Sub Size_LostFocus ()
    RemChar Size, ",", "."
    If Val(Size.Text) < .2 Then Size.Text = "0.2"
    If Val(Size.Text) > 999.99 Then Size.Text = "999.99"
End Sub

Sub SScroll_Change ()
    Static Changing

    'Critical region
    If Not Changing Then
        Changing = True
        If SScroll.Value > Val(SScroll.Tag) Then
            Size.Text = Val(Size.Text) + .8
            If SScroll.Value = 999 Then SScroll.Value = 1
        ElseIf SScroll.Value < Val(SScroll.Tag) Then
            Size.Text = Val(Size.Text) - .8
            If SScroll.Value = 1 Then SScroll.Value = 999
        End If
        SScroll.Tag = SScroll.Value
        Size_LostFocus
        Changing = False
    End If
End Sub

Sub Stop_t_Click ()
    Dim i
    Stopped = True
    stop_t.Enabled = False
    Status.SelText = NL & NL & "Stop requested..." & NL & "Please wait until the current test is complete" & NL & "or press 'Esc' 1-2 times in the DriveSpeed window." & NL
End Sub

Sub TScroll_Change ()
    Turns.Text = TScroll.Value
End Sub

Sub Turns_Help_Click ()
    Dim t As String

    t = "Here you specify the number of times the test-file is read and/or written in read-write and read-only multi-pass modes." & NL & NL
    t = t & "If you choose the read-only single-pass mode this option will be unavailable." & NL & NL
    t = t & "The valid range is 3 through 999."

    MsgBox t, 64, "Help on ""Number of turns"""
End Sub

Sub Turns_LostFocus ()
    If Val(Turns.Text) < 3 Then Turns.Text = "3"
    If Val(Turns.Text) > 999 Then Turns.Text = "999"
    TScroll.Value = Val(Turns.Text)
End Sub

Sub View_Click ()
    SearchFile
    Form3.Show
End Sub

