/* Definable parameters for fsQuick. Parameters cannot necessarily
   be set to arbitrary values independently.  Not well-tested with
   different parameters.
*/

/* A consumer of fsQuick.h may need the following: */

#ifndef fsQ_UCHAR
#define fsQ_UCHAR unsigned char
#endif /* fsQ_UCHAR */

#ifndef fsQ_PIC_VALS
#define fsQ_PIC_VALS 256 /* number of values in input picture pixel */
#endif /* fsQ_PIC_VALS */

#ifndef fsQ_PIC_TYPE
#define fsQ_PIC_TYPE fsQ_UCHAR /* type of input picture pixel */
#endif /* fsQ_PIC_TYPE */

#ifndef fsQ_BITMAP_BITS
#define fsQ_BITMAP_BITS 8 /* number of bits per word in output bitmap */
#endif /* fsQ_BITMAP_BITS */

#ifndef fsQ_BITMAP_TYPE
#define fsQ_BITMAP_TYPE fsQ_UCHAR /* type of word in output bitmap */
#endif /* fsQ_BITMAP_TYPE */



/* The rest of the parameters are used only internally by fsQuick.c: */

#ifndef fsQ_THRESH_VAL
#define fsQ_THRESH_VAL (fsQ_PIC_VALS>>1) /* thresh for halftoning */
#endif /* fsQ_THRESH_VAL */

#ifndef fsQ_RANDOM
#define fsQ_RANDOM random()
#endif /* fsQ_RANDOM */

#ifndef fsQ_DEBUG
#define fsQ_DEBUG 0
#endif /* fsQ_DEBUG */

#ifndef fsQ_RANDOM_DECL
#define fsQ_RANDOM_DECL long random fsQ_proto((void))
#endif /* fsQ_RANDOM_DECL */

#ifndef fsQ_FIRST_ROW_EXTRAS
#define fsQ_FIRST_ROW_EXTRAS 12 /* this _must_ be an even number */
#endif /* fsQ_FIRST_ROW_EXTRAS */
