/*
 * I haven't tested the signals in UNIX, yet..., Frank.
 *
 * I don't have Linux, so I can't..., Jason. They work fine in djgpp, though.
 *
 * If we are in a unix environment, lets map signals to our DOS critical
 * error handler.
 *
 *
 * New editor name:  TDE, the Thomson-Davis Editor.
 * Author:           Frank Davis
 * Date:             June 5, 1991, version 1.0
 * Date:             July 29, 1991, version 1.1
 * Date:             October 5, 1991, version 1.2
 * Date:             January 20, 1992, version 1.3
 * Date:             February 17, 1992, version 1.4
 * Date:             April 1, 1992, version 1.5
 * Date:             June 5, 1992, version 2.0
 * Date:             October 31, 1992, version 2.1
 * Date:             April 1, 1993, version 2.2
 * Date:             June 5, 1993, version 3.0
 * Date:             August 29, 1993, version 3.1
 * Date:             November 13, 1993, version 3.2
 * Date:             June 5, 1994, version 4.0
 * Date:             December 5, 1998, version 5.0 (jmh)
 *
 * This code is released into the public domain, Frank Davis.
 *    You may distribute it freely.
 */

#include "tdestr.h"
#include "common.h"
#include "tdefunc.h"
#include "unix/criterr.h"
#include <signal.h>


/*
 * Save the area of the screen that will display the Critical
 * Error info.  CEH_WIDTH and CEH_HEIGHT are the dimensions of critical
 * error screen in criterr.h.
 */
#define CEH_ROW          5
#define CEH_COL          6
#define CEH_WIDTH       68
#define CEH_HEIGHT       9
#define CEH_INFO_ROW     8
#define CEH_INFO_COL    20


/*
 * buffer for ceh info screen.
 */
Char ceh_buffer[CEH_HEIGHT][CEH_WIDTH];


/*
 * Name:    crit_err_handler
 * Purpose: Show user something is wrong and get a response
 * Date:    November 13, 1993
 * Notes:   I noticed that some signals in Linux
 */
void  crit_err_handler( int sig )
{
int  c;
char **pp;

   if (sig == SIGINT) {
      g_status.control_break = TRUE;
      return;
   }

   save_area( (Char *)ceh_buffer, CEH_WIDTH, CEH_HEIGHT, CEH_ROW, CEH_COL );
   show_strings( criterr_screen, CEH_HEIGHT, CEH_ROW, CEH_COL );
   switch (sig) {
      case SIGABRT :
         pp = sigabrt;
         break;
      case SIGALRM :
         pp = sigalrm;
         break;
      case SIGCHLD :
         pp = sigchld;
         break;
      case SIGCONT :
         pp = sigcont;
         break;
      case SIGFPE :
         pp = sigfpe;
         break;
      case SIGHUP :
         pp = sighup;
         break;
      case SIGILL :
         pp = sigill;
         break;
      /*
      case SIGINT :
         pp = sigint;
         break;
      */
      case SIGIO :
         pp = sigio;
         break;
/*
 * SIGIOT and SIGABRT share same signal in linux????, Frank
 *
      case SIGIOT :
         pp = sigiot;
         break;
*/
      case SIGKILL :
         pp = sigkill;
         break;
      case SIGPIPE :
         pp = sigpipe;
         break;
/*
 * SIGPOLL, SIGIO, and SIGURG share the same signal in linux???, Frank
 *
      case SIGPOLL :
         pp = sigpoll;
         break;
 */
      /*
       * is TDE supposed to catch profiler signals?
      case SIGPROF :
         break;
      */
      case SIGPWR :
         pp = sigpwr;
         break;
      case SIGQUIT :
         pp = sigquit;
         break;
      case SIGSEGV :
         pp = sigsegv;
         break;
      case SIGSTOP :
         pp = sigstop;
         break;
      case SIGTERM :
         pp = sigterm;
         break;
      case SIGTRAP :
         pp = sigtrap;
         break;
      case SIGTSTP :
         pp = sigtstp;
         break;
      case SIGTTIN :
         pp = sigttin;
         break;
      case SIGTTOU :
         pp = sigttou;
         break;
/*
 * SIGPOLL, SIGIO, and SIGURG share the same signal in linux???, Frank
 *
      case SIGURG  :
         pp = sigurg;
         break;
 */
      case SIGUSR1 :
         pp = sigusr1;
         break;
      case SIGUSR2 :
         pp = sigusr2;
         break;
      case SIGVTALRM :
         pp = sigvtalrm;
         break;
      case SIGWINCH :
         pp = sigwinch;
         break;
      case SIGXCPU :
         pp = sigxcpu;
         break;
      case SIGXFSZ :
         pp = sigxfsz;
         break;
      default :
         pp = NULL;
         break;
   }
   if (pp != NULL)
      show_strings( pp, 3, CEH_INFO_ROW, CEH_INFO_COL );

   xygoto( -1, -1 );
   c = get_response( NULL, 0, 0, 2, L_CONTINUE, L_CONTINUE, L_ABORT, L_ABORT);
   restore_area( (Char *)ceh_buffer, CEH_WIDTH, CEH_HEIGHT, CEH_ROW, CEH_COL );
   if (c == L_ABORT) 
      exit( 1 );
   else
      xygoto( 0, g_display.mode_line );
}
