/****************************************************************************
 *
 *	Program Name : CPT.C
 *
 *	Written By : Eng-Huat Ong and Kian-Mong Low.
 *
 *	This program generates the Candidate Product Term (CPT) given an
 *	array of minterm plus its adjacent minterms.
 *
 *	Returns	pointer to an array of a single CPT (a cube in ASCII)
 *
 * --------------------------------------------------------------------------
 *	Copyright (c) 1992. All Rights Reserved. Nanyang Technological
 *	University.
 *
 *	You are free to use, copy and distribute this software and its
 *	documentation providing that:
 *
 *		NO FEE IS CHARGED FOR USE, COPYING OR DISTRIBUTION.
 *
 *		IT IS NOT MODIFIED IN ANY WAY.
 *
 *		THE COPYRIGHT NOTICE APPEAR IN ALL COPIES.
 *
 *	This program is provided "AS IS" without any warranty, expressed or
 *	implied, including but not limited to fitness for any particular
 *	purpose.
 *
 *	If you find NTUMIN fast, easy, and useful, a note or comment would be
 *	appreciated. Please send to:
 *
 *		Boon-Tiong Tan or Othman Bin Ahmad
 *		School of EEE
 *		Nanyang Technological University
 *		Nanyang Avenue
 *		Singapore 2263
 *		Republic of Singapore
 *
 ***************************************************************************/

#include <stdio.h>
#include <stdlib.h>

unsigned char   *cpt(c)
unsigned char   *c;

{
   unsigned char     n, bit1, bit2, nspm, adj, *d, i, j;

   n    = *c;                          	      /* no. of variables */
   adj  = *(c+1);                      	      /* no. of adjacent terms */
   nspm = *(c+3);                             /* no. of bytes/minterm */

   d = (unsigned char *) malloc(n+1);         /* space for CPT */
   if (d == 0)
      {
	 printf("Out of memory -- CPT, *d\n");
	 printf("Program terminated - 1\n");
	 exit(0);
      }

   for (i=0; i<n; i++)                        /* do for no. of variables */
      {
	 bit1 = *(c+4+(i/8)) & (1<<(i%8));    /* the minterm */

	 for (j=1; j<=adj; j++)               /* no. of adj terms */
	    {
	       bit2 = *(c+4+j*nspm+(i/8)) & (1<<(i%8));   /* adj terms */
	       if (bit2 != bit1)              /* column with both 0's and 1's */
		  {
		     *(d+i) = 'X';            /* CPT's position contains X */
		     break;
		  }
	    }

	 if (bit2==bit1 || adj==0)            /* column with only 0's or 1's */
	    {
	       if (bit1 == 0)                 /* column with only 0's */
		  *(d+i) = '0';               /* CPT's position contains 0 */
	       else                           /* column with only 1's */
		  *(d+i) = '1';               /* CPT's position contains 1 */
	    }
      }
   *(d+n) = '\0';                             /* terminating null string */

   return(d);                                 /* return CPT */
}