/****************************************************************************
 *
 *      Program name : FPRTOUT.C
 *
 *	Written By : Eng-Huat Ong and Kian-Mong Low.
 *
 *      This program prints the solution cubes to the output file given
 *	the solution array. It also prints the solution array to the screen.
 *
 * --------------------------------------------------------------------------
 *	Copyright (c) 1992. All Rights Reserved. Nanyang Technological
 *	University.
 *
 *	You are free to use, copy and distribute this software and its
 *	documentation providing that:
 *
 *		NO FEE IS CHARGED FOR USE, COPYING OR DISTRIBUTION.
 *
 *		IT IS NOT MODIFIED IN ANY WAY.
 *
 *		THE COPYRIGHT NOTICE APPEAR IN ALL COPIES.
 *
 *	This program is provided "AS IS" without any warranty, expressed or
 *	implied, including but not limited to fitness for any particular
 *	purpose.
 *
 *	If you find NTUMIN fast, easy, and useful, a note or comment would be
 *	appreciated. Please send to:
 *
 *		Boon-Tiong Tan or Othman Bin Ahmad
 *		School of EEE
 *		Nanyang Technological University
 *		Nanyang Avenue
 *		Singapore 2263
 *		Republic of Singapore
 *
 ***************************************************************************/

#include <stdio.h>

void           fprtout(s, out)
FILE           *out;
unsigned char  *s;

{
   unsigned short  m1, m2, m, i;
   unsigned char   n, j;


   n = *s;                       /* no. of variables */

   m1 = *(s+1);
   m2 = *(s+2);
   m =  m2<<8 | m1;              /* no. of cubes */

   for (i=0; i<m; i++)
      {
	 for (j=n; j>0; j--)
	    {
	       printf("%c", *(s+3+n*i+j));
	       fprintf(out, "%c", *(s+3+n*i+j));
	    }

	 printf("\n");
	 fprintf(out, "\n");
      }
}
