/****************************************************************************
 *
 *	Program Name : CONVERT.C
 *
 *	Written By : Eng-Huat Ong and Kian-Mong Low.
 *
 *	This program converts output file generated by VAX C to a format
 *	compatible with MS-DOS or PC-DOS.
 *
 * --------------------------------------------------------------------------
 *	Copyright (c) 1992. All Rights Reserved. Nanyang Technological
 *	University.
 *
 *	You are free to use, copy and distribute this software and its
 *	documentation providing that:
 *
 *		NO FEE IS CHARGED FOR USE, COPYING OR DISTRIBUTION.
 *
 *		IT IS NOT MODIFIED IN ANY WAY.
 *
 *		THE COPYRIGHT NOTICE APPEAR IN ALL COPIES.
 *
 *	This program is provided "AS IS" without any warranty, expressed or
 *	implied, including but not limited to fitness for any particular
 *	purpose.
 *
 *	If you find NTUMIN fast, easy, and useful, a note or comment would be
 *	appreciated. Please send to:
 *
 *		Boon-Tiong Tan or Othman Bin Ahmad
 *		School of EEE
 *		Nanyang Technological University
 *		Nanyang Avenue
 *		Singapore 2263
 *		Republic of Singapore
 *
 ***************************************************************************/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

main()

{
   unsigned char     *infile, *outfile;           /* filenames */
	    char     c, ans;
   FILE              *in, *out;                   /* file pointers */

   printf("This program is for converting output files generated by VAX machine to\n");
   printf("one compatible with MS-DOS or PC-DOS\n\n");
   printf("Press any key to Continue or <ESC> to QUIT\n\n");
   c = getch();
   if (c==27)
      exit(0);

   infile = (unsigned char *) malloc (21);	  /* allocate space */
   if (infile==0)
      {
	 printf("Out of memory -- CONVERT, *infile\n");
	 printf("Program terminated - 1\n");
	 exit(0);
      }

   outfile = (unsigned char *)malloc (21);	  /* allocate space */
   if (outfile==0)
      {
	 printf("Out of memory -- CONVERT, *outfile\n");
	 printf("Program terminated - 2\n");
	 exit(0);
      }

   printf("Enter input filename -> ");
   gets(infile);                            /* read input filename */

   printf("Enter output filename -> ");
   gets(outfile);                           /* read output filename */

   printf("Please hang on, doing conversion ... \n\n");

   if ((in = fopen(infile, "r+")) == NULL)             /* open 1st file */
      {
	 printf("Error opening file, %s\n", infile);
	 printf("Program terminated - 3\n");
	 exit(0);
      }

   if ((out = fopen(outfile, "w+")) == NULL)           /* open 2nd file */
      {
	 printf("Error opening file, %s\n", outfile);
	 printf("Program terminated - 4\n");
	 exit(0);
      }

   while ((c=fgetc(in)) != EOF)                /* get char from infile */
	 {
	    if (c=='J')                        /* treat 'J' as CR */
	       fprintf(out, "\n");
	    else
	       fprintf(out, "%c", c);          /* put char to outfile */
	 }

   free(infile);                               /* free pointers */
   free(outfile);

   fclose(in);                                 /* close files */
   fclose(out);

   printf("Conversion Completed.\n");
}

