/***************************************************************************
 *
 *	Program Name : SORTER.C
 *
 *	Written By : Eng-Huat Ong and Kian-Mong Low.
 *
 *	This program sorts cubes in the input file before minimization in
 *	the order of 01X. ie. ascending order.
 *
 * --------------------------------------------------------------------------
 *	Copyright (c) 1992. All Rights Reserved. Nanyang Technological
 *	University.
 *
 *	You are free to use, copy and distribute this software and its
 *	documentation providing that:
 *
 *		NO FEE IS CHARGED FOR USE, COPYING OR DISTRIBUTION.
 *
 *		IT IS NOT MODIFIED IN ANY WAY.
 *
 *		THE COPYRIGHT NOTICE APPEAR IN ALL COPIES.
 *
 *	This program is provided "AS IS" without any warranty, expressed or
 *	implied, including but not limited to fitness for any particular
 *	purpose.
 *
 *	If you find NTUMIN fast, easy, and useful, a note or comment would be
 *	appreciated. Please send to:
 *
 *		Boon-Tiong Tan or Othman Bin Ahmad
 *		School of EEE
 *		Nanyang Technological University
 *		Nanyang Avenue
 *		Singapore 2263
 *		Republic of Singapore
 *
 ***************************************************************************
 *
 *	n	== no. of variables
 *	cu, cu1 == no. of cubes
 *	i, k	== counters
 *
 ***************************************************************************/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>


main()

{
   unsigned char     *infile, *outfile, *np, *cp, *cube, *temp;
   unsigned char     n, k, c;
	     int     test;
   unsigned long     cu, cu1, i;
   FILE              *in, *out;             /* file pointer */

   printf("This program sorts cubes in order of '01X' (ie. ascending order) before\n");
   printf("subjecting them to minimization. \n\n");
   printf("Press any key to Continue or <ESC> to QUIT\n\n");
   c = getch();
   if (c==27)
      exit(0);

   infile = (unsigned char *)malloc (21);      /* space for input filename */
   if (infile==0)
      {
	 printf("Out of memory -- SORTER, *infile\n");
	 printf("Program Terminated - 1\n");
	 exit(0);
      }

   outfile = (unsigned char *)malloc (21);    /* space for output filename */
   if (outfile==0)
      {
	 printf("Out of memory -- SORTER, *outfile\n");
	 printf("Program Terminated - 2\n");
	 exit(0);
      }

   printf("Enter input filename -> ");
   gets(infile);                                 /* get input filename */

   printf("Enter output filename -> ");
   gets(outfile);                               /* get output filename */

   printf("Please hang on, sorting in process ... \n\n");

   if ((in = fopen(infile, "r+")) == NULL)          /* open input file */
      {
	 printf("Error opening file, %s\n", infile);
	 printf("Program terminated.\n");
	 exit(0);
      }

   if ((out = fopen(outfile, "w")) == NULL)        /* open output file */
      {
	 printf("Error opening file, %s\n", outfile);
	 printf("Program terminated.\n");
	 exit(0);
      }

   np = (unsigned char *)malloc(4);            /* space for no. of var */
   if (np==0)
      {
	 printf("Out of memory -- SORTER, *np\n");
	 printf("Program Terminated - 3\n");
	 exit(0);
      }

   fgets(np, 4, in);                           /* get no. of variables */
   n = atoi(np);                                   /* no. of variables */
   free(np);                                           /* free pointer */
   fprintf(out, "%d\n", n);                        /* print to outfile */

   cp = (unsigned char *)malloc(5);          /* space for no. of cubes */
   if (cp==0)
      {
	 printf("Out of memory -- SORTER, *cp\n");
	 printf("Program Terminated - 4\n");
	 exit(0);
      }

   temp = (unsigned char *)malloc(n+2);           /* temporary storage */
   if (temp==0)
      {
	 printf("Out of memory -- SORTER, *temp\n");
	 printf("Program Terminated - 5\n");
	 exit(0);
      }

   for (k=0; k<2; k++)
      {
	 fgets(cp, 5, in);                         /* get no. of cubes */
	 cu = atoi(cp);                            /* ascii to integer */
	 fprintf(out, "%d\n", cu);                 /* print to outfile */

	 if (cu==0)                                /* zero cube */
	    break;

	 cube = (unsigned char *)malloc(n*cu);     /* space for all cubes */
	 if (cube==0)
	    {
	       printf("Out of memory -- SORTER, *cube\n");
	       printf("Program Terminated - 6\n");
	       exit(0);
	    }

	 for (i=0; i<cu; i++)                /* read and store all cubes */
	    {
	       fgets(temp, n+2, in);
	       memcpy((cube+n*i), temp, n);
	    }

	 cu1 = cu;

	 while (cu-- > 1)                    /* bubble sort algorithm */
	    {
	       for (i=0; i<cu; i++)
		  {
		     test = memcmp((cube+n*i), (cube+n*(i+1)), n); /* compare adjacent minterms */

		     if (test > 0)            /* 1st term > 2nd term */
			{
			   memcpy(temp, (cube+n*i), n);          /* swap */
			   memcpy((cube+n*i), (cube+n*(i+1)), n);
			   memcpy((cube+n*(i+1)), temp, n);
			}

		     else if (test==0)          /* duplicate cubes */
			{
			   memcpy((cube+n*i), (cube+n*(i+1)), n*(cu1-i)); /* remove duplicate */
			   i--;
			}
		  }
	    }

	 for (i=0; i<cu1; i++)        /* print sorted cubes to outfile */
	    {
	       memcpy(temp, (cube+n*i),  n);
	       *(temp+n) = '\0';
	       fprintf(out, "%s\n", temp);
	    }
	 free(cube);                  /* free pointer */
      }

   fclose(in);                        /* close files */
   fclose(out);
   free(cp);                          /* free pointers */
   free(temp);
   free(in);
   free(out);

   printf("Sorting completed.\n");
}

