#ifndef LIST_H
#define LIST_H

/* =======================================================
File name:	list.h     (for UNIX)

Author:		Computing Science Department of Newcastle University
		and modified by Zijian Huang

Purpose:	A list structure.

		Zijian Huang changed return type of some functions and constances in
		file "listnode.h" as comments below. Under different conditions, user 
		of this program can modify them back the original form of return type of 
		functions.

		Since different compilers process templates in different ways,
		users may have to modify the program on a particular system.
		If you use Borland C++ or other compilers that fit the specification
		of C++ template, you may have to insert the content of "list.c" into
		this file, then no explict object code of the templates will be needed.
				
Date:		December, 1994
================================================================== */

#include <iostream.h>
#include "bool.h"
#include "listnode.h"

template <class T>
class List
{
public:

//
// Constructor
//

	List () ;
	
//
// Copy constructor
//

	List ( List<T>& ) ;

//
// Assignment operator
//

	List<T>&	operator = ( List<T>& ) ;	// originally, <T>
        
//
// Destructor
//

	~List () ;

//
// Member functions
//

	void	insertAtHead ( T item ) ;
	void	insertAtTail ( T item ) ;

	void	deleteHead () ;
	void	deleteTail () ;
	
	T&		itemAtHead () ;	// originally, T. Reference type make thing faster.
	T&		itemAtTail () ; // originally, T
	
	bool	isEmpty () ;
	
	void	start () ;
	void	next () ;
	bool	atEnd () ;

	T&		current () ;	// originally, T
	T		itemAtCurrent () ;
	
	 void    insertAfterCurrent ( T item ) ;
    void    insertBeforeCurrent ( T item ) ;

    void    deleteCurrent () ;
    
	 friend void sortList(List<T>&, bool (*compare)(const T&, const T&));

private:

//
// Private operations
//

	void copy ( List<T>& copy ) ;
	void deleteList () ;

//
// Data representation
//

	ListNode<T>*	head ;
	ListNode<T>*	tail ;
	ListNode<T>*	currentNode ;
	ListNode<T>*	previousNode ;
} ;


#endif

