************************************************************************************
lcd_dly  pshx
lcd015   dex         ; each loop adds 7 T period delay.
    cpx  #!0
    bne  lcd015
    pulx
    rts

***********************************************************************
* lcd_wrd : Izpise kar je v Ak. A na kurzor;navidezno                 *
***********************************************************************
lcd_wrd
      pshx
      pshb
      psha
      ldx   #ZASLON
      ldab  CURSOR
      abx
      staa  0,x
      inc   CURSOR
      pula
      pulb
      pulx
      rts

lcd_wri pshx
        pshb
        ldx #500
lcd000  ldab RDATLCDI
        andb #%10000000             ; can display accept data?
        tstb
        beq lcdfff
        dex
        cpx #0
        beq lcdfff
        bra lcd000
lcdfff  staa DATLCDI
        pulb
        pulx
        rts

;*****************************************************************
;lcd_wrd:     writes data which is placed in /A/ to LCD CG/DD RAM
;it contains time-out exit if display is not present
;*****************************************************************
lcd_wrdd
        pshx
        pshb
        ldx #500
lcd001  ldab RDATLCDI
        andb #%10000000
        tstb
        beq lcd014
        dex
        cpx #0
        beq lcd014
        bra lcd001
lcd014  staa DATLCDD
        pulb
        pulx
        rts

lcd_init psha
         pshx
         ldaa  #%00111000
         staa  DATLCDI
         jsr   ClrCOP
         ldx   #!1000
         jsr   lcd_dly                    ; 7000 T periods delay
         staa  DATLCDI
         ldx   #!1000
         jsr   lcd_dly                    ; 700 T periods delay
         staa  DATLCDI                    ; HITACHI end
         ldaa  #%00111000
         jsr   lcd_wri                    ; 8-bit, 5x7 dot, 2 line display
         ldaa  #%00001100
         jsr   lcd_wri                    ; display on, cursor off
         ldaa  #%00000110
         jsr   lcd_wri
         ldaa  #%00001110
         jsr   lcd_wri
         jsr   ClrCOP
         ldx   #!1000
         jsr   lcd_dly
         jsr   ClrCOP
         pulx
         pula
         rts

lcd_prs pshx
        psha
        pshb
        tsx
        inx
        inx
        inx
        inx
        ldaa 0,x
        ldab 1,x
        xgdx
lcd004  ldaa 0,x
        cmpa #!59
        beq  lcd005
        jsr  lcd_wrd
        inx
        bra  lcd004
lcd005  inx           ; there must be at least endstring symbol ;
        xgdx
        tsx
        inx
        inx
        inx
        inx
        staa 0,x
        stab 1,x
        pulb
        pula
        pulx
        rts

lcd_NM  pshx
        psha
        pshb
        tsx
        inx
        inx
        inx
        inx
        ldaa 0,x
        ldab 1,x
        xgdx
lcd004a ldaa 0,x
        cmpa #!59
        beq  lcd005a
        jsr  lcd_wrdd
        inx
        bra  lcd004a
lcd005a inx           ; there must be at least endstring symbol ;
        xgdx
        tsx
        inx
        inx
        inx
        inx
        staa 0,x
        stab 1,x
        pulb
        pula
        pulx
        rts

lcd_clr psha
        pshx
        ldaa  #%00000001
        jsr   lcd_wri
        ldaa  #%00000010
        jsr   lcd_wri
        jsr   ClrCOP
        ldx   #!1000
        jsr   lcd_dly
        jsr   ClrCOP
        pulx
        pula
        rts

*************************************************************
**                                                         **
**  set_cursor:  postavi cursor na /B/                     **
**                                                         **
*************************************************************
set_cursor
           stab  CURSOR
           rts

SetCursor
           psha
           pshb
           pshx
           cmpb  #!8
           blo   prva
           addb  #!32        ; druga zato pristej razliko=40-16
prva       ldaa  #%10000000
           aba
           jsr   lcd_wri
           ldx   #!100
           jsr   lcd_dly
           pulx
           pulb
           pula
           rts

nulll:     clr   CURSOR
           rts

clrscr    clr   CURSOR
           jsr   lcd_prs
           db    '                ;'
           rts

*************************************************
****************************************************************
*lcd_02 :  16-BIT division subroutine. Dividend is placed in /X/
*          and is 16-bit wide. Divisor is placed in /B/ and is
*          8-bit wide. Operation performed is X/B. Result is
*          returned in /X/ and reminder in /B/. /A/ is not
*          altered.
*
*input :   /X/ dividend (deljenec) 16-bit
*          /B/ divisor (deljitelj) 8-bit
*operation  X/B
*output :  /X/ result
*          /B/ reminder
*
****************************************************************
*
lcd_02 psha
 ldaa #!17
 psha
 ldaa #0
*
lcd01f pshx
 tsx
 inx
 inx
 dec 0,x
 beq lcd022
*
 pulx
 xgdx
 asld
 bcc lcd020
 xgdx
 asla
 inca
 bra lcd021
lcd020 xgdx
 asla
lcd021 cba
 bmi lcd01f
 sba
 inx
 bra lcd01f
lcd022 pulx
 tab
 pula
 pula
 rts
**************************************************************
*lcd_04   :  16-bit binary number stored in /X/ is converted
*            in 5-digit BCD number stored as follows :
*            MS digit is stored in /B/ while least significant
*            digits are stored in /X/. Upper four bits of /B/
*            are zero.
*
*input   :   /X/ 16-bit binary number
*output  :   /B-X/ 5-digit BCD number
*uses    :    div_16  16-bit division subroutine
*
**************************************************************
lcd_04 psha
 ldaa #0
lcd025 ldab #!10
 cpx #!10
 bcs lcd026
 jsr lcd_02
 pshb
 inca
 bra lcd025
lcd026 xgdx
 pshb
 xgdx
 inca
lcd027 cmpa #5
 beq lcd028
 inca
 ldab #0
 pshb
 bra lcd027
lcd028 pulb
 xgdx
 pula
 asla
 asla
 asla
 asla
 pulb
 aba
 ldab #0
 xgdx
 tba
 pulb
 aslb
 aslb
 aslb
 aslb
 abx
 pulb
 abx
 tab
 pula
 rts
*
*
****************************************************************
*lcd_16dd :16-bit unsigned binary number stored in /D/ writes in
*          decimal to the current cursor location. Leading
*          zeroes are also displayed.
*uses subroutines : lcd_00, lcd_04, lcd_wrd
*
****************************************************************
*
lcd_16dd psha
 pshb
 pshx
 xgdx
 jsr lcd_04
 andb #%00001111
 tba
 jsr lcd_00
 ;jsr lcd_wrd
 inc  CURSOR
 xgdx
 psha
 lsra
 lsra
 lsra
 lsra
 jsr lcd_00
 jsr lcd_wrd
 pula
 anda #%00001111
 jsr lcd_00
 jsr lcd_wrd
 tba
 lsra
 lsra
 lsra
 lsra
 jsr lcd_00
 jsr lcd_wrd
 tba
 anda #%00001111
 jsr lcd_00
 jsr lcd_wrd
 pulx
 pulb
 pula
 rts
*
*
lcd_00 anda  #%00001111
       cmpa  #!10
       bpl   lcd016
       adda  #$30
       rts
lcd016 adda  #$37
       rts

lcd_01 pshx
       psha
       ldaa  #9
       psha
       pulx
       ldaa  #0       ; working register=0

lcd01b xgdx
       deca
       beq  lcd01e
       aslb
       bcc  lcd01c
       xgdx
       asla
       inca
       bra  lcd01d
lcd01c xgdx
       asla
lcd01d cba
       bmi  lcd01b
       sba
       inx
       bra  lcd01b
lcd01e pshb
       xgdx
       psha
       pulb
       pula
       pulx
       rts

lcd_03 pshx
       ldx  #0
lcd023 ldab #!10
       cba
       bcs  lcd024
       jsr  lcd_01
       pshb
       inx
       bra  lcd023
lcd024 psha
       inx
lcdff6 cpx  #3
       beq  lcdff5
       inx
       ldaa #0
       psha
       bra  lcdff6
lcdff5 pula
       pulb
       aslb
       aslb
       aslb
       aslb
       xgdx
       pulb
       abx
       xgdx
       pulx
       rts

****************************************************************
*lcd_8dd:    8-bit unsigned binary number stored in /A/ writes in
*           decimal to the current cursor location. Leading
*           zeroes are also displayed.
*uses subroutines :  lcd_00, lcd_03, lcd_wrd
*
****************************************************************
*
lcd_8dd psha
 pshb
 jsr lcd_03
*
 anda #%00001111
 jsr lcd_00
 jsr lcd_wrd
 tba
 lsra
 lsra
 lsra
 lsra
 jsr lcd_00
 jsr lcd_wrd
 tba
 anda #%00001111
 jsr lcd_00
 jsr lcd_wrd
 pulb
 pula
 rts
*

*
*****************************************************************
*            display and cursor control subroutines
*
*lcd_con: sets cursor on and display on
*lcd_cof: sets cursor off and display on
*lcd_dof: sets display and cursor off
*lcd_don: the same as lcd_cof
*
*         these subrutines does not alter other parameters of
*         display nor the CG/DD RAM content
*****************************************************************
lcd_con psha
 ldaa #%00001110
 jsr lcd_wri
 pula                       ;display on, cursor on, blinking off
 rts
lcd_cof nop
lcd_don psha
 ldaa #%00001100
 jsr lcd_wri                ;display on, cursor off, blinking off
 pula
 rts
lcd_dof psha
  ldaa #%00001000
 jsr lcd_wri
 pula
 rts
*

****************************************************************
*lcd_8d:    8-bit unsigned binary number stored in /A/ writes in
*           decimal to the current cursor location. Leading
*           zeroes are not displayed.
*uses subroutines :  lcd_00, lcd_03, lcd_wrd
*
****************************************************************
*
lcd_8d psha
       pshb
       jsr  lcd_03
*
       anda #%00001111
       beq  lcd02f
       jsr  lcd_00
       jsr  lcd_wrd
       tba
       lsra
       lsra
       lsra
       lsra
       jsr  lcd_00
       jsr  lcd_wrd
       tba
       anda #%00001111
       jsr  lcd_00
       jsr  lcd_wrd
       pulb
       pula
       rts
lcd02f tba
       anda #%11110000
       beq  lcd030
       lsra
       lsra
       lsra
       lsra
       jsr  lcd_00
       jsr  lcd_wrd
       tba
       anda #%00001111
       jsr  lcd_00
       jsr  lcd_wrd
       pulb
       pula
       rts
lcd030 tba
       anda #%00001111
       jsr  lcd_00
       jsr  lcd_wrd
       pulb
       pula
       rts
*
****************************************************************
*lcd_01 :  8-bit division subroutine. Dividend (deljenec) is
*          placed in /A/, divisor (deljitelj) is placed in /B/.
*          Operation performed is A/B. Result is placed in /A/
*          while reminder is placed in /B/. Division is unsigned
*
*input:       /A/...dividend (deljenec)
*             /B/...divisor (deljitelj)   A/B
*output:      /A/...result
*             /B/...remainder
*
****************************************************************
dlcd_01    pshx
          psha
          ldaa  #9
          psha
          pulx
          ldaa  #0
*
dlcd01b   xgdx
          deca
          beq   dlcd01e
*
          aslb
          bcc   dlcd01c
          xgdx
          asla
          inca
          bra   dlcd01d
dlcd01c   xgdx
          asla
dlcd01d   cba
          bmi   dlcd01b
          sba
          inx
          bra   dlcd01b
dlcd01e   pshb
          xgdx
          psha
          pulb
          pula
          pulx
          rts

***** /A/ vrednost  /B/ cursor posicionn ******

IzpisiUre:psha
          pshb
          ldab  #!10
          jsr   dlcd_01
          pshb
          adda  #!48
          jsr   lcd_wrd
          suba  #!48
          pula
          adda  #!48
          jsr   lcd_wrd
          pulb
          pula
          rts

lcd_cmr pshb
        psha
        tab
        ldab  #1
        ldaa  #%00010100            ; shift cursor right
lcd006  tstb
        beq   lcd007
        jsr   lcd_wri
        decb
        bra   lcd006
lcd007  pula
        pulb
        rts
lcd_cml pshb
 psha
 tab
 ldaa #%00010000            ; shift cursor left
lcd008 tstb
 beq lcd009
 jsr lcd_wri
 decb
 bra lcd008
lcd009 pula
 pulb
 rts
lcd_c10 psha
 ldaa #%10000000            ; sets dd ram address 00
 jsr lcd_wri
 pula
 rts
lcd_c18 psha
 ldaa #%10001000            ; sets dd ram address 08
 jsr lcd_wri
 pula
 rts
lcd_c20 psha
 ldaa #%11000000            ; sets dd ram address 40
 jsr lcd_wri
 pula
 rts
lcd_c28 psha
 ldaa #%11001000            ; sets dd ram address 48
 jsr lcd_wri
 pula
 rts


DISPLAY:  ldx   #ZASLON
          clrb
          jsr   SetCursor
doit      cmpb  #!16
          beq   Konceki
          cmpb  #8
          bne   naprek
          jsr   lcd_c20
naprek    ldaa  0,x
          jsr   lcd_wrdd
          bra   NiZA
NiZAL     jsr   lcd_cmr
NiZA      inx
          incb
          bra   doit
Konceki   rts
