/* MENU.C -- contains show_menu () */

/* written by Shanks */

#include <conio.h>
#include <dos.h>

#define UP_ARROW  0x4800
#define DN_ARROW  0x5000
#define ENTER     0x1c0d
#define ESC       0x11b

/*--------------------------------------------------------------------------*/
unsigned read_key (void) {          /* use BIOS INT 16h to read extended keys */
    union REGS regs;

    regs.h.ah = 0x00;
    int86 (0x16, &regs, &regs);
    return (regs.x.ax);
}

/*--------------------------------------------------------------------------*/
/* You can use show_menu () as a generic procedure for displaying menus
   Just define menu option lists and pass the (x, y) coords of top left
   of menu + number of options available in the menu */

/* Play around with the colour constants for some major fun! */

unsigned show_menu (unsigned y, unsigned x, char *menu_options[], unsigned max_choices) {
    unsigned choice = 0;
    unsigned i, key;


    for (i = 0; i < max_choices; ++i) {
        gotoxy (x, y + i);                         /* print all choices */
        cprintf ("%s", menu_options[i]);
    }

    do {
        textattr ((LIGHTGRAY << 4) | BLACK);
        gotoxy (x, y + choice);                    /* highlight current */
        cprintf ("%s", menu_options[choice]);

        key = read_key ();                         /* read the keystroke */

        textattr ((BLACK << 4) | LIGHTGRAY);
        gotoxy (x, y + choice);
        cprintf ("%s", menu_options[choice]);      /* remove highlight */

        switch (key) {      /* find what keystroke & calculate new choice */
            case UP_ARROW:
                          choice = (choice == 0) ? (max_choices-1):(choice-1);
                          break;

            case DN_ARROW:
                          choice = (choice == max_choices-1) ? 0:(choice+1);
                          break;
        }

    } while (key != ENTER && key != ESC);  /* selection over if user hits ENTER */

    return (key == ESC) ? 0:(choice+1);    /* return the selected choice */
}

/*--------------------------------------------------------------------------*/
