


FILE(1)                                                   FILE(1)


NNAAMMEE
       _f_i_l_e - determine file type

SSYYNNOOPPSSIISS
       ffiillee [ --cc ] [ --zz ] [ --LL ] [ --ff namefile ] [ --mm magicfile ]
       file ...

DDEESSCCRRIIPPTTIIOONN
       _F_i_l_e tests each argument in an  attempt  to  classify  it.
       There  are  three  sets of tests, performed in this order:
       filesystem tests, magic number tests, and language  tests.
       The  _f_i_r_s_t  test  that succeeds causes the file type to be
       printed.

       The type printed will usually contain  one  of  the  words
       tteexxtt (the file contains only ASCII characters and is prob-
       ably safe to read on an ASCII terminal),  eexxeeccuuttaabbllee  (the
       file  contains the result of compiling a program in a form
       understandable to some UNIX kernel or  another),  or  ddaattaa
       meaning  anything  else  (data is usually `binary' or non-
       printable).  Exceptions are well-known file formats  (core
       files,  tar  archives)  that  are  known to contain binary
       data.  When modifying the file _/_e_t_c_/_m_a_g_i_c or  the  program
       itself,  pprreesseerrvvee tthheessee kkeeyywwoorrddss ..  People depend on know-
       ing that all the readable files in a  directory  have  the
       word  ``text'' printed.  Don't do as Berkeley did - change
       ``shell commands text'' to ``shell script''.

       The filesystem tests are based  on  examining  the  return
       from  a _s_t_a_t(2) system call.  The program checks to see if
       the file is empty, or if it's some sort of  special  file.
       Any  known  file  types  appropriate to the system you are
       running  on  (sockets,  symbolic  links,  or  named  pipes
       (FIFOs) on those systems that implement them) are intuited
       if they are defined in the system header file  ssyyss//ssttaatt..hh.

       The  magic  number  tests are used to check for files with
       data in particular fixed formats.  The  canonical  example
       of  this  is  a binary executable (compiled program) aa..oouutt
       file, whose format is  defined  in  aa..oouutt..hh  and  possibly
       eexxeecc..hh  in  the  standard  include directory.  These files
       have a `magic number' stored in a  particular  place  near
       the  beginning  of  the file that tells the UNIX operating
       system that the file is a binary executable, and which  of
       several  types thereof.  The concept of `magic number' has
       been applied by extension to data files.   Any  file  with
       some invariant identifier at a small fixed offset into the
       file can usually be described in this way.   The  informa-
       tion   in   these  files  is  read  from  the  magic  file
       _/_e_t_c_/_m_a_g_i_c_.

       If an argument appears to be an ASCII file, _f_i_l_e  attempts
       to  guess  its language.  The language tests look for par-
       ticular strings (cf _n_a_m_e_s_._h) that can appear  anywhere  in



                   Copyright but distributable                  1





FILE(1)                                                   FILE(1)


       the  first few blocks of a file.  For example, the keyword
       ..bbrr indicates that the file is most likely a  troff  input
       file,  just  as  the keyword ssttrruucctt indicates a C program.
       These tests  are  less  reliable  than  the  previous  two
       groups,  so  they  are  performed last.  The language test
       routines also  test  for  some  miscellany  (such  as  _t_a_r
       archives)  and determine whether an unknown file should be
       labelled as `ascii text' or `data'.

       Use --mm _f_i_l_e to specify an alternate file of magic numbers.

       The --zz tries to look inside compressed files.

       The  --cc  option  causes  a checking printout of the parsed
       form of the magic file.  This is usually used in  conjunc-
       tion  with  --mm to debug a new magic file before installing
       it.

       The --ff _n_a_m_e_f_i_l_e option specifies that  the  names  of  the
       files  to  be  examined are to be read (one per line) from
       _n_a_m_e_f_i_l_e before the argument list.  Either _n_a_m_e_f_i_l_e or  at
       least  one  filename argument must be present; to test the
       standard input, use ``-'' as a filename argument.

       The --LL option causes symlinks to be followed, as the like-
       named option in _l_s(1).

FFIILLEESS
       _/_e_t_c_/_m_a_g_i_c - default list of magic numbers

SSEEEE AALLSSOO
       _m_a_g_i_c(4) - description of magic file format.
       _S_t_r_i_n_g_s(1), _o_d(1) - tools for examining non-textfiles.

SSTTAANNDDAARRDDSS CCOONNFFOORRMMAANNCCEE
       This  program is believed to exceed the System V Interface
       Definition of FILE(CMD), as near as one can determine from
       the  vague  language  contained therein.  Its behaviour is
       mostly compatible with the System V program  of  the  same
       name.   This version knows more magic, however, so it will
       produce different (albeit more accurate)  output  in  many
       cases.

       The  one  significant  difference between this version and
       System V is that this version treats any white space as  a
       delimiter,  so  that  spaces  in  pattern  strings must be
       escaped.  For example,
       >10  string    language impress    (imPRESS data)
       in an existing magic file would have to be changed to
       >10  string    language\ impress   (imPRESS data)
       In addition, in this version, if a pattern string contains
       a backslash, it must be escaped.  For example
       0    string         \begindata     Andrew Toolkit document
       in an existing magic file would have to be changed to



                   Copyright but distributable                  2





FILE(1)                                                   FILE(1)


       0    string         \\begindata    Andrew Toolkit document

       SunOS releases 3.2 and later from Sun Microsystems include
       a _f_i_l_e(1) command derived from the System V one, but  with
       some  extensions.   My  version differs from Sun's only in
       minor ways.  It includes the extension of the  `&'  opera-
       tor, used as, for example,
       >16  long&0x7fffffff     >0        not stripped

MMAAGGIICC DDIIRREECCTTOORRYY
       The  magic  file  entries have been collected from various
       sources,  mainly  USENET,  and  contributed   by   various
       authors.   Ian  Darwin  (address below) will collect addi-
       tional or corrected magic file entries.   A  consolidation
       of magic file entries will be distributed periodically.

       The  order  of  entries  in the magic file is significant.
       Depending on what system you are  using,  the  order  that
       they  are put together may be incorrect.  If your old _f_i_l_e
       command uses a magic file, keep the old magic file  around
       for comparison purposes (rename it to _/_e_t_c_/_m_a_g_i_c_._o_r_i_g).

HHIISSTTOORRYY
       There has been a _f_i_l_e command in every UNIX since at least
       Research Version 6 (man page dated  January,  1975).   The
       System  V version introduced one significant major change:
       the external list of magic number types.  This slowed  the
       program down slightly but made it a lot more flexible.

       This  program,  based on the System V version, was written
       by Ian Darwin without looking  at  anybody  else's  source
       code.

       John  Gilmore revised the code extensively, making it bet-
       ter than the first version.  Geoff Collyer  found  several
       inadequacies  and  provided  some magic file entries.  The
       program has undergone continued evolution since.

AAUUTTHHOORR
       Written  by  Ian  F.  Darwin,  UUCP   address   {utzoo   |
       ihnp4}!darwin!ian,  Internet  address  ian@sq.com,  postal
       address: P.O. Box 603, Station F, Toronto, Ontario, CANADA
       M4Y 2L8.

       Altered  by  Rob  McMahon,  cudcv@warwick.ac.uk,  1989, to
       extend the `&' operator from simple `x&y != 0' to `x&y  op
       z'.

       Altered by Guy Harris, guy@auspex.com, 1993, to:

              put  the ``old-style'' `&' operator back the way it
              was, because 1) Rob McMahon's change broke the pre-
              vious  style  of  usage, 2) the SunOS ``new-style''
              `&' operator, which this version of _f_i_l_e  supports,



                   Copyright but distributable                  3





FILE(1)                                                   FILE(1)


              also handles `x&y op z', and 3) Rob's change wasn't
              documented in any case;

              put in multiple levels of `>';

              put in ``beshort'', ``leshort'', etc.  keywords  to
              look  at  numbers  in  the  file in a specific byte
              order, rather than in the native byte order of  the
              process running _f_i_l_e.

       Changes by Ian Darwin and various authors including Chris-
       tos Zoulas (christos@ee.cornell.edu), 1990-1992.

LLEEGGAALL NNOOTTIICCEE
       Copyright (c) Ian F. Darwin, Toronto, Canada, 1986,  1987,
       1988, 1989, 1990, 1991, 1992, 1993.

       This  software  is not subject to and may not be made sub-
       ject to any license of the American  Telephone  and  Tele-
       graph  Company,  Sun  Microsystems Inc., Digital Equipment
       Inc., Lotus Development Inc., the Regents of  the  Univer-
       sity  of  California, The X Consortium or MIT, or The Free
       Software Foundation.

       This software is not subject to any  export  provision  of
       the  United  States  Department  of  Commerce,  and may be
       exported to any country or planet.

       Permission is granted to anyone to use this  software  for
       any  purpose  on  any computer system, and to alter it and
       redistribute it freely, subject to the following  restric-
       tions:

       1.  The  author is not responsible for the consequences of
       use of this software, no matter how awful,  even  if  they
       arise from flaws in it.

       2. The origin of this software must not be misrepresented,
       either by explicit claim or by omission.  Since few  users
       ever  read  sources, credits must appear in the documenta-
       tion.

       3. Altered versions must be plainly marked  as  such,  and
       must not be misrepresented as being the original software.
       Since few users ever read sources, credits must appear  in
       the documentation.

       4. This notice may not be removed or altered.

       A few support files (_g_e_t_o_p_t, _s_t_r_t_o_k) distributed with this
       package are by Henry Spencer and are subject to  the  same
       terms as above.

       A  few  simple  support files (_s_t_r_t_o_l, _s_t_r_c_h_r) distributed



                   Copyright but distributable                  4





FILE(1)                                                   FILE(1)


       with this package are in the public domain;  they  are  so
       marked.

       The  files _t_a_r_._h and _i_s___t_a_r_._c were written by John Gilmore
       from his public-domain _t_a_r program, and are not covered by
       the above restrictions.

BBUUGGSS
       There must be a better way to automate the construction of
       the Magic file from all the glop in Magdir.  What  is  it?
       Better  yet, the magic file should be compiled into binary
       (say, _n_d_b_m(3) or, better yet, fixed-length  ASCII  strings
       for  use  in heterogenous network environments) for faster
       startup.  Then the program would run as fast as  the  Ver-
       sion  7  program of the same name, with the flexibility of
       the System V version.

       _F_i_l_e uses several algorithms that favor speed  over  accu-
       racy,  thus  it  can be misled about the contents of ASCII
       files.

       The support for ASCII  files  (primarily  for  programming
       languages)  is simplistic, inefficient and requires recom-
       pilation to update.

       There should be an ``else'' clause to follow a  series  of
       continuation lines.

       The magic file and keywords should have regular expression
       support.  Their use of ASCII TAB as a field  delimiter  is
       ugly  and  makes  it  hard  to  edit  the  files,  but  is
       entrenched.

       It might be advisable to allow upper-case letters in  key-
       words  for e.g., troff commands vs man page macros.  Regu-
       lar expression support would make this easy.

       The program doesn't grok FORTRAN.  It should  be  able  to
       figure  FORTRAN  by  seeing  some  keywords  which  appear
       indented at the start of line.  Regular expression support
       would make this easy.

       The  list  of keywords in _a_s_c_m_a_g_i_c probably belongs in the
       Magic file.  This could be done by using some keyword like
       `*' for the offset value.

       Another  optimisation  would  be to sort the magic file so
       that we can just run down all  the  tests  for  the  first
       byte,  first  word,  first long, etc, once we have fetched
       it.  Complain about conflicts in the magic  file  entries.
       Make a rule that the magic entries sort based on file off-
       set rather than position within the magic file?

       The program should provide a way to give  an  estimate  of



                   Copyright but distributable                  5





FILE(1)                                                   FILE(1)


       ``how good'' a guess is.  We end up removing guesses (e.g.
       ``From '' as first 5 chars of file) because they  are  not
       as  good  as  other  guesses  (e.g. ``Newsgroups:'' versus
       "Return-Path:").  Still, if the others don't pan  out,  it
       should be possible to use the first guess.

       This program is slower than some vendors' file commands.

       This  manual  page,  and particularly this section, is too
       long.

AAVVAAIILLAABBIILLIITTYY
       You can obtain the original  author's  latest  version  by
       anonymous  FTP  on  ffttpp..ccss..ttoorroonnttoo..eedduu  in  the  directory
       //ppuubb//ddaarrwwiinn//ffiillee.










































                   Copyright but distributable                  6


