/************************************************************* fix.h 04-97
 *  Program ... FIX Library Function
 *  File ...... FIX.H
 *  Version ... 5.10F
 *  Date ...... 1 April 1997
 *  Purpose ... Function Documentation & Header File for C/C++ Program
 *
 *  Copyright (C) 1993-1997 Novalogic.  All Rights Reserved.
 *
 *************************************************************************
 *    intro: The basic string find/replace algorithm of the FIX util-
 *           ity is available for incorporation in your internal or
 *           commercial software project.  Why reinvent the wheel?
 * function: FIX 5.10F Find/replace string occurrences in IBM-PC file.
 *           Assembled 16 bit code, optimized for speed, 1,950 bytes,
 *           C call convention, large memory model, reentrant if user
 *           provides reentrant read/write functions.
 * requires: Intel 8086 or higher processor, protected mode operation
 *           requires DPMI (Windows 3.X), else if no ms-dos user must
 *           provide file read/write functions to be called by FIX
 *   limits: max i/o file size:  limited only by available drive space
 *           max string length with case sensitive search:
 *              find_len + replace_len + 84 < buffer_size
 *           max string length with case insensitive search:
 *              3 * find_len + replace_len + 100 < buffer_size
 *           max buffer_size:  0xFFFF bytes
 *           min buffer size:  3 * find_len + replace_len + 100
 * licensor: NovaLogic  (503) 524-9184  novalogic@teleport.com
 *           13585 SW Pommel Ct,  Beaverton, OR 97008  USA
 ************************************************************************/
#ifndef __FIX_H
#define __FIX_H
/* function prototype: */
#define ulong unsigned long
/* err_code =                  /* error code returned by Fix (below) */
int far Fix (                  /* Fix library function */
    int       cntrl_flags,     /* control bit flags */
    int       infile_hndl,     /* handle of opened input file/device */
    int       outfile_hndl,    /* handle of opened output file/device */
    char far *find_string,     /* pointer to find string */
    int       find_len,        /* length of find string [1] */
    char far *replace_string,  /* pointer to replace string */
    int       replace_len,     /* length of replace string */
    void far *buffer,          /* ptr working buffer rerv'd by caller */
    int       buffer_size,     /* size of working buffer, max 0xFFFF */
    ulong far *string_count ); /* ptr to found/replaced string counter */

/* cntrl_flags bit flags: */
#define FIX_COUNT_ONLY    0x0001  /* only count findstrings */
#define FIX_CASE_INSENS   0x0002  /* case insensitive search */
#define FIX_DELIM_FINDSTR 0x0004  /* select only delimited [2] findstr */
#define FIX_BEGIN_LINE    0x0008  /* begin file = begin line (^) [3] */
#define FIX_END_LINE      0x0010  /* end file = end line ($) [3] */
#define FIX_UNIX_TEXT     0x0020  /* Unix newline for (^),($),(\n) [3] */
#define FIX_UPPER_CASE    0x0040  /* transform all text upper case [4] */
#define FIX_LOWER_CASE    0x0080  /* transform all text lower case [4] */
/*                        0x0X00  /* 4 bits reserved for future FIX use */
/*			  0xX000  /* 4 bits for user's cntrl of user */
/* Notes: */                      /*       written read/write functions */
/* [1] To copy infile to outfile, set find_len to zero.
 * [2] A 'delimited' findstring is immediately preceded & followed in
 *     text by a char outside of the ranges: [0-9], [A-Z], [a-z], [_].
 * [3] Setting FIX_BEGIN_LINE or FIX_END_LINE flag assumes that
 *     find_string begins or ends with newline chars.  Default newline
 *     is MS-DOS' 0x0D,0x0A, set FIX_UNIX_TEXT for Unix newline 0x0A.
 * [4] When an upper or lower case transform bit flag is set, no other
 *     flags are permitted */

/* err_code values: */
#define FIXERR_NONE         0  /* no error, successful execution */
#define FIXERR_CNTRL_FLAGS  1  /* incompatible control flags received */
#define FIXERR_BUFSIZE      2  /* insufficient buffer space provided */
#define FIXERR_INFILE_HNDL  3  /* infile handle invalid or not open */
#define FIXERR_INFILE_ACCS  4  /* infile access denied */
#define FIXERR_OUTFILE_HNDL 5  /* outfile handle invalid or not open */
#define FIXERR_OUTFILE_ACCS 6  /* outfile access denied */
#define FIXERR_DRIVEFULL    7  /* insufficient free space output drive */

/* prototypes for sequential read/write functions which must be */
/* provided by user for operating systems other than ms-dos: */

/* return_count =                /* returned count of bytes read */
int near fix_read (              /* sequential read fn called by Fix() */
	int  near *err_code,     /* NONE, INFILE_HNDL, INFILE_ACSS */
	char near *buffer,       /* buffer for text to be read */
	int        byte_count,   /* count of bytes to be read */
	int        file_handle,  /* handle of input file */
	int        cntrl_flags); /* control bit flags (optional) */

/* int return_count =            /* returned count of bytes written */
int near fix_write (             /* sequential write fn called by Fix() */
	int  near *err_code,     /* NONE,OUTFILE_HNDL,OUTFILE_ACSS,DRIVEFULL*/
	char near *buffer,       /* buffer containing text to be written */
	int        count,	 /* count of bytes to be written */
	int        handle,	 /* handle of output file */
	int        cntrl_flags); /* control bit flags (optional) */

#endif
/* end of FIX.H */
