/*
            ͻ
                            UNITE!                  
               Copyright (c) 1994-96 L.I.Williams   
                      All rights reserved           
               Issue 1.6             Date: 27Feb96  
            ͼ
*~
*~	UNITE.C
*~	Join 2 files outputting lines the same and the differences
*~	If you modify/improve this source, I appreciate a note
*~
*/
/***********************************************************************
* HISTORY:
* Date      Iss  Who Comment
* 17-JAN-88 1.0  LIW Created
* 24-AUG-89 1.1  LIW ### End difference added
* 13-DEC-93 1.2  LIW Rename to UNITE
* 12-FEB-94 1.3  LIW Remove free message
* 06-OCT-95 1.5  LIW Format for freeware release
* 20-FEB-96 1.6  LIW Add VENDOR.DOC
***********************************************************************/
/* standard routines */
#include <stdio.h>
#include <ctype.h>
#include <string.h>

/* constants */
#define TRUE 1
#define FALSE 0
/* This module declares the global variables: */
char	ext[40];		/* holds a file name extension */
char	*s1,
	*s2;			/* handy pointers */
char
	prog1[100][192],	/* 100 line buffer for 1st file */
	prog2[100][192],	/* 100 line buffer for 2nd file */
	inpnam1[40],		/* 1st file name store */	
	inpnam2[40];		/* 2nd file name store */
int
	debug,			/* TRUE = lots of debug printout */
	i,
	first1,			/* File1:1st line at which a match is found */
	curr1,			/* File1 the current line being matched */
	beyond1,		/* File1 1 beyond the end of the buffer */
	first2,			/* File2:1st line at which a match is found */
	curr2,			/* File2 the current line being matched */
	beyond2,		/* File2 1 beyond the end of the buffer */
	match;			/* no of lines matched at this point */
char	c;
FILE	*inpfil1;		/* 1st file specified */
FILE	*inpfil2;		/* 2nd file specified */

/***********************************************************************
* Debug print routines. These routines only print if /d is specified
* e.g. UNITE FRED1 FRED2 /d > FRED.UNI
* Start of code.
***********************************************************************/
tprintf (args1)
char	*args1;
{
if (debug) 
  printf (args1);
}
tprintf1 (args1,val1)
char	*args1;
int	val1;
{
if (debug) 
  printf (args1,val1);
}
tprintf2 (args1,val1,val2)
char	*args1;
int	val1;
int	val2;
{
if (debug) 
  printf (args1,val1,val2);
}

/***********************************************************************
* Explains parameters etc. 
***********************************************************************/
void explain()
{
printf("\n\
            ͻ\n\
                            UNITE!                  \n\
               Copyright (c) 1994-96 L.I.Williams   \n\
                      All rights reserved           \n\
               Issue 1.6             Date: 20Feb96  \n\
            ͼ\n\
");
printf("\n\UNITE joins or merges two somewhat different versions of the same\n");
printf("text file together. It does a file compare in which the lines that\n");
printf("are the same are output, as well as the differences, which are\n");
printf("highlighted with '### <filename>.' \n");
printf("\n");
printf("Example:  UNITE CONFIG.SYS CONFIG.OLD > CONFIG.JOI\n");
printf("\n");
printf("\
will combine together two versions of CONFIG.SYS in the current directory\n\
and output the combination with the differences highlighted to file\n\
CONFIG.JOI. UNITE is freeware. Send problems, comments, suggestions,\n\
appreciative notes, and requests to be kept up-to-date with issues, to:\n\
Lewis Williams, 100103.2675@compuserve.com. If you like this program, take a\n\
look at UPCOPY, my bi-directional directory synchronizer. If your gratitude\n\
for it knows no bounds you could register that instead for $25!\n\
");
}

/***********************************************************************
* Subroutine to open files etc.
***********************************************************************/
int openfils(argc,argv)
int argc;
char *argv[];	/* array of strings */
{
/* Take care of inpfil1 and add defaults if necessary */
switch (argc)
  {
  default:
    fprintf(stderr,"Bad parameters\n");
    return TRUE;
  case 1:
    explain();
    return TRUE;
  case 2:
    strcpy(inpnam1,argv[1]);
    strcpy(inpnam2,"*.bak");	/* default to <filename>.bak if no 2nd file */
    break;
  case 3:
    strcpy(inpnam1,argv[1]);	/* copy both filenames */
    strcpy(inpnam2,argv[2]);
    break;
  case 4:
    strcpy(inpnam1,argv[1]);
    strcpy(inpnam2,argv[2]);
    debug = !(strncmp("/d",argv[3],2));	/* turn on debug facility */
    break;
  }
if ((inpfil1 = fopen(inpnam1,"r")) == NULL)
  {
  fprintf(stderr,"Failed to open input file %s \n",inpnam1);
  return TRUE;
  }
strcpy(ext,"");			/* preset NULL extension */
/* deal with *.something in 2nd name */
if (inpnam2[0]=='*')		/* 2nd base name is wildcard? */
  {
  if (inpnam2[1]=='.')
    strcpy(ext,&inpnam2[1]);	/* 2nd extension */
  strcpy(inpnam2,inpnam1);	/* use input name basically */
  s2 = strchr(inpnam2,'.');	/* pointer to . character=remove 1st extension*/
  strcpy(s2,ext);		/* add 2nd extension nsion to input name */
  }
/* deal with something.* in 2nd name */
s2 = strchr (inpnam2,'.');	/* pointer to new . character */
if (s2[1]=='*')			/* wildcard extension */
  {
  s1 = strchr(inpnam1,'.');	/* . character in 1st name */
  strcpy(s2,s1);
  }
if ((inpfil2 = fopen(inpnam2,"r")) == NULL)
  {
  fprintf(stderr,"Failed to open input file %s \n",inpnam2);
  return TRUE;
  }
return FALSE;			/* all is OK */
}

/***********************************************************************
* Typeout the lines after a match is found
***********************************************************************/
void typeout()
{
if (debug)
  printf("first1=%d,first2=%d,curr1=%d,curr2=%d,beyond1=%d,beyond2=%d,match=%d\n",first1,first2,curr1,curr2,beyond1,beyond2,match);
if ((first1 == first2) && (first1 == 0) && (match != 0))
  /* Files are the same. some lines to type out */
  printf("%s",prog1[0]);
else
  /* files are different */
  /* output lines from file 1 */
  {
  if (match)
    {
    first1--;			/* backup to non-matching lines */
    first2--;
    }
  if (first1>=0)
    printf("### %s\n",inpnam1);	/* header if required */
  for (i=0;i<=first1;i++)
    printf("%s",prog1[i]);
  if (first2 >= 0)
    printf("### %s\n",inpnam2);	/* header as required */
  for (i=0;i<=first2;i++)
    printf("%s",prog2[i]);
  if ((first1 >= 0) || (first2 >= 0))
    printf("### End difference\n");		/* footer as required */
  }
/* Copy data in buffers back to the beginning */
tprintf2("Copying lines %d to %d down in file1\n",first1+1,beyond1-1);
for (i=first1+1;i<=beyond1-1;i++)
  strcpy(prog1[i-first1-1],prog1[i]);
tprintf2("Copying lines %d to %d down in file2\n",first2+1,beyond2-1);
for (i=first2+1;i<=beyond2-1;i++)
  strcpy(prog2[i-first2-1],prog2[i]);
curr1 = -1;				/* set startup situation */
curr2 = -1;
beyond1 = beyond1  - first1 - 1;
beyond2 = beyond2 - first2 - 1;
first1 = 0;
first2 = 0;
if (debug)
  {
  printf("Setting beyond1 = %d and beyond2 = %d\n",beyond1,beyond2);
  printf("Setting curr1 and curr2 to -1\n");
  printf("Setting first1,first2\n");
  }
}

/***********************************************************************
* Get next line from file1 or buffer1
***********************************************************************/
int getlin1()
{
curr1++;			/* point to next line */
tprintf1("Inc'd curr1 to %d\n",curr1);
if (curr1 >= beyond1)		/* 1st buffer is used up */
  {
  tprintf2("First buffer is used up - reading a line curr1 = %d, beyond1 = %d\n",curr1,beyond1);
  if (fgets(prog1[curr1],128,inpfil1)==NULL)	/* end of file 1 */
    {
    curr1 = beyond1 - 1;		/* set line to last available */
    tprintf1("File1 is exhausted. Reset curr1 to beyond1 -1 (%d)\n",curr1);
    return TRUE;			/* failed to get line */
    }
  beyond1++;		/* one more line in buffer 1 */
  tprintf1("Incrementing beyond1 to %d\n",beyond1);
  if (beyond1 == 99)		/* buffer is full */
    {
    tprintf("### Files are too different - union aborted\n");
    return TRUE;		/* failed to get line */
    }
  }
return FALSE;			/* got line OK */
}

/***********************************************************************
* Get next line from file2 or buffer2
***********************************************************************/
int getlin2()
{
curr2++;		/* point to next line */
tprintf1("Inc'd curr2 to %d\n",curr2);
if (curr2 >= beyond2)	/* 2nd buffer is used up */
  {
  tprintf("2nd buffer is used up\n");
  if (beyond2 == 99)	/* buffer is full */
    {
    curr2 = beyond2 - 1;	/* last line available */
    tprintf1("Breaking - buff2 is full\nSet curr2 to beyond2 -1 (%d)\n",curr2);
    return TRUE;		/* failed to get line */
    }
  tprintf2("Reading a line curr2 = %d, beyond2 = %d\n",curr2,beyond2);
  if (fgets(prog2[curr2],128,inpfil2)==NULL)	/* end of file 2 */
    {
    curr2 = beyond2 - 1;	/* last line available */
    tprintf1("Returning - no more lines in file2. Reset curr2 to beyond2-1 (%d)\n",curr2);
    return TRUE;		/* failed to get line */
    }
  beyond2++;			/* one more line in buffer 2 */
  tprintf1("Incrementing beyond2 to %d\n",beyond2);
  }
return FALSE;			/* got line OK */
}

/***********************************************************************
* Main program
***********************************************************************/
void main(argc,argv)
int argc;
char *argv[];	/* array of strings */
{
/* open the input files */
if (openfils(argc,argv))
  exit(0);			/* if an error */

/* Setup variables */
first1 = 0;
beyond1 = 0;
first2 = 0;
beyond2 = 0;
curr1 = -1;
curr2 = -1;
match = 4;			/* preset files in synch */

for (;;)			/* infinite loop, all lines in file 1 */
  {
  tprintf1("Next time in file1 loop - curr1 = %d\n",curr1);
  if (getlin1())		/* no more lines in file1 */
    {
    first1 = beyond1 -1;	/* force tidy up type out */
    first2 = beyond2 -1;
    tprintf2("Setting first1 = beyond1 -1 (%d) first2 = beyond2-1 (%d)\n",first1,first2);
    match = 0;			/* force full typeout */
    typeout();
    return;
    }
  for (;;)			/* all lines in file2 */
    {
    if (getlin2())		/* no more room or something in buffer2 */
      {
      curr2 = -1;		/* try next line in file 1 */
      tprintf("Set curr2 -1 breaking inner loop\n");
      break;			/* to next line in file1 */
      }
    if (strcmp(prog1[curr1],prog2[curr2])==0)	/* lines the same ? */
      {
      if (debug)
        {
        printf("Lines %d and %d are the same\n",curr1,curr2);
        printf("Setting first1 = curr1 (%d)\n",curr1);
        printf("Setting first2 = curr2 (%d)\n",curr2);
        }
      first1 = curr1;			/* save this position */
      first2 = curr2;
      if (!match)			/* files were not in sync */
        for (match=1;match <= 3;match++) /* look for 3 lines the same */
          {
          if (getlin1())
            {
            tprintf("Breaking 'cos run out of lines to match in file1\n");
            break;
            }
          if (getlin2())
            {
            tprintf("Breaking 'cos run out of lines to match in file2\n");
            break;
           }
         if (strcmp(prog1[curr1],prog2[curr2]))	/* lines same ? */
           {
           tprintf("Read ahead shows lines different\nJumping to inner\nSetting match 0\n");
           match = 0;				/* no, try next file2 line */
           goto inner;
           }
         else
           tprintf2("Lines %d and %d are the same\n",curr1,curr2);
         }					/* end of match loop */
      tprintf1("match is %d - calling typeout\n",match);
      typeout();				/* typeout usually 1 line */
      tprintf("Jumping to outer loop\n");
      goto outer;
      }
    else
      {
      tprintf2("Lines %d and %d are different\nSetting match 0\n",curr1,curr2);
      match = 0;			/* files not in synch here */
      }
inner:;
    }					/* end of inner loop */
outer:;
  }
/* close the files */
fclose (inpfil1);
fclose (inpfil2);
}
/***********************************************************************
* End of code
***********************************************************************/
