ECHO OFF

REM CAPGNZRS.BAT - restore Capital Gainz data files
REM Simple batch file to restore Capital Gainz data files.
REM The data files were probably backed up with CAPGNZBU.BAT.
REM Single parameter - letter of drive (A or B) to copy files to.

IF "%1" == "" GOTO FAIL

ECHO Restore data files from drive %1 to current directory ? [Y/N]
YESNO
IF ERRORLEVEL 2 GOTO END

IF "%1" == "a" GOTO RESTOREA
IF "%1" == "A" GOTO RESTOREA
IF "%1" == "a:" GOTO RESTOREA
IF "%1" == "A:" GOTO RESTOREA

IF "%1" == "b" GOTO RESTOREB
IF "%1" == "B" GOTO RESTOREB
IF "%1" == "b:" GOTO RESTOREB
IF "%1" == "B:" GOTO RESTOREB

GOTO FAIL

:RESTOREA
REM Delete any existing data files.
DEL *.DAT
DEL *.K01
DEL CG.STY

REM If you used a data compressor with CAPGNZBU.BAT, such as PKZIP:
REM  PKUNZIP -O A:CGDATA.ZIP 

COPY A:*.DAT .
COPY A:*.K01 .
COPY A:CG.STY .
GOTO ENDOK

:RESTOREB
REM Delete any existing data files.
DEL *.DAT
DEL *.K01
DEL CG.STY

REM If you used a data compressor with CAPGNZBU.BAT, such as PKZIP:
REM  PKUNZIP -O B:CGDATA.ZIP 

COPY B:*.DAT .
COPY B:*.K01 .
COPY B:CG.STY .
GOTO ENDOK

:ENDOK
ECHO Restore Succeeded !
PAUSE
GOTO END

:FAIL
ECHO Restore Failed - Can only restore from Drive A or B.
PAUSE

:END
