@echo off
REM -------------------------------
REM Lighthouse Installation Program
REM -------------------------------
set LANGUAGE=
REM The following command works only on WindowsXP
if NOT "%OS%" == "Windows_NT" goto run_lang_choice
REM Windows XP does not support the 'choice' command. forcing English install
if "%windir%" == "C:\WINDOWS" goto English
:run_lang_choice
echo 1) Arabic
echo 2) Cesky
echo 3) English
echo 4) Espanol
echo 5) Slovensky
echo 6) Quit
:selection
echo.
choice /c:123456 Your choice? /N
if errorlevel 6 goto exit
if errorlevel 5 goto Cesky
if errorlevel 4 goto Espanol
if errorlevel 3 goto English
if errorlevel 2 goto Cesky
if errorlevel 1 goto Arabic
echo Your selection is not recognized
goto selection

REM 颫  㩠
REM =====================
:Arabic
set LANGUAGE=ARABIC
echo.
echo -----------------------------------------------------------
echo                Pronica Systems and Technologies
echo.
echo              Lighthouse Home Accounting Software
echo -----------------------------------------------------------
echo.
echo Please wait ...
echo.
if EXIST C:\LightH\LightH.exe goto A_overwrite
mkdir C:\LightH
goto A_copyfiles

:A_overwrite
choice "Directory C:\LightH exists should I overwrite its content "
if errorlevel 2 goto end

:A_copyfiles
IF "%OS%"=="Windows_NT" goto Ar_NoOptions
copy LightH.en    C:\LightH\LightH.cfg /y >NUL
goto Ar_endOption

:Ar_NoOptions
copy LightH.en    C:\LightH\LightH.cfg >NUL

:Ar_endOption

IF .%OS%==.Windows_NT goto A_WinNT
copy LightH.pif "%WINDIR%\ 袠"
goto common

:A_WinNT
copy LightH.pif "%ALLUSERSPROFILE%\Desktop" >NUL
goto common

REM Instalace pro ceskeho jazyka
REM ============================
:Cesky
set LANGUAGE=CESKY
echo.
echo -----------------------------------------------------------
echo                Pronica Systems and Technologies
echo.
echo     Program Lighthouse pro domaci sledovani pohybu penez
echo -----------------------------------------------------------
echo.
echo Prosm cekejte ...
echo.
ren LightH.pif Majak.pif
if EXIST C:\LightH\LightH.exe goto C_overwrite
mkdir C:\LightH
goto C_copyfiles

:C_overwrite
choice /c:AN /N "Adresar C:\LightH existuje muzu prepsat jeho obsah? [A,N] "
if errorlevel 2 goto end

:C_copyfiles
IF "%OS%"=="Windows_NT" goto Cz_NoOptions

copy LightH.cz    C:\LightH\LightH.cfg /y >NUL
goto Cz_endOption

:Cz_NoOptions
copy LightH.cz    C:\LightH\LightH.cfg >NUL

:Cz_endOption

IF "%OS%"=="Windows_NT" goto C_WinNT
copy Majak.pif %WINDIR%\Desktop >NUL
goto common

:C_WinNT
REM Windows XP does not support the 'choice' command.
if "%windir%" == "C:\WINDOWS" goto Cz_copyShortcut
choice "Jste si jisti ze bezi Windows 2000? [A/N] " /N /c:ANan 
:Cz_copyShortcut
copy Majak.pif "%ALLUSERSPROFILE%\Desktop" >NUL
goto common

REM Instalation script for the English language
REM ===========================================
:English
set LANGUAGE=ENGLISH
echo.
echo -----------------------------------------------------------
echo                Pronica Systems and Technologies
echo.
echo              Lighthouse Home Accounting Software
echo -----------------------------------------------------------
echo.
echo Please wait ...
echo.
if EXIST C:\LightH\LightH.exe goto overwrite
mkdir C:\LightH
goto copyfiles

:overwrite
if NOT "%OS%" == "Windows_NT" goto copyfiles
REM Windows XP does not support the 'choice' command. forcing English install
if "%windir%" == "C:\WINDOWS" goto copyfiles
choice "Directory C:\LightH exists should I overwrite its content "
if errorlevel 2 goto end

:copyfiles
IF "%OS%"=="Windows_NT" goto En_NoOptions

copy LightH.en    C:\LightH\LightH.cfg /y >NUL
goto En_endOption

:En_NoOptions
copy LightH.en    C:\LightH\LightH.cfg >NUL

:En_endOption

IF "%OS%"=="Windows_NT" goto E_WinNT
copy LightH.pif %WINDIR%\Desktop
goto common

:E_winnt
REM Windows XP does not support the 'choice' command. forcing English install
if "%windir%" == "C:\WINDOWS" goto En_copyShortcut
choice "Are you running Windows 2000? [Y/N] " /N /c:YNyn 
:En_copyShortcut
copy LightH.pif "%ALLUSERSPROFILE%\Desktop\Lighth.pif" >NUL
goto common

REM Grabar la version Espanola
REM ==========================
:Espanol
set LANGUAGE=ESPANOL
echo.
echo -----------------------------------------------------------
echo                Pronica Systemas y Technologias
echo.
echo           Programa Faro para contabilidad personal
echo -----------------------------------------------------------
echo.
echo Espere por favor ...
echo.
ren LightH.pif Faro.pif
if EXIST C:\LightH\LightH.exe goto ES_overwrite
mkdir C:\LightH
goto ES_copyfiles

:ES_overwrite
choice "El directorio C:\LightH existe puedo overwrite its content " /C:SN
if errorlevel 2 goto exit

:ES_copyfiles
IF .%OS%==.Windows_NT goto Es_NoOptions
copy LightH.sp    C:\LightH\LightH.cfg /y >NUL
goto Es_endOption

:Es_NoOptions
copy LightH.sp    C:\LightH\LightH.cfg >NUL

:Es_endOption

IF .%OS%==.Windows_NT goto ES_WinNT
copy LightH.pif %WINDIR%\Desktop >NUL
goto common

:ES_WinNT
REM Windows XP does not support the 'choice' command.
if "%windir%" == "C:\WINDOWS" goto Es_copyShortcut
choice "Estas seguro que corre Windows 2000? [S/N] " /N /c:SNsn 
:Es_copyShortcut
copy Faro.pif "%ALLUSERSPROFILE%\Desktop" >NUL
goto common


REM Instalacia pro slovenskeho jazyka
REM =================================
:Slovensky
set LANGUAGE=SLOVENSKY
echo.
echo -----------------------------------------------------------
echo                Pronica Systems and Technologies
echo.
echo     Program Lighthouse pro domaci sledovani pohybu penez
echo -----------------------------------------------------------
echo.
echo Please wait ...
echo.
ren LightH.pif Majak.pif
if EXIST C:\LightH\LightH.exe goto S_overwrite
mkdir C:\LightH
goto S_copyfiles

:S_overwrite
choice "Adresar C:\LightH existuje, muzu prepsat jeho obsah? "
if errorlevel 2 goto end

:S_copyfiles
IF .%OS%==.Windows_NT goto Sk_NoOptions
copy LightH.en    C:\LightH\LightH.cfg /y >NUL
goto Sk_endOption

:Sk_NoOptions
copy LightH.en    C:\LightH\LightH.cfg >NUL

:Sk_endOption

IF .%OS%==.Windows_NT goto S_WinNT
copy LightH.pif %WINDIR%\Desktop >NUL
goto common

:S_WinNT
REM Windows XP does not support the 'choice' command.
if "%windir%" == "C:\WINDOWS" goto Sk_copyShortcut
choice "Jste si jisti ze bezi Windows 2000? [A/N] " /N /c:ANan 
:Sk_copyShortcut
copy Majak.pif "%ALLUSERSPROFILE%\Desktop" >NUL
goto common


REM -----------------------------------------
REM This part is common for all the languages
REM -----------------------------------------
:common
IF "%OS%"=="Windows_NT" goto common_NoOptions
copy LightH.exe   C:\LightH /y >NUL
copy image5.bmp   C:\LightH /y >NUL
copy LightH.ico   C:\LightH /y >NUL
copy language.dat C:\LightH /y >NUL
copy license.txt  C:\LightH /y >NUL
copy licencia.txt C:\LightH /y >NUL
copy remove.bat   C:\LightH /y >NUL
copy arrowdnr.bmp C:\LightH /y >NUL
copy arrowdwn.bmp C:\LightH /y >NUL
copy pg-down.bmp  C:\LightH /y >NUL
copy arrowlfr.bmp C:\LightH /y >NUL
copy arrowlft.bmp C:\LightH /y >NUL
copy arrowrgh.bmp C:\LightH /y >NUL
copy arrowrgr.bmp C:\LightH /y >NUL
copy arrow-up.bmp C:\LightH /y >NUL
copy arrowupr.bmp C:\LightH /y >NUL
copy pgdwnprd.bmp C:\LightH /y >NUL
copy pg-up.bmp    C:\LightH /y >NUL
copy pgupprsd.bmp C:\LightH /y >NUL
copy readme.txt   C:\LightH /y >NUL
                              
goto common_endOption

:common_NoOptions
copy LightH.exe   C:\LightH >NUL
copy image5.bmp   C:\LightH >NUL
copy LightH.ico   C:\LightH >NUL
copy language.dat C:\LightH >NUL
copy license.txt  C:\LightH >NUL
copy licencia.txt C:\LightH >NUL
copy remove.bat   C:\LightH >NUL
copy arrowdnr.bmp C:\LightH >NUL
copy arrowdwn.bmp C:\LightH >NUL
copy pg-down.bmp  C:\LightH >NUL
copy arrowlfr.bmp C:\LightH >NUL
copy arrowlft.bmp C:\LightH >NUL
copy arrowrgh.bmp C:\LightH >NUL
copy arrowrgr.bmp C:\LightH >NUL
copy arrow-up.bmp C:\LightH >NUL
copy arrowupr.bmp C:\LightH >NUL
copy pgdwnprd.bmp C:\LightH >NUL
copy pg-up.bmp    C:\LightH >NUL
copy pgupprsd.bmp C:\LightH >NUL
                           
:common_endOption

if NOT "%LANGUAGE%"=="ARABIC"  goto case_sp
echo Lighthouse personal Accounting is installed successfuly
echo Type lighth to run the program
goto end_case
:case_sp
if "%LANGUAGE%"=="ESPANOL"   goto case_en
echo El Faro Contabilidad Personal ya esta correctamente enstalada
echo Escribe lighth para correr la programa
:case_en
if "%LANGUAGE%"=="ENGLISH"   goto case_cz
echo Lighthouse personal Accounting is installed successfuly
echo Type lighth to run the program
:case_cz
if "%LANGUAGE%"=="CESKY"     goto case_sk
echo Lighthouse domaci sledovani pohyb penezi je uz instalovan
echo Napis lighth ke spousten programu
:case_sk
if "%LANGUAGE%"=="SLOVENSKY" goto case_none
echo Lighthouse domaci sledovani pohyb penezi je uz instalovan
echo Napis lighth ke spousten programu
:case_none
if "%LANGUAGE%"==""          echo Lighthouse personal Accounting is installed successfuly
echo Type lighth to run the program
:end_case
set LANGUAGE=

:end
REM cd ..
if NOT "%OS%" == "Windows_NT" goto erase_files
REM Windows XP does not support the 'deltree' command
if "%windir%" == "C:\WINDOWS" goto no_deltree
:erase_files
REM deltree removes the batch file which we still need
REM deltree /Y LightH
del *.bmp
del *.en
del *.sp
del *.cz
del remove.bat
del L*.*
del *.pif
del *.txt
:no_deltree
cd C:\LightH
echo on
