/**********************************************************************
Fill-Pattern Tester 1.0
Copyright (c) 1994 by Jouni Miettunen. All Rights Reserved.

Usage: tester [ pattern_file [ foreground_color background_color ]]

0  black	4  red		8  darkgray	12 lightred
1  blue		5  magenta	9  lightblue	13 lightmagenta
2  green	6  brown	10 lightgreen	14 yellow
3  cyan		7  gray		11 lightcyan	15 white

Note: mode 640x480x16

**********************************************************************/

#include <conio.h>	/* conio */
#include <stdio.h>	/* fopen,fscanf,EOF,putchar,fclose,fflush */
#include <stdlib.h>	/* exit */

#include <gxlib.h>	/* Genus GX kernel */
#include <grlib.h>	/* Genus GX graphics */

#define BEEP()	putchar(7)
#define ESC	0x1b

static void near init_screen	( void				);
static void near show_pattern	( int, int, char *		);
static void near exit_all	( void				);

/* main ***************************************************************/
/* the main loop ******************************************************/
/**********************************************************************/
int main(
	int	argc,
	char	**argv
	)
{
char	p[8]	= {0},
	dsc[25]	= {0};
FILE	*fp;
int     fg	= grLIGHTBLUE,
	bg	= grBLUE;

if ((fp=fopen(((argc==1)?"patterns.pat":argv[1]),"rb"))==NULL) exit(1);
if (argc==4) { fg=atoi(argv[2])%16; bg=atoi(argv[3])%16; }

init_screen();

/* sample of expected format - TooLate Fill-Pattern Editor patterns.pat
	{0x54,0x82,0x28,0x82,0x28,0x82,0x54,0x00}, // loose see-through net
*/

while (fscanf(fp," {%x,%x,%x,%x,%x,%x,%x,%x}, // %24[^\r\n]%*c",
		&p[0],&p[1],&p[2],&p[3],&p[4],&p[5],&p[6],&p[7],dsc)!=EOF) {
	show_pattern(fg,bg,p);
	grSetColor(grWHITE); grSetBkColor(grBLACK);
	grMoveTo(319,239); grOutText(dsc);
	BEEP(); if (getch()==ESC) break;
}

fclose(fp);

exit_all(); return 0;

} /*int main*/

/* init_screen ********************************************************/
/* init all stuff, draw GUI etc. **************************************/
/**********************************************************************/
static void near init_screen(void)
{

/* init graphics */
	if (gxSetDisplay(gxVGA_12)<0) exit(2);
	if (gxSetMode(gxGRAPHICS)<0) exit(3);
	grSetTextStyle(grTXT8X16,grOPAQUE);
	grSetTextJustify(grTCENTER,grTCENTER);
	gxClearDisplay(grBLACK,0);

} /*void init_screen*/

/* show_pattern *******************************************************/
/* full-screen fill-pattern *******************************************/
/**********************************************************************/
static void near show_pattern(
	int	fgcolor,
	int	bgcolor,
	char	*pattern
	)
{
	grSetFillStyle(grFUSER,fgcolor,grOPAQUE);
	grSetFillPattern(grFUSER,pattern);
	grSetBkColor(bgcolor);
	grDrawRect(0,0,639,479,grFILL);

} /*void show_pattern*/

/* exit_all ***********************************************************/
/* close down all the system ******************************************/
/**********************************************************************/
static void near exit_all(void)
{
	fflush(stdin);
	gxSetMode(gxTEXT);
	exit(0);

}/*void exit_all*/

/**********************************************************************/
/*************************** A HAPPY END ******************************/
/**********************************************************************/
