{ Show Some Windows }

uses SVGA256,Txt;

const
  ColorB:array[0..4] of byte=(52,53,54,0,32);  { Light,Med,Dark,Box,Title }
  ColorW:array[0..5] of byte=(1,30,3,52,+1,64);  { Head,Menu,Body,Box,BoxOrder,Title }

{  SetColorB  }
procedure SetColorB(Light,Med,Dark,Box,Title:integer);
begin
  ColorB[0]:=Light;
  ColorB[1]:=Med;
  ColorB[2]:=Dark;
  ColorB[3]:=Box;
  ColorB[4]:=Title;
end;
{  SetColorW  }
procedure SetColorW(Head,Menu,Body,Box,BoxOrder,Title:integer);
begin
  ColorW[0]:=Head;
  ColorW[1]:=Menu;
  ColorW[2]:=Body;
  ColorW[3]:=Box;
  ColorW[4]:=BoxOrder;
  ColorW[5]:=Title;
end;
{  Box1  }
procedure Box1(X,Y,LenX,LenY,C1,C2,N:integer);
var I:integer;
begin
  for I:=0 to N-1 do begin
    Bar(X,Y+I,LenX-I,1,C1);
    Bar(X+I,Y,1,LenY-I,C1);
    Bar(X+I,Y+LenY-1-I,LenX-I,1,C2);
    Bar(X+LenX-1-I,Y+I,1,LenY-I,C2);
  end;
end;
{  Box2  }
procedure Box2(X,Y,LenX,LenY,C1,C2,Med,N:integer);
var I:integer;
begin
  Dec(N);
  Box1(X,Y,LenX,LenY,C1,C2,1);
  Box1(X+N,Y+N,LenX-N shl 1,LenY-N shl 1,C2,C1,1);
  for I:=0 to N-2 do Box(X+1+I,Y+1+I,LenX-2-I shl 1,LenY-2-I shl 1,Med);
end;
{  Button  }  { Ty=Thin, UpDn=0-1 }
procedure Button(Ty,UpDn,X,Y,LenX,LenY:integer;Title:string);
var I:integer;
begin
  Box(X,Y,LenX,LenY,ColorB[3]);
  Box1(X+1,Y+1,LenX-2,LenY-2,ColorB[2-UpDn shl 1],ColorB[UpDn shl 1],Ty);
  Bar(X+1+Ty,Y+1+Ty,LenX-2-Ty shl 1,LenY-2-Ty shl 1,ColorB[1]);
  Print(X+1+(LenX-GetWidth(Title)) shr 1,Y+1+(LenY-10) shr 1,ColorB[0],Title);
  Print(X+(LenX-GetWidth(Title)) shr 1,Y+(LenY-10) shr 1,ColorB[4],Title);
end;
{  Window1  }
procedure Window1(X,Y,LenX,LenY:integer;Title:string);
var I:integer;
begin
  Bar(X,Y,LenX,30,ColorW[0]);          { Head }
  Bar(X,Y+30,LenX,20,ColorW[1]);       { Menu }
  Bar(X,Y+50,LenX,LenY-50,ColorW[2]);  { Body }
  Box(X,Y,LenX,LenY,0);                { Window Box }
  for I:=0 to 3 do                     { Window Frame }
    Box(X+I+1,Y+I+1,LenX-I shl 1-2,LenY-I shl 1-2,ColorW[3]+I*ColorW[4]);
  Bar(X+1,Y+26,4,1,0);            { Zoom Left,Up }
  Bar(X+26,Y+1,1,4,0);
  Bar(X+LenX-5,Y+26,4,1,0);       { Zoom Right,Up }
  Bar(X+LenX-27,Y+1,1,4,0);
  Bar(X+1,Y+LenY-27,4,1,0);       { Zoom Left,Down }
  Bar(X+26,Y+LenY-5,1,4,0);
  Bar(X+LenX-5,Y+LenY-27,4,1,0);  { Zoom Right,Down }
  Bar(X+LenX-27,Y+LenY-5,1,4,0);
  Box(X+5,Y+5,LenX-10,22,0);              { Head Box }
  Box(X+5,Y+29,LenX-10,22,0);             { Menu Box }
  Box(X+5,Y+53,LenX-10,LenY-58,0);        { Bofy Box }
  for I:=0 to 1 do begin
    Bar(X+5,Y+I+27,LenX-10,1,ColorW[3]+2*I*ColorW[4]);  { Head Lines }
    Bar(X+5,Y+51+I,LenX-10,1,ColorW[3]+2*I*ColorW[4]);  { Menu Lines }
  end;
  Print3A(1,X+(LenX-GetWidth(Title)) shr 1,Y+10,ColorW[5],2,1,Title);
  Button(2,1,X+5,Y+5,22,22,'-');
  Button(2,1,X+LenX-48,Y+5,22,22,'o');
  Button(2,1,X+LenX-27,Y+5,22,22,'[]');
end;
{  Screen1  }
procedure Screen1;
var I,J:integer;
    A:array[0..255] of byte;
begin
  Randomize;
  for I:=0 to 255 do A[I]:=24+Random(4);
  for I:=0 to 39 do for J:=0 to 29 do Put(16*I,16*J,16,16,A);
end;
{  Show1  }
procedure Show1(X,Y:integer);  { 400x330 }
var I,J:integer;
begin
  SetColorB(52,53,54,0,32);
  SetColorW(1,30,3,52,+1,64);
  Window1(X,Y,400,330,'Blue Window');
  Print(X+24,Y+35,0,'File  Window  Help');
  Button(2,1,X+30,Y+275,160,26,'Other Window');  { Button }
  Box1(X+30-2,Y+275-2,160+4,26+4,11,0,1);
  Button(2,1,X+205,Y+275,80,26,'Exit');          { Button }
  Box1(X+205-2,Y+275-2,80+4,26+4,11,0,1);
  Box2(X+15,Y+65,370,192,11,0,3,3);              { Up Frame }
  Box2(X+15,Y+263,370,50,11,0,3,3);              { Bottom Frame }
  Box2(X+40,Y+85,320,155,0,11,3,2);              { Pal Frame }
  Bar(X+170,Y+80,58,12,ColorW[2]);
  PrintA(X+175,Y+80,11,1,'Palette');
  for I:=0 to 15 do for J:=0 to 15 do Bar(X+55+18*J,Y+100+8*I,18,8,16*I+J);
end;
{  Show2  }
procedure Show2(X,Y:integer);  { 300x200 }
begin
  SetColorB(30,28,25,0,8);
  SetColorW(8,30,7,31,-2,64);
  Window1(X,Y,300,200,'Grey Window');
  Print(X+24,Y+35,0,'File  Window  Help');
  Box2(X+20,Y+65,260,120,15,0,7,3);
  Box2(X+40,Y+80,220,90,0,15,7,2);
  Button(2,1,X+165,Y+130,80,26,'Exit');
  Box1(X+165-2,Y+130-2,80+4,26+4,15,0,1);
end;
{  Show3  }
procedure Show3(X,Y:integer);  { 300x200 }
begin
  SetColorB(68,66,64,0,6);
  SetColorW(5,30,62,67,-1,64);
  Window1(X,Y,300,200,'Red Window');
  Print(X+24,Y+35,0,'File  Window  Help');
  Box2(X+20,Y+65,260,120,66,0,62,3);
  Box2(X+40,Y+80,220,90,0,66,62,2);
  Button(2,1,X+165,Y+130,80,26,'Exit');
  Box1(X+165-2,Y+130-2,80+4,26+4,66,0,1);
end;
{  Show4  }
procedure Show4(X,Y:integer);  { 300x200 }
begin
  SetColorB(10,2,120,0,120);
  SetColorW(120,30,2,47,-1,64);
  Window1(X,Y,300,200,'Green Window');
  Print(X+24,Y+35,0,'File  Window  Help');
  Box2(X+20,Y+65,260,120,10,0,2,3);
  Box2(X+40,Y+80,220,90,0,10,2,2);
  Button(2,1,X+165,Y+130,80,26,'Exit');
  Box1(X+165-2,Y+130-2,80+4,26+4,10,0,1);
end;

var Font:array[0..5000] of byte;
begin
  SetMode(3);
  FileRead('1212sim#.fnt',0,96,24,Font);
  InstallFont(2,16,12,32,96,1,Font);
  Screen1;
  Show1(20,20);
  Show4(320,80);
  Show3(120,260);
  Show2(220,170);
  Readln;
  SetMode(0);
end.
