{ Hardware Panning / VGA 320x200,256 Colors }

uses SVGA256,Txt;

{  SetDisplay  }
procedure SetDisplay(X,Y:integer);
var A:integer;
begin
  while Port[$3DA] and 8=8 do;
  while Port[$3DA] and 8<>8 do;
  while Port[$3DA] and 1=1 do;
  while Port[$3DA] and 1<>1 do;
  A:=80*Y+X shr 2;
  Port[$3D4]:=$0C; Port[$3D5]:=A shr 8;    { Start addr high }
  Port[$3D4]:=$0D; Port[$3D5]:=A and $FF;  { Start addr low }
  A:=Port[$3DA];                           { Horizental PEL panning }
  Port[$3C0]:=$13 or $20; Port[$3C0]:=(X mod 4) shl 1;
end;
{  Scroll  }
procedure Scroll;
var K,K2,X,Y,N:integer;
begin
  SetMode(1);
  Bar(0,0,320,200,1);
  for X:=0 to 3 do Box(X,X,320-2*X,200-2*X,52+X);
  InstallFont(1,8,16,0,256,0,GetFontAddr(6)^);
  for K:=0 to 11 do Print(150*(K and 1)+20,28*(K shr 1)+20,64+K,
    'Hardware Panning');
  X:=0; Y:=0; K:=0; K2:=-1; N:=4;
  repeat
    SetDisplay(X mod 320,Y mod 200);
    if KeyPressed then begin K:=Key; if K=K2 then K:=Key; K2:=K; end;
    case K of
      $4B00:Dec(X,N);  $4D00:Inc(X,N);      { Left,Right }
      $4800:Dec(Y,N);  $5000:Inc(Y,N);      { Up,Down }
      $4700:begin Dec(X,N); Dec(Y,N); end;  { Home }
      $4F00:begin Dec(X,N); Inc(Y,N); end;  { End }
      $4900:begin Inc(X,N); Dec(Y,N); end;  { PgUp }
      $5100:begin Inc(X,N); Inc(Y,N); end;  { PgDn }
    end;
    if X<0 then X:=0; if X>319 then X:=319;
    if Y<0 then Y:=0; if Y>199 then Y:=199;
  until (K=$011B) or (K=$1C0D);             { Esc,Enter }
  SetDisplay(1,1); SetMode(1);
end;

begin
  Scroll;
  VideoMode(3);
end.
