/*
  Find JFIF header in image
  
  Written by Jih-Shin Ho, 1995
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define DONT_CARE 0x100
static short id[] = {0xff,0xd8,0xff,0xe0,DONT_CARE,DONT_CARE,
                     'J','F','I','F'};
static int num_id = sizeof(id) / sizeof(short);

#define CHUNK_SIZE (2 * 1024)
static int data_stop;
static unsigned char data[CHUNK_SIZE * 2];
static unsigned char *current_data = data + CHUNK_SIZE;
static int file_end;
static FILE *text_inf;

#define GET_CHAR(from) (from < data_stop ? current_data[from] : fill_data(&from))

/*
  For sequential reading only
*/
static int fill_data(int *from)
{
  int read_size;
  
  if (file_end) return(EOF);
  if (data_stop) memmove(data,current_data,CHUNK_SIZE);
  read_size = fread(current_data,1,CHUNK_SIZE,text_inf);
  if (read_size < CHUNK_SIZE) {
    file_end = 1;
    if (read_size < 0) read_size = 0;
  }
  if (read_size == 0) return(EOF);
  *from -= data_stop;
  data_stop = read_size;
  return(current_data[*from]);
}


int main(int argc,char *argv[])
{
  int i,found,match_count,from;
  FILE *in,*out;

  if (argc != 3) {
    printf("\nUsage: findjpg input_file output_file\n\n");
    return(1);
  }
  in = fopen(argv[1],"rb");
  if (in == NULL) {
    printf("Can't open %s\n",argv[1]);
    return(1);
  }
  out = fopen(argv[2],"wb");
  if (out == NULL) {
    fclose(in);
    printf("Can't open %s\n",argv[2]);
    return(1);
  }

  printf("Search JFIF header. Please wait ....\n");

  match_count = found = 0;
  file_end = from = data_stop = 0;
  text_inf = in;
  while ((i = GET_CHAR(from)) != EOF) {
    from++;
    if (id[match_count] == DONT_CARE || i == id[match_count]) {
      match_count++;
      if (match_count == num_id) {
        printf("JFIF header found.\n");
        found = 1;
        break;
      }
    }
    else if (match_count) {
      from -= match_count;
      match_count = 0;
    }
  }

  if (found) {
    printf("Write JFIF stream data to new file. Please wait ....\n");
    from -= num_id;
    while ((i = GET_CHAR(from)) != EOF) { putc(i,out); from++; }
  }
  fclose(in);
  fclose(out);
  if (found) printf("\nDone.\n");
  else {
    remove(argv[2]);
    printf("\nJFIF header not found.\n");
  }
  return(0);
}
