/*                        Sprite & Scrolling Engine                         */
/*        Copyright (c) Genesoft 1995-1996.  All rights reserved.           */

#include<sse.h>
#include<ssedvid.h>
#include<ssepal.h>
#include<ssecapt.h>

#include<stdio.h>
#include<conio.h>
#include<stdlib.h>
#include<string.h>

#include"mapmaker.h"

#define BUFFER_SIZE 0x300000  // Three Meg buffer-size

int ScreenWidth, ScreenHeight, ScreenMode;
unsigned char Black, Gray, White;

int main( int argc, char * argv[] )
{
   void FindColors( void );
   int i;
#define NumModes 6
   char * ModeInput[] = { "320x175", "360x175", "320x200", "360x200", "320x240", "360x240" };
   int ModeNumber[] = { MODE_320x175x256, MODE_360x175x256, MODE_320x200x256,
                        MODE_360x200x256, MODE_320x240x256, MODE_360x240x256 };

   if( argc != 4 )
   {
      printf( "\nUsage: MAPMAKER <video-mode> <til-name> <map-name>\n\n" );
      return EXIT_FAILURE;
   }
   
   for( i=0; i<NumModes; i++ ) if( !strcmp(strlwr(argv[1]),ModeInput[i])) break;

   if( i==NumModes )
   {
      printf( "\nAccepted video mode values:\n   " );
      for( i=0; i<NumModes; i++ ) printf("%s ", ModeInput[i]);
      printf("\n\n");
      return EXIT_FAILURE;
   }
   ScreenMode = ModeNumber[i];
   ScreenWidth = sseModeInfo[ScreenMode].HorizontalRes;
   ScreenHeight = sseModeInfo[ScreenMode].VerticalRes;

   mouseInit();
   if( ! mouseEnabled )
   {
      printf( "\nMouse not detected!\n\n" );
      return EXIT_FAILURE;
   }

   if( SetupBuffer( BUFFER_SIZE ) )
   {
      printf( "\nMemory allocation failed!\n" );
      printf( "  Solution: Free more EMS/XMS or reduce MAPMAKER \"BUFFER_SIZE\" value.\n\n" );
      return EXIT_FAILURE;
   }
   
   if( LoadTiles( argv[2] ) )
   {
      printf( "\nError loading Tile Set \"%s\"\n\n", argv[2] );
      return EXIT_FAILURE;
   }

   if( LoadMap( argv[3] ) )
   {
      switch ( CreateMap( argv[3] ) )
      {
         case -1:
            printf( "\nError Loading Map \"%s\"", argv[3] );
            return EXIT_FAILURE;
         case -2:
            printf( "\nError Creating Map \"%s\"", argv[3] );
            return EXIT_FAILURE;
      }
   }
   
   FindColors();

   SetupSprites();

   EditMap();

   sseRestoreVideoMode();

   return EXIT_SUCCESS;
}

palRegister PWhite = {63,63,63};
palRegister PGray = {31,31,31};
palRegister PBlack = {0,0,0};

void FindColors( void )
{
   Black = palFindClosest( & PBlack, Tiles->Palette, 256 );
   White = palFindClosest( & PWhite, Tiles->Palette, 256 );
   Gray = palFindClosest( & PGray, Tiles->Palette, 256 );
}
