/******************************* vesainf.cpp ********************************/
/*	Author: Don Lewis                                                       */
/*  Date:   February 22, 1993                                               */
/* Description:                                                             */
/*				This set of routines is the VESA interface. It allows       */
/*              access to VESA functions and information.           */
/****************************************************************************/

#include <stdio.h>
#include <dos.h>
#include <process.h>
#include <string.h>
#include "vheader.h" /* VESA, PCX and TARGA header info. */


#define VIDEO 0x10

struct VgaInfoBlock info;
struct ModeInfoBlock modeinfo;
struct REGPACK reg;

ReturnCurrentMode(int curmode);
int VesaFunctions(void);
void SetSvgaMode(int);
void GetSvgaInfo(void);
void ReturnSvgaMode(int);
void tone(void);		/* I threw this in for fun */


void VesaFunctions(int NewMode)
{
   SetSvgaMode (NewMode); /* use vga24.asm init function */
   GetSvgaInfo();     /* retrieves all kinda good info */
   ReturnSvgaMode(NewMode); /* retrieves even more great stuff */
}
/* Get SVGA VESA information and pass back to VgaInfoBlock structure */
void GetSvgaInfo(void)
{
    reg.r_ax = 0x4F00;
    reg.r_es = FP_SEG(&info);
	reg.r_di = FP_OFF(&info);
    intr(VIDEO, &reg);

    if (reg.r_ax != 0x004f) {
	printf("Current configuration does not support GetSvgaInfo .\n");
	exit(1);
    }
}
/* Get SVGA MODE information and return to ModeInfoBlock structure */
void ReturnSvgaMode(int nmode)
{
	memset(&modeinfo, '\0', 256);
	reg.r_ax = 0x4F01;
    reg.r_cx = nmode;
    reg.r_es = FP_SEG(&modeinfo);
    reg.r_di = FP_OFF(&modeinfo);
    intr(VIDEO, &reg);

    if (reg.r_ax != 0x004f) {
	printf("Current configuration does not support ReturnSvgaMode.\n");
	exit(1);
    }
}

/* Sets the video card to VESA mode if it is supported */
void SetSvgaMode(int nmode)
{
    reg.r_ax = 0x4F02;
    reg.r_bx = nmode;
    intr(VIDEO, &reg);

    if (reg.r_ax != 0x004f) {
	printf("Configuration does not support VESA set VGA mode 0x%xh\n",
			nmode);
	exit(1);
    }
}
/* like it says, Returns the video mode currently in use. */
ReturnCurrentMode(int curmode)
{
	reg.r_ax = 0x4F03;
	intr(VIDEO, &reg);

	if (reg.r_ax != 0x004f) {
	printf("Return current video mode failed!\n");
	exit(1);
	}
	curmode = reg.r_bx;
	return(curmode);
}
/* Generate an attention sound. */
void tone(void)
{
    int i;
	for (i=440; i<=3520; i+=880)
    {
       sound(i);
       delay(100);
       nosound();
    }
}
