/* vheader.h -------------- VESA HEADER info --------------- January 1993 */
/* Written by Don Lewis. <djlewis@ualr.edu> <djlewis@spider.ualr.edu>     */
/* structure of SVGA information to tie to 'C' functions. I threw in      */
/* the PCX and TARGA header info to make it easy to read and display      */
/* those types of pictures. I have already written PCX code for Hi-color  */
/* picture display.							  */

#ifndef _vheader_h_
#define _vheader_h_

#define _Cdecl  cdecl

/* VESA video card Information block  */
struct  VgaInfoBlock {
	char VESASignature[4];
	int  VESAVersion;
	unsigned long *OEMStringPtr;
	long Capabilities;
	unsigned int  *VideoModePtr;
	int  TotalMemory;
	char Reserved[236];
	} ;
/* VESA video card capabilities block  */
struct  ModeInfoBlock {
	int  ModeAttributes;
	char WinAAttributes;
	char WinBAttributes;
	int  WinGranularity;
	int  WinSize;
	unsigned int  WinASegment;
	unsigned int  WinBSegment;
	unsigned long *WinFuncPtr;
	int  BytesPerScanLine;
	int  XResolution;
	int  YResolution;
	char XCharSize;
	char YCharSize;
	char NumberOfPlanes;
	char BitsPerPixel;
	char NumberOfBanks;
	char MemoryModel;
	char BankSize;
	char NumberOfImagePages;
	char SizeOfBank;
	char RedMaskSize;
	char RedFieldPosition;
	char GreenMaskSize;
	char GreenFieldPosition;
	char BlueMaskSize;
	char BlueFieldPosition;
	char RsvdMaskSize;
	char RsvdFieldPosition;
	char DirectColorModeInfo;
	char Reserved[216];
	} ;
/* TARGA picture file header structure  */
struct TargaHdStruct {
	char textSize;
	char mapType;
	char dataType;
	int  mapOrig;
	int  mapLength;
	char CMapBits;
	int  XOffset;
	int  YOffset;
	int  x;
	int  y;
	char dataBits;
	char imType;
	};
/* PCX picture file header structure  */
struct PCXHEAD {
	char manufacturer;
	char version;
	char encoding;
	char bits_per_pixel;
	int  xmin, ymin;
	int  xmax, ymax;
	int  hres, vres;
	char palette[48];
	char reserved;
	char colour_planes;
	int  bytes_per_line;
	int  filler[58];
	};

#endif

