/**<blnr.c>**************************************************
*                       V O U C H                           *
*   VOUCH 1.1  Copyright (c) 1993, 1994  Awais M Hussain    *
*                   All rights reserved                     *
*************************************************************/
/* Consult <blnr.man> for documentation. */

/* Basic Long-Number arithmetic routines */

/* Assembly (386) coded version of (most of) these routines are
   available in the VCH/386 C-source package. 
*/   

/* CAUTION: All procedures assume that the lengths of longNumbers
    are specified correctly; there should be no leading zero-words. */

#include <mem.h>
#include <stdlib.h>
#include "vch.h"

extern unsigned bLen ;

extern
unsigned fb1( long xx ) ;
/* position of the first 1-bit scanning from left (MSB) */
/* position = 0,..,31 from LSB  */

extern
 void laddc(long unsigned *carry, long unsigned *x1, long unsigned x2 ) ;
/* add with carry: (carry, x1) = x1 + x2 + carry */
/* assembly routine in "blnrasm.c" */

extern
 void lmulta(long unsigned *x1, long unsigned x2, long unsigned *x3) ;
/* multiply and add: (x1, x3) = x1 * x2 + x3 */
/* assembly routine in "blnrasm.c" */

int isLess( lenLN Lo1, ptrLN  o1, lenLN Lo2, ptrLN o2 ) ;
/* o1 < o2 => isLess */

int isGreater( lenLN Lo1, ptrLN o1, lenLN Lo2, ptrLN o2 ) ;
/* o1 > o2 => isGreater */

int isEqual( lenLN Lo1, ptrLN o1, lenLN Lo2, ptrLN o2 ) ;
/* o1 = o2 => isEqual */

void shiftL( unsigned bshft, lenLN Lo, ptrLN oo,
				    lenLN  *Los, ptrLN os ) ;
/* os := shift_Left oo by bshft_bits  */

void shiftR( unsigned bshft, lenLN Lo, ptrLN oo,
				     lenLN *Los, ptrLN os ) ;
/* os := shift_Right oo by bshft_bits  */

void accum( lenLN Lox, ptrLN ox, lenLN *Lrr, ptrLN rr )  ;
/* rr := rr + ox */

void subt( lenLN Lox, ptrLN ox, lenLN *Lrr, ptrLN rr ) ;
/* rr := rr-ox ; rr > ox */

void mult( lenLN Lo1, ptrLN o1, lenLN Lo2, ptrLN o2,
				      lenLN *Lrr, ptrLN rr ) ;
/* rr := o1 * o2 */

void divide( lenLN Ldr, ptrLN dr, lenLN Ldd, ptrLN dd,
		 lenLN *Lqt, ptrLN qt, lenLN *Lrr, ptrLN rr ) ;
/* divisor: dr  ;  dividend: dd */
/* quotient: qt := dd div dr  ; remainder: rr := dd mod dr */

void modR( lenLN Ldd, ptrLN dd, lenLN Ldr, ptrLN dr,
					  lenLN *Lrr, ptrLN rr ) ;
/* divisor: dr  ;  dividend: dd */
/* remainder: rr := dd mod dr */

int isLess( lenLN Lo1, ptrLN  o1, lenLN Lo2, ptrLN o2 )
/* o1 < o2 => isLess */
{
 ptrLN  o1h, o2h ;

 if (Lo1<Lo2) return(1) ;
 if (Lo1>Lo2) return(0) ;
 o1h = o1+Lo1-1 ;
 o2h = o2+Lo1-1 ;
 do {
  if (*o1h<*o2h) return(1) ;
  if (*o1h>*o2h) return(0) ;
  o1h-- ; o2h-- ;
 } while ( o1h>=o1 ) ;
 return(0) ;
}/* isLess */


int isGreater( lenLN Lo1, ptrLN o1, lenLN Lo2, ptrLN o2 )
/* o1 > o2 => isGreater */
{
 ptrLN  o1h, o2h ;

 if (Lo1<Lo2) return(0) ;
 if (Lo1>Lo2) return(1) ;
 o1h = o1+Lo1-1 ;
 o2h = o2+Lo1-1 ;
 do {
  if (*o1h<*o2h) return(0) ;
  if (*o1h>*o2h) return(1) ;
  o1h-- ; o2h-- ;
 } while ( o1h>=o1 ) ;
 return(0) ;
}/* isGreater */


int isEqual( lenLN Lo1, ptrLN o1, lenLN Lo2, ptrLN o2 )
/* o1 = o2 => isEqual */
{
 ptrLN  o1h ;

 if (Lo1 != Lo2) return(0) ;
 o1h = o1+Lo1 ;
 do {
  if (*o1 != *o2) return(0) ;
  o1++ ; o2++ ;
 } while ( o1<o1h ) ;
 return(1) ;
}/* isEqual */


void shiftL( unsigned bshft, lenLN Lo, ptrLN oo,
				    lenLN *Los, ptrLN os )
/* os := shift_Left oo by bshft_bits  */
{
 unsigned  Mbshft, cMbshft, Ibshft ;
 ptrLN  os_end, oo_end ;

 Ibshft = bshft/32 ;
 if ( (Mbshft = bshft % 32) == 0) {
  *Los = Lo + Ibshft ;
  setmem( os, 4*Ibshft, 0 ) ;
  movmem( oo, os+Ibshft, 4*Lo ) ;
  return ;
 }
 *Los = Lo + Ibshft + 1 ;
 setmem( os, 4**Los, 0 ) ;
 os_end = os + *Los -1 ;
 oo_end = oo + Lo -1 ;
 cMbshft = 32-Mbshft ;
 while (oo_end >= oo ) {
  *os_end |= *oo_end >> cMbshft  ;
  *(--os_end) = *(oo_end--) << Mbshft ;
 }
 os += *Los-1 ;
 while ( (*os==0) & (*Los>1) ) {
  (*Los)-- ; os-- ;
 }
} /* shiftL */


void shiftR( unsigned bshft, lenLN Lo, ptrLN oo,
				     lenLN *Los, ptrLN os )
/* os := shift_Right oo by bshft_bits  */
{
 unsigned Mbshft, Ibshft, cMbshft ;
 ptrLN  oo_end ;

 Mbshft = bshft % 32 ;
 Ibshft = bshft / 32 ;
 if (Lo<Ibshft+1) {
  *Los = 1 ; *os = 0 ; return ;
 }
 if (Mbshft==0) {
   *Los = Lo - Ibshft ;
   movmem( oo+Ibshft, os, *Los ) ;
   return ;
 }
 *Los = Lo - Ibshft ;
 setmem( os, 4**Los, 0 ) ;
 oo_end = oo + Lo ; *oo_end = 0 ;
 oo += Ibshft ; cMbshft = 32-Mbshft ;
 while ( oo < oo_end ) {
  *os = *oo >> Mbshft ;
  *(os++) |= *(++oo) << cMbshft ;
 }
 os-- ;
 while ( (*os==0) & (*Los>1) ) {
  (*Los)-- ; os-- ;
 }
}/* shiftR */


void accum( lenLN Lox, ptrLN ox, lenLN *Lrr, ptrLN rr )
/* rr := rr + ox */
{
 ptrLN  ox_end, rr_end, rr_e ;
 long unsigned  cr = 0 ;

 if (*Lrr<Lox) {
  setmem( rr+*Lrr, 4*(Lox-*Lrr), 0 ) ;
  *Lrr = Lox ;
 }
 *(rr+*Lrr) = 0 ;
 (*Lrr)++ ;
 rr_end = rr_e = rr + *Lrr ;
 ox_end = ox + Lox ;
 while (ox<ox_end) {
  laddc( &cr, rr, *ox ) ;
  rr++ ; ox++ ;
 }
 while ( (rr<rr_end) & (cr!=0) ) {
  laddc( &cr, rr, 0 ) ;
  rr++ ;
 }
 --rr_e ;
 while ( (*rr_e==0) & (*Lrr>1) ) {
  (*Lrr)-- ; rr_e-- ;
 }
}/* accum */


void subt( lenLN Lox, ptrLN ox, lenLN *Lrr, ptrLN rr )
/* rr := rr-ox ; rr > ox */
{
 ptrLN  ox_end, rr_end ;
 long unsigned  cr = 1 ;

 rr_end = rr + *Lrr ;
 ox_end = ox + Lox ;
 while (ox<ox_end) {
  laddc( &cr, rr, ~*ox ) ;
  rr++ ; ox++ ;
 }
 while (rr<rr_end) {
  laddc( &cr, rr, 0xFFFFFFFF ) ;
  rr++ ;
 }
 --rr ;
 while ( (*rr==0) & (*Lrr>1) ) {
  (*Lrr)-- ; rr-- ;
 }
}/* subt */


void mult( lenLN Lo1, ptrLN o1, lenLN Lo2, ptrLN o2,
				      lenLN *Lrr, ptrLN rr )
/* rr := o1 * o2 */
{
 ptrLN  rc, rc_s, o2_c, o2_end, o1_end ;
 unsigned ix ;

 if (Lo1>Lo2) {
  ix = Lo1 ; Lo1 = Lo2 ; Lo2 = ix ;
  rc = o1 ; o1 = o2 ; o2 = rc ;
 }
 rc = (ptrLN) malloc( bLen ) ;
 rc_s = rc ;
 setmem( rr, 4*(Lo1+Lo2), 0 ) ;
 *Lrr = Lo2 + 1 ; ix = 0 ;
 o1_end = o1 + Lo1 ;
 o2_end = o2 + Lo2 ;
 while ( o1 < o1_end ) {
  rc = rc_s ;
  setmem( rc, 4*(Lo2+1), 0 ) ;
  o2_c = o2 ;
  while ( o2_c < o2_end ) {
   *(rc+1) = *o2_c ;
   lmulta( rc+1, *o1, rc ) ;
   rc++ ; o2_c++ ;
  }
  memmove( rc_s+ix, rc_s, 4*(Lo2+1) ) ;
  memset( rc_s, 0, 4*ix ) ;
  accum( Lo2+1+ix, rc_s, Lrr, rr ) ;
  o1++ ; ix++ ;
 }
 rr += *Lrr - 1 ;
 while ( (*rr==0) & (*Lrr>1) ) {
  (*Lrr)-- ; rr-- ;
 }
 free( rc_s ) ;
}/* mult */


void divide( lenLN Ldr, ptrLN dr, lenLN Ldd, ptrLN dd,
		 lenLN *Lqt, ptrLN qt, lenLN *Lrr, ptrLN rr )
/* divisor: dr  ;  dividend: dd */
/* quotient: qt := dd div dr  ; remainder: rr := dd mod dr */
{
 unsigned  bzdr, bshft, Ibshft ;
 lenLN Lsdr ;
 ptrLN sdr ;

 *Lrr = Ldd ;
 movmem( dd, rr, 4*Ldd ) ;
 if ((Ldr>Ldd) || ((Ldr==Ldd) && isLess(Ldd,dd,Ldr,dr))) {
    *Lqt = 1 ; *qt = 0 ;
    return ;
 }
 sdr = (ptrLN) malloc( bLen ) ;
 *Lqt = Ldd ;
 setmem( qt, 4**Lqt, 0 ) ;
 bzdr = (Ldr-1)*32 + fb1(*(dr+Ldr-1)) ;
 do {
  bshft = (*Lrr-1)*32 + fb1(*(rr+*Lrr-1)) - bzdr ;
  shiftL( bshft, Ldr, dr, &Lsdr, sdr ) ;
  if (isGreater( Lsdr, sdr, *Lrr, rr )) {
    bshft--  ; shiftL( bshft, Ldr, dr, &Lsdr, sdr ) ;
  }
  subt( Lsdr, sdr, Lrr, rr ) ;
  Ibshft = bshft / 32 ;
  *(qt+Ibshft) |= 1LU << (bshft % 32) ;
 } while ( (*Lrr>Ldr) || ((*Lrr==Ldr) && !isGreater(Ldr,dr,*Lrr,rr)) ) ;
 rr += *Lrr - 1 ;
 while ( (*rr==0) && (*Lrr>1) ) {
  (*Lrr)-- ; rr-- ;
 }
 qt += *Lqt - 1 ;
 while ( (*qt==0) && (*Lqt>1) ) {
  (*Lqt)-- ; qt-- ;
 }
 free( sdr ) ;
}/* divide */


void modR( lenLN Ldd, ptrLN dd, lenLN Ldr, ptrLN dr,
					  lenLN *Lrr, ptrLN rr )
/* divisor: dr  ;  dividend: dd */
/* remainder: rr := dd mod dr */
{
 unsigned  bzdr, bshft ;
 lenLN Lsdr ;
 ptrLN  sdr ;

 *Lrr = Ldd ;
 movmem( dd, rr, 4*Ldd ) ;
 if ((Ldr>Ldd) || ((Ldr==Ldd) && isLess(Ldd,dd,Ldr,dr))) return ;
 sdr = (ptrLN) malloc( bLen ) ;
 bzdr = (Ldr-1)*32 + fb1(*(dr+Ldr-1)) ;
 do {
  bshft = (*Lrr-1)*32 + fb1(*(rr+*Lrr-1)) - bzdr ;
  shiftL( bshft, Ldr, dr, &Lsdr, sdr ) ;
  if (isGreater( Lsdr, sdr, *Lrr, rr )) {
    bshft--  ; shiftL( bshft, Ldr, dr, &Lsdr, sdr ) ;
  }
  subt( Lsdr, sdr, Lrr, rr ) ;
 } while ( (*Lrr>Ldr) || ( (*Lrr==Ldr) && !isGreater(Ldr,dr,*Lrr,rr) ) ) ;
 rr += *Lrr - 1 ;
 while ( (*rr==0) && (*Lrr>1) ) {
  (*Lrr)-- ; rr-- ;
 }
 free( sdr ) ;
}/*modR*/
