/**<b2a.c>***************************************************
*                       V O U C H                           *
*   VOUCH 1.1  Copyright (c) 1993, 1994  Awais M Hussain    *
*                   All rights reserved                     *
*************************************************************/
/* Consult <b2a.man> for documentation. 
*/
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

char buffR[4800], buffW[6600] ;

const char  *txtID="vch 1.1 utility :6-bit alphabet encoded\r\n" ;

/* convert block of 4800 bytes into 6600 bytes */
/* 100 lines output of 64 charaters each (line-feed and carriage-return add
                                           2 bytes to each line) */
/* 48 input bytes produce a line of 64+2=66 bytes  */
/* 3 bytes of input give 4 bytes of output */
void six2byte( int *nW )
{
  int i, j, nR ;

  *nW = 0 ;
  for (i=0; i<100; ++i) {
    for (j=0; j<16; ++j) {
      nR = i*48 + 3*j ;
      buffW[(*nW)++] = ((buffR[nR] & 0xFC) >> 2)  + 48 ;
      buffW[(*nW)++] = ( ((buffR[nR] & 0x03) << 4 ) |
         	         ((buffR[nR+1] & 0xF0) >> 4) ) + 48 ;
      buffW[(*nW)++] = ( ((buffR[nR+1] & 0x0F) << 2) |
        	          ((buffR[nR+2] & 0xC0) >> 6) ) + 48 ;
      buffW[(*nW)++] =  (buffR[nR+2] & 0x3F) + 48 ;
   }
   buffW[(*nW)++] = 13 ;
   buffW[(*nW)++] = 10 ;
 }
}/*six2byte*/


void bin2text( char *fnr, char *fnw )
{
  int nW, cnt, rcnt, wcnt, d48, m48, d03, m03 ;
  FILE  *fr, *fw ;

  if ( (fr=fopen( fnr, "rb")) == (FILE*) NULL ) exit(errno) ;
  if ( (fw=fopen( fnw, "wb")) == (FILE*) NULL ) exit(errno) ;
  fputs( txtID, fw ) ;
  cnt = 4800 ; rcnt = cnt ;
  while (rcnt==cnt) {
    rcnt = fread( buffR, 1, cnt, fr ) ;
    six2byte( &nW ) ;
    if (rcnt<cnt) {
      d48 = rcnt / 48 ;
      m48 = rcnt % 48 ;
      d03 = m48 / 3 ;
      m03 = m48 % 3 ;
      nW = d48 * 66 + d03 * 4 ;
      if (m03==1)  nW += 2 ;
      if (m03==2)  nW +=3 ;
      if (m48!=0) {
        buffW[nW++] = 13 ;
        buffW[nW++] = 10 ;
      }
    }
    wcnt = fwrite( buffW, 1, nW, fw ) ;
    if (wcnt<nW) {
      perror("disk write error. ") ;
      fclose( fr ) ; fclose( fw ) ;
      exit(5) ;
    }
  }
  fclose( fr ) ; fclose( fw ) ;
}/*bin2text*/


main( int argc, char *argv[] )
{
  if (argc!=3) {
    puts("B2A 1.1, VOUCH Utility, Copyright (c) 1993, 1994  Awais M. Hussain") ;
    puts("    Encodes file using 6-bit alphabet. (Use a2b.exe for decoding.)") ;
    puts("    Encoding is generally used when sending non-text files via email.\n") ;
    puts("Usage: b2a.exe <inFile> <outFile>" ) ;
    exit(1) ;
  }
  bin2text( argv[1], argv[2] ) ;
}