/**<hlp.c>***************************************************
*                       V O U C H                           *
*   VOUCH 1.1  Copyright (c) 1993, 1994  Awais M Hussain    *
*                   All rights reserved                     *
*************************************************************/
/* Consult <hlp.man> for documentation. 
*/
#include <stdio.h>
#include <stdlib.h>

void helpScr( void ) ;

void exit_hlp( int option ) ;

/*****************************************************/

void helpScr( void ) 
{
  puts("\nVOUCH Version 1.1, Copyright (c) 1993, 1994  Awais M. Hussain ") ;
  puts("                   All rights reserved." ) ;
  puts("       NIST Digital Signature Authentication Standard (DSS) \n");
  puts("  Vch /k") ;
  puts("  Vch /sgn   <message>  <signed_message>  [password] ") ;
  puts("  Vch /vsgn  <signed_message>  <signer's_public_key> ") ;
  puts("  Vch /c     <plain>  <cipher>  <receiver's_public_key> ") ;
  puts("  Vch /d     <cipher>  <plain>  [password] " ) ;
  puts("");
  puts("      /k = Generate new public- and private-keys") ;
  puts("    /sgn = Sign <message> (for sending)") ;
  puts("   /vsgn = Verify (received) <signed_message>") ;
  puts("      /c = Encrpyt <plain> using receiver's public-key") ;
  puts("      /d = Decrpyt <cipher> ") ;
  puts("");
  puts("  Entries within <..> denote filenames.") ;
  puts("  Signed_message = (r_signature, s_signature, message).") ;
  puts("");
  puts("For additional options (/p,/h,/sig,/fsig,/fsgn,/r,/vsig,/z), \nconsult <usrGuide.vch>") ;
  puts("   'Vch /option', for specific help.") ;
}/* helpScr */

void exit_hlp( int option ) 
{
  switch (option) {
    case 10: 
    case 11:
          puts("Sign message ; Sign hash.") ;
          puts(" Vch /sgn  <message>  <signed_message>  [password] ") ;
          puts(" Vch /sig  <hash>  <signature>  [password] ") ;
          break ;
    case 20: 
    case 21:
         puts("Fast sign message ; Fast sign hash ; See also Vch /r ") ;
         puts(" Vch /fsgn  <message>  <signed_message>  [password] ") ;
         puts(" Vch /fsig  <hash>  <signature>  [password] ") ;
         break ;
    case 80: 
         puts("Pre_compute r_signatures.") ;
         puts(" Vch /r  number  [password]") ;
         break ;
    case 30: 
    case 31:
         puts("Verify signed_message ; Verify signature.") ;
         puts(" Vch /vsgn  <signed_message>  <signer's_public_key> ") ;
         puts(" Vch /vsig  <signature>  <signer's_public_key> ") ;
         break ;
    case 32:
         puts("Verify if signed_message is from the VOUCH's author.") ;
         puts(" Vch /z  <signed_message> ") ;
         break ;	 
    case 40: 
         puts("Hash file. ") ;
         puts(" Vch /h  <message>  <hash>  [<signature>] ") ;
         break ;
    case 50: 
         puts("Encrypt file. ") ;
         puts(" Vch /c  <plain>  <cipher>  <receiver's_public_key> ") ;
         break ;
    case 60: 
         puts("Decrypt file. ") ;
         puts(" Vch /d  <cipher>  <plain>  [password] ") ;
         break ;
    case 70:
         puts("Generate new keys. ") ;
	 puts(" Vch /k " ) ;
	 break ;
    case 90:
         puts("1) Verifies password \n2) Checks integrity of your keys ") ;
	 puts(" Vch /p " ) ;
	 break ;
    case 100:
         puts("Store individualization string."	 ) ;
	 puts(" Vch /i " ) ;
	 break ;
    default:   puts(" Vch /?   for help.") ;
  }
  exit( 1 ) ;
}/* exit_hlp */
