/*****************************************************************************
*   Routines to	set and	handle the scaling of the drawing, and other params.:*
*									     *
* Written by:  Gershon Elber			       Ver 0.1,	Apr. 1988    *
*****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <graphics.h>
#include <string.h>
#include <math.h>
#include "GraphGnG.h"
#include "Expr2TrG.h"
#include "GenMat.h"
#include "Program.h"

static void UpdateParamFlags(struct MenuItem SetParamMenu[],
	double UMin, double UMax, double VMin, double VMax,
	int NumOfSamples, int NumOfIsoLines, int DblBuffer);

/*****************************************************************************
*   Main routine of the	SetScale module	- set the Menu and call	the	     *
* requested routines.							     *
*****************************************************************************/
void DoSetParam(int *NumOfSamples, int *NumOfIsoLines,
	double *UMin, double *UMax, double *VMin, double *VMax,
	int *DblBuffer,
	struct IsoLine *IsoLinesU[MAX_ISO_LINES],
	struct IsoLine *IsoLinesV[MAX_ISO_LINES])
{
    static struct MenuItem SetParamMenu[] = {	     /* Set Parameters Menu. */
	YELLOW,	"Set Parameters",
	MAGENTA, "Set UMin=         ",
	MAGENTA, "Set UMax=         ",
	MAGENTA, "Set VMin=         ",
	MAGENTA, "Set VMax=         ",
	GREEN, "Set Samples=      ",  /* Set number of samples per iso line. */
	GREEN, "Set IsoLines=      ",/* Set number of iso lines per function.*/
	MAGENTA, "Double Buffer ON ",
	CYAN,	"Help",
	BLUE,	"Exit"
    };
    int	select, OldSamples, OldIsoLines;
    char s[LINE_LEN];
    double Rtemp;

    while (TRUE) {
	UpdateParamFlags(SetParamMenu, *UMin, *UMax, *VMin, *VMax,
				*NumOfSamples, *NumOfIsoLines, *DblBuffer);
	GGMenuDraw(9, SetParamMenu, TRUE);		       /* Draw Menu. */
	select = GGMenuPick();
	switch (select)	{
	    case 1:						/* Set UMin. */
		sprintf(s, "%lf", *UMin);
		GetLine(stdin, TRUE, "Enter New UMin:", s);
		if ((sscanf(s, "%lf", &Rtemp) == 1) && (Rtemp < *UMax))
		    *UMin = Rtemp;
		else GGPutErrorMsg("Wrong Format/Range");
		break;
	    case 2:						/* Set UMax. */
		sprintf(s, "%lf", *UMax);
		GetLine(stdin, TRUE, "Enter New UMax:", s);
		if ((sscanf(s, "%lf", &Rtemp) == 1) && (Rtemp > *UMin))
		    *UMax = Rtemp;
		else GGPutErrorMsg("Wrong Format/Range");
		break;
	    case 3:						/* Set VMin. */
		sprintf(s, "%lf", *VMin);
		GetLine(stdin, TRUE, "Enter New VMin:", s);
		if ((sscanf(s, "%lf", &Rtemp) == 1) && (Rtemp < *VMax))
		    *VMin = Rtemp;
		else GGPutErrorMsg("Wrong Format/Range");
		break;
	    case 4:						/* Set VMax. */
		sprintf(s, "%lf", *VMax);
		GetLine(stdin, TRUE, "Enter New VMax:", s);
		if ((sscanf(s, "%lf", &Rtemp) == 1) && (Rtemp > *VMin))
		    *VMax = Rtemp;
		else GGPutErrorMsg("Wrong Format/Range");
		break;
	    case 5:		      /* Set number of samples per function. */
		OldSamples = *NumOfSamples;
		OldIsoLines = *NumOfIsoLines;
		sprintf(s, "%d", *NumOfSamples);
		GetLine(stdin, TRUE, "New NumOfSamples:", s);
		if ((sscanf(s, "%lf", &Rtemp) == 1) && (Rtemp >= 2) &&
						(Rtemp <= MAX_SAMPLES)) {
		    *NumOfSamples = (int) Rtemp;
		    UpdateDataStruct(OldSamples, OldIsoLines, NumOfSamples,
				       NumOfIsoLines, IsoLinesU, IsoLinesV);
		}
		else GGPutErrorMsg("Wrong Format/Range");
		break;
	    case 6:		      /* Set number of samples per function. */
		OldSamples = *NumOfSamples;
		OldIsoLines = *NumOfIsoLines;
		sprintf(s, "%d", *NumOfIsoLines);
		GetLine(stdin, TRUE, "New NumOfIsoLines:", s);
		if ((sscanf(s, "%lf", &Rtemp) == 1) && (Rtemp >= 2) &&
			(Rtemp <= MAX_ISO_LINES)) {
		    *NumOfIsoLines = (int) Rtemp;
		    UpdateDataStruct(OldSamples, OldIsoLines, NumOfSamples,
				       NumOfIsoLines, IsoLinesU, IsoLinesV);
		}
		else GGPutErrorMsg("Wrong Format/Range");
		break;
	    case 7:				/* Toggles double buffering. */
		*DblBuffer = !*DblBuffer;
		break;
	    case 8:						    /* Help. */
		GGPrintHelpMenu("DrawFn3D.hlp", "SETPARAM");
		break;
	    case 9:						    /* Exit. */
		GGClearMenuArea();
		return;
	}
    }
}

/*****************************************************************************
*   Routine to update the EditMenu status according to flags :		     *
*****************************************************************************/
static void UpdateParamFlags(struct MenuItem SetParamMenu[],
	double UMin, double UMax, double VMin, double VMax,
	int NumOfSamples, int NumOfIsoLines, int DblBuffer)
{
    sprintf(SetParamMenu[1].string, "Set UMin=%7lg", UMin);
    sprintf(SetParamMenu[2].string, "Set UMax=%7lg", UMax);
    sprintf(SetParamMenu[3].string, "Set VMin=%7lg", VMin);
    sprintf(SetParamMenu[4].string, "Set VMax=%7lg", VMax);

    sprintf(SetParamMenu[5].string, "Set Samples=%4d", NumOfSamples);
    sprintf(SetParamMenu[6].string, "Set IsoLines=%4d", NumOfIsoLines);

    if (DblBuffer) sprintf(SetParamMenu[7].string, "Double Buffer ON");
    else	   sprintf(SetParamMenu[7].string, "Double Buffer OFF");
}

/*****************************************************************************
*   Routine to update the main data structure IsoLineX/Y for new config. :   *
*****************************************************************************/
void UpdateDataStruct(int OldSamples, int OldIsoLines,
	int *NumOfSamples, int *NumOfIsoLines,
	struct IsoLine *IsoLinesU[MAX_ISO_LINES],
	struct IsoLine *IsoLinesV[MAX_ISO_LINES])
{
    int	i, j;

    for	(i=0; i<OldIsoLines; i++) {		     /* Free old allocation. */
	free(IsoLinesU[i]);
	free(IsoLinesV[i]);
    }

    for	(i=0; i<*NumOfIsoLines;	i++) {	     /* Allocate new data structure. */
	IsoLinesU[i] = (IsoLine	*) malloc(3 * sizeof(float) * (*NumOfSamples));
	IsoLinesV[i] = (IsoLine	*) malloc(3 * sizeof(float) * (*NumOfSamples));
	if (IsoLinesV[i] == (IsoLine *)	NULL) {	       /* Not enough memory! */
	    GGPutErrorMsg("Not enough memory.");
	    for	(j=0; j<=i; j++) {		 /* Free the new allocation. */
		free(IsoLinesU[j]);
		free(IsoLinesV[j]);
	    }
	    *NumOfIsoLines = OldIsoLines;		      /* Restore it! */
	    *NumOfSamples = OldSamples;
	    for	(j=0; j<*NumOfIsoLines;	j++) {	      /* Allocate as it was. */
	       IsoLinesU[j] = (IsoLine *)
				   malloc(3 * sizeof(float) * (*NumOfSamples));
	       IsoLinesV[j] = (IsoLine *)
				   malloc(3 * sizeof(float) * (*NumOfSamples));
	    }
	    return;				/* Nothing to do any more... */
	}
    }
}
