/******************************************************************************
* Iteraction library - Messages handler.				      *
*									      *
*					Written by Gershon Elber,  Nov. 1990  *
*******************************************************************************
* History:								      *
*  11 Nov 90 - Version 1.0 by Gershon Elber.				      *
******************************************************************************/

#include <stdio.h>
#include <string.h>
#include <stdio.h>
#include "intr_loc.h"
#include "intr_gr.h"

#define MESSAGE_BORDER_WIDTH 8
#define MESSAGE_BORDER_WIDTH4 (MESSAGE_BORDER_WIDTH / 4)
#define MESSAGE_BORDER_WIDTH2 (MESSAGE_BORDER_WIDTH / 2)


static IntrBType HasActiveMessage = FALSE;

/******************************************************************************
* Routine to put a string message on the top left screen corner.	      *
******************************************************************************/
void IntrDrawMessage(char *Str, IntrColorType ForeColor,
						    IntrColorType BackColor)
{
    int i, Xmax, Ymax, GRLastColor;

    if (HasActiveMessage)
	IntrFatalError("Two draw messages with no erase in between.");

    /* Save current graphic state. */
    GRPushViewPort();
    _GRSetViewPort(0, 0, GRScreenMaxX, GRScreenMaxY);

    GRPushTextSetting();
    GRSetTextJustify(GR_TEXT_HJUSTIFY_LEFT, GR_TEXT_VJUSTIFY_TOP);
    GRSetSTextStyle(GR_FONT_DEFAULT, GR_HORIZ_DIR, GR_TEXT_MAG_1);

    GRLastColor = GRGetColor();

    Xmax = GRGetTextWidth(Str) + 5;
    Ymax = GRGetTextHeight(Str) + 3;
    if (_IntrSaveBelow)
	_IntrSaveWindow(0, 0,
			Xmax + MESSAGE_BORDER_WIDTH, Ymax + MESSAGE_BORDER_WIDTH);

    IntrAllocColor(BackColor, INTR_INTENSITY_HIGH);
    GRSBar(0, 0, Xmax, Ymax);

    GRSTextShadow(0, 0, IntrAllocColor(ForeColor, INTR_INTENSITY_VHIGH), Str);

    for (i = 0; i < MESSAGE_BORDER_WIDTH4; i++) {
    	IntrAllocColor(ForeColor, INTR_INTENSITY_HIGH);
    	GRSMoveTo(0, Ymax + i);
    	GRSLineTo(Xmax + i, Ymax + i);
    	GRSLineTo(Xmax + i, 0);
    }
    IntrAllocColor(ForeColor, INTR_INTENSITY_VHIGH);
    for (; i < MESSAGE_BORDER_WIDTH2 + MESSAGE_BORDER_WIDTH4; i++) {
    	GRSMoveTo(0, Ymax + i);
    	GRSLineTo(Xmax + i, Ymax + i);
    	GRSLineTo(Xmax + i, 0);
    }
    for (; i < MESSAGE_BORDER_WIDTH; i++) {
    	IntrAllocColor(ForeColor, INTR_INTENSITY_VLOW);
    	GRSMoveTo(0, Ymax + i);
    	GRSLineTo(Xmax + i, Ymax + i);
    	GRSLineTo(Xmax + i, 0);
    }

    /* Restore current graphic state. */
    GRSetColor(GRLastColor);
    GRPopTextSetting();
    GRPopViewPort();

    HasActiveMessage = TRUE;
}

/******************************************************************************
* Routine to erase the string message from the top left screen corner.	      *
******************************************************************************/
void IntrEraseMessage(void)
{
    if (!HasActiveMessage)
	IntrFatalError("No message to erase.");

    /* Save current graphic state. */
    GRPushViewPort();
    _GRSetViewPort(0, 0, GRScreenMaxX, GRScreenMaxY);

    if (_IntrSaveBelow) _IntrRestoreWindow();

    /* Restore current graphic state. */
    GRPopViewPort();

    HasActiveMessage = FALSE;
}
