/* [DOC] File ****************************************************
** MODULE INFORMATION*
**********************
**      FILE    NAME:       PWGHBAR.C
**      SYSTEM  NAME:       POWER
**      VERSION NUMBER      3.00
**
** Descr:       Horizontal border bar function for
**              Programmer Oriented Window Environment Routines.
**              (NoC) July 1989 - Ling Thio Software Productions.
******************************************************************
** ADMINISTRATIVE INFORMATION*
******************************
**      ORIGINAL AUTHOR:    Ling Thio
**      CREATION DATE:      89/07/10
**      CHANGES:            none
*****************************************************************/

#include "pwinc.h"                          /* Main include file */

/* [DOC] Function *********************************************
** Name:        pw_hbar                                   [API]
** SYNOPSIS:    void pw_hbar(win, row);
**              PWWIN *win          Pointer to window handle
**              int   row           Row to place bar
** Descr:       Draws a horizontal bar in a window.
**              The 'pw_hbar' function displays a horizontal
**                double line, at column 'col', in the border
**                attribute of window 'win'.
**              It provides 'T-fork' characters at the top
**                and bottom border lines.
** RETURNS:     void
** SEE ALSO:    pw_vbar
**************************************************************/
void pw_hbar(PWWIN *win, int row)
{
    int col = -1;
    int i = win->ncol;
    PWCELL cell = (pwv_attrib(win->wtype, PWT_ACTIVEBORDER) << 8);

    if ((win->status & PWM_NOBORDER) == 0)
        pw_putcat(win, row, col++, _pwcf_border[PWCF_LT]);
    for (; i; i--)
    {
        if ((pw_getcellat(win, row, col) & 0xff) == _pwcf_border[PWCF_V])
             pw_putcellat(win, row, col, cell + _pwcf_border[PWCF_X]);
        else
             pw_putcellat(win, row, col, cell + _pwcf_border[PWCF_H]);
        col++;
    }
    if ((win->status & PWM_NOBORDER) == 0)
        pw_putcat(win, row, col, _pwcf_border[PWCF_RT]);
}

