/************************************************************************
** MODULE INFORMATION*
**********************
**     FILE     NAME:       SOCKLIB.H
**     SYSTEM   NAME:       IP
**     ORIGINAL AUTHOR(S):  Wim van Campen
**     VERSION  NUMBER:     1.0
**     CREATION DATE:       1990/6/26
**
** DESCRIPTION: Internal header file for the Socket Library.
**              
*************************************************************************
** CHANGES INFORMATION **
*************************
** REVISION:    $Revision:   1.0  $
** WORKFILE:    $Workfile:   SOCKLIB.H  $
** LOGINFO:     $Log:   I:/ETSTJAN/CPROG/BEHOLDER/UDPIP/INCLUDE/VCS/SOCKLIB.H_V  $
**              
**                 Rev 1.0   01 Feb 1991 11:41:12   etstjan
**              No explicit note
*************************************************************************/

#ifdef SOCKET
#  undef SOCKET
#endif
#define SOCKET           struct _socket
 
#define DEFRECMAX        10     /* default maximum receive queue length    */

#define IPPORT_RESERVED  1024   /* boundary for reserved ports             */
#define IPPORT_USERRES   5000   /* above this, reserved for non priv users */

/* defines for protocol flags */
#define PR_ATOMIC        0x1    /* send each packet seperately             */
#define PR_CONNREQUIRED  0x2    /* connection necessary before sending     */

/* defines for socket state */  
#define SS_ISCONNECTED   0x1    /* socket is connected to peer             */
#define SS_LOCALBOUND    0x2    /* local socket address bound              */
#define SS_LOCPORT       0x4    /* local socket port bound                 */
#define SS_REMOTEBOUND   0x8    /* remote socket address bound             */
#define SS_REMPORT       0x10   /* remote port bound                       */


#define LOCALBOUND(s)    ((s->So_State & (SS_LOCPORT | SS_LOCALBOUND)) == \
                         (SS_LOCPORT | SS_LOCALBOUND))
       
#define PORTBOUND(s)     ((s->So_State & (SS_LOCPORT | SS_REMPORT)) != 0)

#define REMOTEBOUND(s)   ((s->So_State & (SS_REMPORT | SS_REMOTEBOUND)) == \
                         (SS_REMPORT | SS_REMOTEBOUND))

#define ADDBOUND(s)      ((s->So_State & (SS_LOCALBOUND | SS_REMOTEBOUND)) != 0)

#define LOCPORTBOUND(s)  ((s->So_State & SS_LOCPORT) != 0)

#define REMPORTBOUND(s)  ((s->So_State & SS_REMPORT) != 0)

#define LOCADDBOUND(s)   ((s->So_State & SS_LOCALBOUND) != 0)

#define REMADDBOUND(s)   ((s->So_State & SS_REMOTEBOUND) != 0)


/* user request codes to protocol */
typedef enum {
          PRU_ATTACH,           /* attach protocol to socket               */
          PRU_BIND,             /* bind name to socket                     */
          PRU_DEBIND,           /* unbind name from socket                 */  
          PRU_CONNECT,          /* establish connection to peer            */
          PRU_SHUTDOWN,         /* shutdown socket (disconnnect & debind)  */
          PRU_DETACH,           /* detach protocol from socket             */
          PRU_DISCONNECT,       /* disconnect from peer                    */
          PRU_SENDTO            /* send these data                         */
          } USERREQ;

          
typedef struct _so_address {
          ADDRESS_T         IPAddress;    /* IP address of socket          */
          USHORT            Port;         /* Port number of socket         */
          } SO_ADDRESS;

typedef struct _packlist {
          CIPHEAD           *Source;      /* packet's source               */
          DATALINK          *Packet;      /* packet received               */
          struct _packlist  *NextPack;    /* linked list                   */
          } SO_PACKLIST;

typedef struct _socket {
          struct _prstruct  *So_Prot;     /* protocol for this socket      */
          struct _socket    *So_Next;     /* next socket for protocol      */
          struct _socket    *So_Prev;     /* previous socket               */
          USHORT            So_State;     /* state of socket               */
          int               So_Error;     /* error flag for this socket    */  
          USHORT            So_Type;      /* type of the socket            */
          SO_ADDRESS        So_LocAdd;    /* socket's local address        */
          SO_ADDRESS        So_RemAdd;    /* socket's remote address       */
          DATALINK          *So_Options;  /* IP level options              */
          BYTE              So_RMaxLen;   /* max length receive queue      */
          BYTE              So_RCurLen;   /* current length receive queue  */
          SO_PACKLIST       *RecQueue;    /* receive queue                 */
          SO_PACKLIST       *RecQEnd;     /* end of receive queue          */   
          };

typedef struct _prstruct {
          char              PrName[16];   /* protocol name                 */   
          BYTE              PrType;       /* kind of protocol              */
          USHORT            PrFlags;      /* protocol flags                */
          int (*UserReq)                  /* protocol user request         */
              (USERREQ, SOCKET *, DATALINK *, SO_ADDRESS *, SO_ADDRESS *);
          SOCKET            *PrSocket;    /* sockets for this protocol     */
          SOCKET            *LastSock;    /* last socket for this protocol */
          struct _prstruct  *PrNext;      /* next protocol switch          */
          int (*IPRec)                    /* receive function from IP      */
	       (PRREQ, CIPHEAD *, DATALINK *, int, int);
          } PROTSTRUCT;


/* global variables */
extern    PROTSTRUCT        *Protocs;     /* linked list of protocols */
extern    PROTSTRUCT        *RawProt;     /* 'protocol' for raw socket  */
extern    PROTSTRUCT        *UDPProt;     /* UDP protocol switch */


/* prototypes */
int     InitSockets(void);
SOCKET  *CreateSocket(int Type, int Domain, int Protocol);
int     _RelSocket(SOCKET *ThisSocket);
SOCKET  *So_Locate(USHORT DPort, ADDRESS_T DAddr,
                   USHORT SPort, ADDRESS_T SAddr,
                   PROTSTRUCT *ThisProt, int *ColPoints);
void    MessToSock(SOCKET *DestSocket, CIPHEAD *ThisHeader,
                   DATALINK *ThisPacket);
void    FreeSoPack(SO_PACKLIST *ThisSoPack);
int     SetIPOptions(SOCKET *ThisSocket, char *OptVal, int OptLen);



