/*

   TPTX.H

   (c) 1996 by Oliver Kraus

*/

#ifndef _TPTX_H
#define _TPTX_H

#include <stdio.h>
#include <time.h>
#include "tp.h"

#define TPTX_B_LEN  TP_BLK_LEN
#define TPTX_B_CNT  TP_BLK_CNT
#define TPTX_TX_ADD 5

struct _tptx_struct
{
   int flags;              /* TP_FLAGs                                */

   unsigned short socket;  /* ipx socket number                       */
   int is_adr_known;       /* is destination address known            */
   ipx_adr_struct adr;     /* destination address                     */

   int is_ended;           /* 1 if file ok or error                   */

   char *f_name;           /* pointer file name (allocated memory)    */
   char *f_logname;        /* pointer remote name (allocated memory)  */
   char *f_logsname;       /* pointer remote sname (allocated memory) */
   FILE *fp;               /* file pointer                            */
   long f_len;             /* file length                             */
   long f_len_sum;         /* summed length of all files              */
   long f_pos;             /* current file position                   */
   unsigned long f_crc;    /* crc for the original pool               */
   unsigned long f_d_crc;  /* crc for the second pool                 */
   clock_t f_start;        /* when did we start reading the file?     */
   clock_t f_time_sum;     /* total time, summed up                   */
   size_t f_read_len;      /* value returned by fread                 */
   int f_is_skip;          /* skip file flag                          */
   unsigned f_attr;        /* file attribute                          */
   unsigned short f_time;  /* file time                               */
   unsigned short f_date;  /* file date                               */

   /* Conditions:   1.   b_cnt <= b_len/2                             */
   /*               2.1. 16 Bit Systems: b_cnt*b_len < 2^16           */
   /*               2.2. 32 Bit Systems: b_cnt*b_len < 2^32           */

   size_t b_len;           /* block length                            */
   int b_cnt;              /* max no of blks in pool (==TPTX_B_CNT)   */
   int b_curr_cnt;         /* current blks in use (b_curr_cnt<=b_cnt) */
   size_t b_pool_size;     /* size of block memory pool (b_cnt*b_len) */
   char *b_pool_ptr;       /* block memory pool                       */
   char *b_pool_dptr;      /* second pool                             */
   int b_is_dptr_ok;
   short *b_list_ptr;      /* array with block numbers (b_curr_cnt)   */
   int b_list_cnt;         /* counter for b_list (0<=..<b_curr_cnt)   */

   int  tx_cnt;            /* tx_cnt = b_cnt+TPTX_TX_ADD              */
   char **tx_data;         /* tx_cnt blocks with b_len bytes          */
   ipx_ecb_struct **tx_ecb;

   char *rx_data;          /* b_len bytes receive buffer              */
   ipx_ecb_struct *rx_ecb; /* receive ecb                             */

   clock_t small_delay;    /* values for repeated message generation  */
   clock_t large_delay;

   clock_t clock_dest;     /* destination time                        */

   void (*state_fn)(struct _tptx_struct *tptx); /* state function ptr */
   void (*rep_state_fn)(struct _tptx_struct *tptx);

   tp_pdata_struct pdata;
   int (*aux)( int msg, void *data );
   int is_aux;
};
typedef struct _tptx_struct tptx_struct;
typedef struct _tptx_struct *tptx_type;


#define tptx_SetState(tptx, _state) ((tptx)->state_fn = (_state))
#define tptx_SetRepeatedState(tptx, _state) ((tptx)->rep_state_fn = (_state))
#define tptx_GetRepeatedState(tptx) ((tptx)->rep_state_fn)


/*---- public member functions --------------------------------------------*/

tptx_type tptx_Open(unsigned short socket, int is_lfn);
void tptx_Close(tptx_type tptx);
int tptx_Send(tptx_type tptx, char *phy_name, char *log_name, char *log_sname);
int tptx_Dispatch(tptx_type tptx);
void tptx_SetAux(tptx_type tptx, int (*aux)( int msg, void *data ));
void tptx_DoAux(tptx_type tptx, int msg, void *data);
#define tptx_SetFlag(tptx, flag) ((tptx)->flags |= (flag))
#define tptx_ClrFlag(tptx, flag) ((tptx)->flags &= ~(flag))
void tptx_TerminateReceiver(tptx_type tptx);

#endif
