/*

SMBPD

Line printer daemon using SMB printer protocol on top of WATTCP for up
to 3 parallel printer ports.

This daemon is written as a state machine because it has to support
several connections on a single threaded system, DOS.

When started up, it checks to see how many printers are known to the
BIOS. These printers are served as LPT[123].

Examples of options:

-23	disable printers 2 and 3
-n2	two printers, no matter what BIOS claims
-b12	on 1 and 2 bypass BIOS and send directly to port (parallel ports only)
-t	don't indicate available printers with tones
-i	reinitialise printer via hardware line on job abort
-s	disable subnet match (server and client must be on same subnet)
-alist	comma separated list of up to 20 domain names allowed connection
-dlist	comma separated list of up to 20 domain names denied connection
	last two are mutually exclusive and independent of subnet check
-lhost	log diagnostics to host of that domain name
-c	print to console for debugging
-z2048	set negotiated buffer transfer size
-p[012]	set protocol dialect (Core/Lanman2/Lanman2)
-v	more verbose messages, repeat to increase level

Jobs can be aborted by C-F1 through C-F3 for that printer.

This program was compiled under Borland C++ 3.1 in C mode for the compact
model. You will require the WATTCP libraries. A copy is included in the
distribution. For the sources of WATTCP, ask archie where the archives
are.

Please send bug fixes, ports and enhancements to the author for
incorporation in newer versions.

*/

#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<time.h>

#include	"smbhdr.h"
#include	"smbpd.h"
#include	"cmd.h"
#include	"nameserv.h"
#include	"netio.h"
#include	"lpt.h"
#include	"util.h"

int		verbose = 0;
unsigned short	maxbuffer = MAXBUFFER;

void options(int argc, char **argv)
{
	int		i;
	char		*s;
/*	extern int	optind;*/
	extern char	*optarg;
	extern int	getopt(int, char *const*, const char *);

	for (i = 0; i < MAXLPT; ++i)
		lpt[i].hwaddr = 0;
	while ((i = getopt(argc, argv, "123a:b:cd:gij:kl:mn:p:stvz:")) > 0)
	{
		switch (i)
		{
		case '1': case '2': case '3':
			lpt[i - '1'].avail  = DISABLED;
			break;
		case 'a':
			if (ndeny <= 0)
				make_list("allowed", optarg, allow, &nallow, MAXALLOW);
			break;
		case 'b':
			for (s = optarg; '1' <= *s && *s <= '3'; ++s)
				lpt[*s - '1'].hwaddr = 1;
			break;
		case 'c':
			toconsole = 1;
			break;
		case 'd':
			if (nallow <= 0)
				make_list("denied", optarg, deny, &ndeny, MAXDENY);
			break;
		case 'i':
			reinit = 1;
			break;
		case 'l':
			loghost = optarg;
			break;
		case 'm':
			measureonly = 1;
			break;
		case 'n':
			if ((nlpt = atoi(optarg)) > MAXLPT || nlpt < 0)
				nlpt = 0;
			break;
		case 'p':
			if ((ndialect = atoi(optarg)) < 0 || ndialect > 3)
				ndialect = 0;
			break;
		case 's':
			check_subnet = 0;
			break;
		case 't':
			notone = 1;
			break;
		case 'v':
			verbose++;
			break;
		case 'z':
			if ((maxbuffer = atoi(optarg)) < 1024)
				maxbuffer = 1024;
			if (maxbuffer > DBUFSIZE)
				maxbuffer = DBUFSIZE;
			maxbuffer += HDR_OVERHEAD;
			break;
		}
	}
}

int main(int argc, char **argv)
{
	int		i;

	(void)printf(PROGRAM " " VERSION " " AUTHOR "\n");
	(void)printf(PROGRAM " comes with ABSOLUTELY NO WARRANTY; for details read the file Artistic\n");
	(void)printf("This is free software, and you are welcome to redistribute it\n");
	(void)printf(" under certain conditions; see the file COPYING for details.\n");
	(void)printf("C-F1 through C-F3 to abort printer jobs\n");
	tzset();
	options(argc, argv);
	init_net();
	init_printers();
	if (nlpt == 0)
	{
		(void)printf("%s: No printers connected\n", ptime());
		return (1);
	}
	init_log();
	init_ns();
	for (;;)
	{
		for (i = 0; i < nconn; ++i)
			poll_conn(i);
		check_ns();
		if (kbhit())
			check_key();
	}
	/*NOTREACHED*/
	return (0);
}
