/*
 * MultiMail offline mail reader
 * Blue Wave

 Copyright (c) 1996 Toth Istvan <stoty@vma.bme.hu>
 Copyright (c) 1998 William McBrine <wmcbrine@clark.net>

 Distributed under the GNU General Public License.
 For details, see the file COPYING in the parent directory. */

#ifndef BW_H
#define BW_H

#include "mmail.h"

#ifndef BIG_ENDIAN
#define BIG_ENDIAN
#endif

#include "bluewave.h"

class bluewave : public specific_driver
{
	mmail *mm;
	FILE *infFile, *ftiFile, *datFile;
	INF_AREA_INFO *areas;
	MIX_REC *mixRecord;
	struct bodytype **body;

	char packetBaseName[9], *bodyString;
	int *mixID;
	int maxConf, ID, currentArea, currentLetter, noOfInfRecs, noOfMixRecs;
	unsigned infoHeaderLen, infoAreainfoLen, mixStructLen, ftiStructLen;
	
	FILE *openFile(const char *);
	void findInfBaseName();
	void initInf();
	void initMixID();
	void readMixRec();
	void init();
	void cleanup();
	int numcmp(const char *, const char *);
 public:
	bluewave(mmail *);
	~bluewave();
	int getNoOfAreas();
	void resetAll();
	area_header *getNextArea();
	void selectArea(int);
	int getNoOfLetters();
	void resetLetters();
	letter_header *getNextLetter();
	char *getBody(int, int);
	int isCollection();
	int isReplyArea();
};

class bwreply : public reply_driver
{
	struct upl_list {
		UPL_REC uplRec;
		long msglen;
		char fname[50];
		upl_list *nextRecord;
	} *uplListHead, *uplListCurrent;
	
	mmail *mm;
	UPL_HEADER *uplHeader;
	file_list *upWorkList;

	char replyPacketName[13], *replyText;
	int currentLetter, noOfLetters, replyExists;
	
	void init();
	void cleanup();
	void uncompress();
	int getNew1(FILE *, upl_list *, int);
	void readUpl();
	void addNew1(FILE *, upl_list *);
	void newFileName(const char *);
	char *freeFileName();
	int todos(const char *, const char *);
	int fromdos(const char *, const char *);
 public:
	bwreply(mmail *);
	~bwreply();
	int getNoOfAreas();
	void resetAll();
	area_header *getNextArea();
	void selectArea(int);
	int getNoOfLetters();
	void resetLetters();
	letter_header *getNextLetter();
	char *getBody(int, int);
	void enterLetter(letter_header *, char *, int);
	void killLetter(int);
	area_header *refreshArea();
	void makeReply();
	int isCollection();
	int isReplyArea();
};

#endif
