C   TESTFIT.FOR sample Fortran dynamic-link library for Nonlinear Fitter

	INCLUDE 'FITTYPES.FI'

	INTEGER*2 FUNCTION InitData 
     *		  (ParamFile,
     *		   DataPoints,OutVectors,AddOutValues,
     *             OutVectorsArray,
     *             OutVectorsNames,
     *             AddNames,
     *             ErrMsg)
     	  CHARACTER*80 ParamFile
	  INTEGER*2 DataPoints,OutVectors,AddOutValues
	  INTEGER*4 OutVectorsArray(10)
	  CHARACTER*21 OutVectorsNames(10)
	  CHARACTER*10 AddNames(8)
	  CHARACTER*80 ErrMsg

	  COMMON X, Y, Z, R
	  REAL*8 X(1024),Y(1024),Z(1024),R(1024)
          LOGICAL DataInitialized
          INTEGER*2 k

          SAVE DataInitialized
          DATA DataInitialized /.FALSE./

	  InitData=0
          if (DataInitialized) return

	  DataPoints=0
	  OutVectors=4
	  AddOutValues=1

          AddNames(1)='a+b+c+d'
	  OutVectorsNames(1)='X'
	  OutVectorsNames(2)='Y'
	  OutVectorsNames(3)='Computed'
	  OutVectorsNames(4)='Residual'

	  OutVectorsArray(1)=LOCFAR(X)
	  OutVectorsArray(2)=LOCFAR(Y)
	  OutVectorsArray(3)=LOCFAR(Z)
	  OutVectorsArray(4)=LOCFAR(R)

          open(10,file=ParamFile,status='old',err=20)
	  do while (.TRUE.)
	     k=k+1
             read(10,'(2D24.14)',err=30,end=10) X(k), Y(k)
	  end do
10        close(10)
	  DataPoints=k-1

          DataInitialized=.TRUE.
	  print *,X(1),Y(1)
	  return
20        ErrMsg='Cannot open file'
          InitData=-1
          return
30	  ErrMsg='Error reading file'
	  InitData=-2
	END

	INTEGER*2 FUNCTION Approx 
     *		  (Params,
     *             Residuals,
     *             AddValues,
     *             DataPoints[VALUE],
     *		   TypeOfCall[VALUE],
     *             ErrMsg)
	  REAL*8 Params(5)
	  REAL*8 Residuals(1024)
	  REAL*8 AddValues(8)
	  INTEGER*2 DataPoints
          INTEGER*2 TypeOfCall
	  CHARACTER*81 ErrMsg

	  COMMON X,Y,Z,R
	  REAL*8 X(1024),Y(1024),Z(1024),R(1024)
	  INTEGER*2 k

	  Approx=0
          if (TypeOfCall.EQ.2) then
	    do k=1,DataPoints
	      R(k)=Residuals(k)
	    end do
	    return
	  endif	

	  do k=1,DataPoints
            Z(k)=Params(1)*sin(Params(2)*X(k))+
     *		 Params(3)*cos(Params(4)*X(k))
            Residuals(k)=Z(k)-Y(k)
	  end do

	  if (TypeOfCall.EQ.3) return

      	  AddValues(1)=Params(1)+Params(2)+Params(3)+Params(4)
	END

