.SEQ
Name    A20OFF
Page    51,132
Title   A20OFF.ASM

Comment |
Author  BF Gavin, Online Reference BBS
Format  Standard .COM file format.
Intent  Disable CS8221 NEAT ChipSet RB12 Bit 1, A20 address line control.
        TPCXINST will fail if it finds the A20 line enabled.

Usage   No command line parms required.
Origin  20NOV90  v1.00

Remark  Reg 6F (RB12, A20 address line) and Reg 60 (RA0, Processor Reset)
        are a feature of the NEAT ChipSet.  They provide a fast means of
        switching the 80286 in and out of protected mode.

        OS/2 makes frequent operating system calls that must be executed
        in Real mode.  To perform these calls, the CPU typically must issue
        two commands to the 8042 (or equivalent) keyboard controller
        to enter protected mode and enable the A20 address line.

        Reg 60 provides a processor reset, and Reg 6F controls the A20
        address line control.  Because these registers are controlled by
        direct I/O port writes, instead of software interrupts, they
        execute very quickly.

        This utility is intended to execute from the AUTOEXEC.BAT file
        when the system is started.

               |

                Assume  CS:Code_Segment
                Assume  SS:Code_Segment



Code_Segment    Segment Para    Public  'CODE'
                Org     100h

Main_Line       Proc    Near
; Get RB12 Misc Register contents
        Mov     DX,22h                          ; RB12 index register
        Mov     AL,6Fh                          ; Set it to port 6Fh
        Out     DX,AL                           ; Enable the index register
        In      AL,23h                          ; Read RB12 register

; Set RB12 Bit(1) to disable A20 address line
        Mov     AH,AL                           ; Save RB12 contents in AH
        Mov     DX,22h                          ; RB12 index register
        Mov     AL,6Fh                          ; Set RB12 port 6Fh
        Out     DX,AL                           ; Enable write to RB12
        Mov     AL,AH                           ; Original RB12 contents to AL
        Or      AL,02h                          ; Bit(1)=0 sets A20 = zero
; ***   AND     AL,0FDh                         ; Bit(1)=1 enables A20 line
        Out     23h,AL                          ; Write RB12 data register

  Exit:
        Mov     AX,4C00h                        ; Return code = 0
        Int     21h                             ; Call DOS
Main_Line       Endp

Code_Segment    Ends                            ; End of code Segment




Comment |
Stack_Segment   Segment Para    Stack   'Stack'
        Dw      128 dup (?)                     ; 128 words of stack space
Stack_Segment   Ends
        |




End             Main_Line                       ; Program entry point

