
comment *


  PCMOUSE  (c) 1992,1995 by  Jrgen G. Weber
                             Wiesentalstrae 1
                             D-74523 Schwbisch Hall
                             Germany - European Union

  ALL RIGHTS RESERVED

  CUT and PASTE in Dos Text Mode

  Function: Select text while left button is pressed. As soon as
            button is released the selected text is copied from
            screen into internal buffer. Buffer is cleared not
            until the the next selection, but that is also if a
            screen area is only clicked at and nothing selected.

  MAKE:     tasm pcmouse
            tlink pcmouse


VERSIONS: 1.0     First public release
          1.1     if you specify option /T PCMOUSE's buffer is stuffed
                  into the keyboard buffer at every timer tick, too.
          1.2     Un-install Option /U
                  8088 Version
          1.3     Support of extended text modes
                  Option /Mnnn to use (decimally given marker byte nnn)
          1.4     Optio /Q for quiet start up
                  Martin Buck found and eliminated some screen selection
                  bugs
          1.5     Option /S so that int 21h is not patched
                  But then if a program does not restore the previous
                  mouse handler, pcmouse first must be reactivated with
                  pcmouse /R
                  pcmouse does a mouse hardware reset after de-install now
          1.5a    Grant B. Gustafson found out that pspadr was overwritten
                  by buffer, so uninstall wouldnt work correctly

*

XT equ 0      	     ; set this to TRUE if you want PCMOUSE to run 
                     ; on an PC or XT

TRUE equ -1
FALSE equ not TRUE
DE_INSTALL equ 2
REACTIVATE equ 3
TICK_TOO equ 4

NOT_INSTALLED equ 40h
ALL_OK equ 41h
WRO_VEC equ 42h

PVERSION equ '1.5a'
TIMER_TOO equ TRUE   ; decides if at every timer tick
                     ; the keyboard buffer is fed
                     ; but only if also /T

if not XT
 .286  ; the times, they're a-changing ...  memento mori 808[6|8]
endif

locals                       ; makes the local @@Label possible

MOUSE_FN equ 80h             ; new function of int 16h, that tells, if
                             ; the program is already installed
INST_HND equ 67h             ; tell int 16 to reinstall mouse handler

IDENTCODE equ 41751          ; anything, e.g. my phone number

; the bufleng is enough for half of a screen, but often is enough
; for more as blanks are compressed

RD_BUFLEN EQU 1024

; Masks for mouse events

M_MOVED EQU 1
M_LT_PRESSED EQU 10B
M_LT_RELEASD EQU 100B
M_RT_PRESSED EQU 1000B
M_RT_RELEASD EQU 10000B


; mask to XOR the selected screen area with to display it

DEFAULT_SCR_MARK_MASK EQU 01010000b

; maximal time between the clicks of a mouse double click
; in timer ticks

DCLCK_SPEED equ 9      ; that makes about a half second

; the following macros make the listing better readable

show_mouse macro
    push ax
    mov ax,1 ; show mouse
    int 33h
    pop ax
endm

hide_mouse macro
    push ax
    mov ax,2 ; hide mouse
    int 33h
    pop ax
endm

incz macro op  ; if Z op++
local not_zero
jnz short not_zero
inc op
not_zero:
endm

movz macro reg,val1,val2 ; reg = ZF ? val1 : val2
local is_zero
ifnb <val1>
  mov reg,val1
endif
jz short is_zero
ifnb <val2>
  mov reg,val2
endif
is_zero:
endm

pushr macro regs   ;; eg: pushr <bx,ax,cx>
local reg
   irp reg,<regs>
     push reg
   endm
endm

popr  macro regs   ;; eg: popr  <cx,ax,bx>
local reg
   irp reg,<regs>
     pop  reg
   endm
endm

incr macro reg,count  ;; inc(reg,count)
 rept count
  inc reg
 endm
endm

decr macro reg,count  ;; dec(reg,count)
 rept count
  dec reg
 endm
endm


if XT
 xpusha macro
        pushr <AX,BX,CX,DX,BP,SI,DI>
 endm
 xpopa macro
        popr <DI,SI,BP,DX,CX,BX,AX>
 endm
else
 xpusha macro
        pusha
 endm
 xpopa macro
        popa
 endm
endif

if XT
biosdata segment at 40h
org 1ah
headptr dw (?)  ; pointer to next key entry to read
tailptr dw (?)  ; pointer to last read key entry
org 80h
bufstrt dw (?)  ; pointer to start keyboard buffer
bufend  dw (?)  ; pointer to end keyboard buffer
biosdata ends
endif ; XT


code segment
assume cs:code

res_beg equ $        ; keep resident starting from here

pspadr dw (?)                ; pointer to pcmouse seg in memory
safe_flag db FALSE           ; if safe int 21h is not patched
tick_flg db FALSE            ; stuff at timer ticks too ?
left_press_flg db FALSE      ; left button is pressed
select_flag db FALSE         ; there is an area marked on screen
mouse_on_flg db FALSE        ; mouse is on
ctrl_rt_clck_flg db FALSE    ; at the last right click ctrl was pressed, too
in10_flg dw 0                ; is incremented at each call of int 10h
old_mask dw 0                ; is used in Patch of Exec
old_rout dw 0,0              ; also
pressed_scroffs dw (?)       ; screen position at mouse click
old_scroffs dw (?)           ; screen position befor last mouse movement
scr_mark_mask db DEFAULT_SCR_MARK_MASK
xor_ptr dw (?)               ; pointer to scren area to mark
charsave db 0                ; if keyboard buffer full, save char here
colsPline dw (?)             ; characters per line on screen
videoseg  dw (?)             ; segment of screen memory
videooffs dw (?)             ; offset of actual video page
lclcktime dw 0,0             ; time since last left click
buffer_valid db FALSE        ; becomes true after right click
blnks_left db (?)            ; rest of actual blanc coding
buf_poi dw offset rd_buffer  ; pointer to char buffer (read from there)

buf_end_poi dw offset rd_buffer

; calculate video offset from x and y
; In:  x=cx, y=dx ; x=0.., y=0..
; Out: ax := offs = y*80+x
xy2offs proc
      pushr <dx,cx>
if XT
   rept 3
     shr cx,1
   endm
else
      shr cx,3
endif
      cmp colsPline,40
      jnz short @@no_40
      shr cx,1         ; divide by 16 if there are 40 columns per line
    @@no_40:
if XT
   rept 3
     shr dx,1
   endm
else
      shr dx,3
endif
      mov ax,dx
      mul colsPline
      add ax,cx        ; +=x
      add ax,ax        ; 2 bytes per character
      add ax,videooffs
      inc ax           ; -> attribute
      popr <cx,dx>
      ret
xy2offs endp


; show or hide mark on screen

xor_scr proc
      pushr <cx,bx,dx>
      push ds
      hide_mouse       ; in order not to destroy the mouse cursor
      mov bx,xor_ptr
      mov cl,scr_mark_mask
      mov dx,videoseg
      mov ds,dx
      sar ax,1         ; /=2 to get number of characters
      or  ax,ax
      jns short @@pos_loop

; mouse was moved to the left
@@neg_loop:
      xor byte ptr [ds:bx],cl   ; scr_mark_mask
      sub bx,2
      inc ax      ; inc, as counter is negativ
      jnz short @@neg_loop
      jmp short @@exit
; mouse was moved to the right
@@pos_loop:
      add bx,2
      xor byte ptr [ds:bx],cl
      dec ax
      jnz short @@pos_loop
@@exit:
      show_mouse
      pop ds
      mov xor_ptr,bx
      popr <dx,bx,cx>
    ret
xor_scr endp

; select single word chosen by double click

select_word proc
      push videoseg
      pop ds
      mov bx,pressed_scroffs   ; -> attribute
      dec bx
      call @@tst_let
      jc @@exit                ; clicked to void
  @@go_left:                   ; search for word begin
      call @@tst_let
      decr bx,2
      jnc  @@go_left
      add bx,5                 ; points to attribute again
      mov  pressed_scroffs,bx
      decr bx,2
      mov  xor_ptr,bx
      dec  bx
  @@go_right:                  ; search for word end
      incr bx,2
      call @@tst_let
      jnc @@go_right
      mov ax,bx
      inc bx
      mov old_scroffs,bx
      sbb ax,xor_ptr           ; cy is 1 from tst_let
      call xor_scr
  @@exit:
      ret
  @@tst_let:                   ; if [ds:bx] in {0..9,A..Z,a..z,80h..a5h,_}
      mov al,[ds:bx]           ;    cy:=0
      cmp al,'0'               ; else
      jb @@nolet               ;    cy:=1
      cmp al,'9'
      jbe @@let      ; 0..9
      cmp al,'A'
      jb @@nolet
      cmp al,'Z'
      jbe @@let      ; A..Z
      cmp al,'_'
      jz  @@let
      cmp al,'a'
      jb  @@nolet
      cmp al,'z'
      jbe @@let      ; a..z
      cmp al,80h
      jb  @@nolet    ; european special characters
      cmp al,0a5h
      jbe @@let
      cmp al,0e0h
      jb  @@nolet    ; greek letters
      cmp al,0ebh
      ja  @@nolet
  @@let:
      clc
      ret
  @@nolet:
      stc
      ret
select_word endp
; select screen area that was passed
; during mouse movement

scr_select proc
; In: cx,dx = mouse x,y

      call xy2offs
      push ax
      sub ax,old_scroffs     ; ax:= number passed positions * 2
      pop old_scroffs        ; new pos to old pos
      jz short @@exit        ; was moved to little to change text pos
      call xor_scr
      mov select_flag,TRUE
    @@exit:
      ret
scr_select endp

; deselect screen area that was passed
; during mouse movement

scr_un_select proc
      cmp select_flag,TRUE
        jnz short @@exit     ; nothing selected
      mov ax,old_scroffs
      sub ax,pressed_scroffs
        jz  short @@exit     ; test again for safety's sake
      mov bx,pressed_scroffs
      sub bx,2               ; initialize to one position before
      mov xor_ptr,bx
      call xor_scr           ; deselect
      mov select_flag,FALSE
   @@exit:
   ret
scr_un_select endp

; after double click or left release
; read selected characters into buffer

rd_from_scr proc
      push cs
      pop es                 ; store to es:di

      mov bx,pressed_scroffs
      mov cx,old_scroffs
      dec bx
      dec cx                 ; doesn't point to attribute any more now
      mov dx,2
      mov di,offset rd_buffer
      cmp bx,cx
        jc  short @@no_swap  ; not marked from right to left
        jz  short @@exit     ; nothing at all marked
      xchg bx,cx             ; now from left to right
      add bx,dx
      add cx,dx
@@no_swap:
      cld
      mov ax,videoseg
      mov ds,ax
      mov ah,0

@@rd_loop:
      cmp di,offset rd_buffer+RD_BUFLEN-1
	ja short @@no_bln_left  ; Puffer voll
      mov al,[ds:bx]
      cmp al,' '
	ja short @@non_blank
      inc ah
      cmp ah,32              ; blank code byte full ?
	jnz short @@next_char
      stosb                  ; store blank code byte
      mov ah,0               ; and continue with new one
      jmp short @@next_char

@@non_blank:
      cmp ah,0               ; are there blanks left unstored ?
        jz short @@no_blks   ; no
      xchg al,ah
      stosb
      xchg al,ah
      mov ah,0
@@no_blks:
      stosb                  ; store non blank

@@next_char:                 
      add bx,dx              ; next char on screen

; Test, if at line end on screen
; condition: screen pos mod (characters per line) == 0
      
      pushr <dx,cx,ax>
      xor dx,dx              ; must be 0 before divide
      mov ax,bx              ; screen pos
      sub ax,videooffs
      mov cx,colsPline
      add cx,cx              ; *2 because of ascii,attr
      div cx
      or dx,dx               ; Division reminder = 0 ?
	jnz short @@not_eol

@@go_back:                   ; discard blanks until end of line
      dec di
      cmp byte ptr [es:di],' '
	ja  short @@no_back
      cmp byte ptr [es:di],0 ; end of previous line ?
	ja short @@go_back
@@no_back:
      inc di
      mov al,dl              ; 0 to mark end of line
      stosb
      pop ax                 ; ax must have been pushed last
      xor ah,ah              ; Blank counter
      push ax
@@not_eol:
      popr <ax,cx,dx>
      cmp bx,cx              ; at the end of selected area ?
	jnz short @@rd_loop
      or ah,ah               ; blanks left to store ?
	jz short @@no_bln_left
      mov al,ah
      stosb                  ; store remaining blanks
@@no_bln_left:
      mov buf_end_poi,di     ; pointer to end of used buffer area

@@exit:
      ret
rd_from_scr endp

; the mouse handler is called by the mouse driver
; if one of those events occurs that were selected
; while installing in the CX mask

ms_hndler proc far
      mov di,40h             ; di contains (not needed) horizontal counts
      mov ds,di              ; set to bios data area

; do not let mouse routines happen if interrupt 10h is activ
; presently or is there is no text mode active

      cmp in10_flg,0         ; was Int 10h interrupted ?
        jz short @@not_in10        ; no
      jmp short @@goext

@@not_in10:

      cmp byte ptr [ds:49h],7  ; screen mode
	jz  short @@mode_ok
      cmp byte ptr [ds:49h],3
	jna short @@mode_ok
      cmp byte ptr [ds:49h],13h ; rest of vga modes graphics
        jna short @@goext
comment #
; now it is any svga mode
; so columns*lines*2 should be == current video buffer
      push ax
      mov al,[ds:84] ; lines-1
      inc al
      mul byte ptr [ds:4ah] ; columns
      add ax,ax             ; ascii+attribute
      cmp ax,[ds:4ch]       ; memory needed
      pop ax
      jz short @@mode_ok
@@goext: jmp @@exit
#

; assume it to be a text mode if it takes not
; more than 4000h in video memory
     cmp word ptr [ds:4ch],0800h ; memory need
      jb short @@goext
    cmp word ptr [ds:4ch],4000h ; memory need
     jna short @@mode_ok
@@goext:    jmp @@exit

@@mode_ok:

; CASE event DO

      test ax,M_RT_PRESSED
        jnz short @@rt_pressed
      test ax,M_LT_PRESSED
        jz short @@tst_right
        jmp  @@left_pressed
@@tst_right:
      test ax,M_LT_RELEASD
	jnz  short @@left_released
      test ax,M_MOVED
	jnz  short @@mouse_moved
      jmp  @@exit
; ENDCASE

@@left_released:
      cmp left_press_flg,TRUE
      jne @@no_selection
        mov select_flag,TRUE
@@no_selection:
      mov left_press_flg,FALSE
;      mov select_flag,TRUE
      call rd_from_scr
      jmp @@exit

@@rt_pressed:
      cmp left_press_flg,FALSE
      jz short @@do_insert
        jmp @@exit           ; both bottoms simultanously pressed
@@do_insert:
      mov buffer_valid,TRUE
      mov bx,offset rd_buffer
      mov buf_poi,bx         ; pointer reset, to make readable again
      call stuff2kbb         ; to end a possibly active int 16h,0

; if at the pressing of the right mouse button CTRL was pressed, too
; set flag to output a CR after outputting the buffer

      test byte ptr [ds:17h],4 ; Keyboard flag, bit 2 = CTRL
	jnz  @@stuff_CR
      jmp  @@exit
@@stuff_CR:
      mov  ctrl_rt_clck_flg,TRUE
      jmp  @@exit

@@mouse_moved:
      cmp mouse_on_flg,TRUE
	jz  short @@is_on
      show_mouse             ; switch on cursor after first movement
      mov mouse_on_flg,TRUE
@@is_on:
      cmp left_press_flg,TRUE
        jz  @@do_mark        ; select if left button still pressed
      jmp @@exit
@@do_mark:
      call scr_select
      jmp @@exit

@@left_pressed:              ; get screen data after left click
      mov ax,[ds:4ah]
      mov colsPline,ax
      mov ax,[ds:4eh]
      mov videooffs,ax
      mov ax,[ds:63h]
      cmp ax,3B4h            ; monochrome ?
      movz videoseg,0b000h,0b800h

      call scr_un_select     ; remove possible previous selection
      mov buffer_valid,FALSE
      mov blnks_left,0
      mov left_press_flg,TRUE
      call xy2offs
      mov pressed_scroffs,ax
      mov old_scroffs,ax
      sub ax,2
      mov xor_ptr,ax

; test if since last left click less
; than DCLCK_SPEED ticks have passed

      mov ah,0
      int 1ah                ; read system clock counter
      push cx ; hi
      push dx ; lo
      sub  dx,lclcktime
      sbb  cx,lclcktime+2    ; cx:dx = ticks since last click
      pop  cs:lclcktime
      pop  cs:lclcktime+2    ; save new time
      or cx,cx
        jnz short @@exit     ; more than 65535/18.2 Sec later
      cmp dx,DCLCK_SPEED
        ja short @@exit      ; more than 9/18.2 Sec later
; double click
      call select_word
      mov lclcktime,0
      mov lclcktime+2,0      ; prevent Triple click
@@exit:
      ret
ms_hndler endp


; install mouse handler

inst_ms_handler proc far
      pushr <es,dx,cx,ax>

; Software Reset, to put handler into defined state
      mov ax,21h
      int 33h
      push cs
      pop  es

      mov dx,offset ms_hndler
      mov cx,(M_MOVED or M_LT_PRESSED or M_LT_RELEASD or M_RT_PRESSED)
      mov ax,14h             ; Swap Interrupt Subroutines
      int 33h
                             ; ignore old interrupt routine
      popr <ax,cx,dx,es>
      ret
inst_ms_handler endp

; read characters from buffer
; stored are all characters > 32, n<=32 represents n Blanks, 0 = eoln

rd_from_buf proc
; Out: ZF = empty
      cmp buffer_valid,FALSE
	jz  short @@buf_empty
      cmp blnks_left,0
	jz  short @@no_bln_lft
      dec blnks_left
      incz buf_poi
      mov al,' '
      jmp short @@char_found

@@no_bln_lft:
      mov bx,buf_poi
      cmp bx,buf_end_poi
	jnz short @@not_empty
      cmp ctrl_rt_clck_flg,TRUE   ; append CR, too ?
	jnz short @@buf_empty
      mov ctrl_rt_clck_flg,FALSE
      mov al,13
      jmp short @@char_found

@@not_empty:
      mov al,[cs:bx]              ; get next character
      cmp al,0                    ; end of line ?
	jnz short @@not_eol
      mov al,13
      inc buf_poi
      jmp short @@char_found

@@not_eol:
      cmp al,' '
	jbe short @@blanks
      inc buf_poi
      jmp short @@char_found
@@blanks:
      mov ah,al
      mov al,' '
      dec ah
      mov blnks_left,ah
      incz buf_poi           ; blanks exhausted
@@char_found:
      clc
      ret
@@buf_empty:
      stc
      ret
rd_from_buf endp


; Patch for EXEC Function

new_21h proc
      cmp ax,4b00h           ; exec
      jz short @@new_exec
        jmp @@doit
@@new_exec:

; activate mouse handler, as it is possible,
; that a program, that changed the mouse handler,
; started COMMAND.COM

      push bp
      mov  bp,sp

; stack now:
; bp   -> bp
; bp+2 -> ip
; bp+4 -> cs
; bp+6 -> flags

      xpusha
      push es
      mov cx,0               ; only get old routine
      mov  ax,14h            ; Swap Interrupt Subroutines
      int 33h
      mov old_mask,cx
      mov old_rout,dx
      mov old_rout+2,es      ; save old routine

      call inst_ms_handler   ; set handler of PC-Mouse
      pop es
      xpopa
      push old_mask          ; push to enable recursion
      push old_rout
      push old_rout+2

      push [bp+6]            ; take flags of original int and
                             ; simulate int operation
      call dword ptr [cs:old_21h]

; iret after original int 21h leads to here
      pop  old_rout+2
      pop  old_rout
      pop  old_mask
      pop bp
      pushf
      xpusha
      mov ax,21h             ; Software Reset
      int 33h
      cmp cs:killed_flg,TRUE ; /U in the mean time ?
      jz short @@no_res_old
      mov cx,old_mask        ; set old routine again
      les dx,dword ptr old_rout
      mov ax,14h
      int 33h
@@no_res_old:
      xpopa
      popf
      retf 2                 ; ignore old flags as EXEC returns
                             ; result status in flag register
@@doit:
        db 0eah ; jmp far
old_21h dw 0,0
killed_flg db FALSE

new_21h endp


; Patch for Interrupt 10h

old_10h dw 0,0

new_10h proc
      cmp mouse_on_flg,TRUE
	jnz short @@no_hide
      hide_mouse
      mov mouse_on_flg,FALSE
@@no_hide:
      cmp select_flag,TRUE
	jnz short @@no_un_sel
      xpusha
      call scr_un_select
      mov left_press_flg,FALSE
      xpopa
@@no_un_sel:
      pushf                  ; simulate int
      inc in10_flg           ; Flag for int 10h active
      call dword ptr [old_10h]
      dec in10_flg
      iret
new_10h endp

if XT

chr2keybuf proc
; substitute for Int 16h, function 5
; in:  ch=scan code
;      cl=ascii
; out: al=0 success
;      al=1 buffer full


   push ds
   push bx
    pushf
    cli
    mov ax,biosdata
    mov ds,ax
    assume ds:biosdata
    mov ax,tailptr
    add ax,2
    cmp ax,bufend  ; Ringbuffer
    jnz @@no_wrap
    mov ax,bufstrt ; wrap around
@@no_wrap:
    cmp ax,headptr
    mov bl,1
    jz  @@full
    mov bx,tailptr ; old tailpointer
    mov [bx],cx    ; store scan+ascii
    mov ds:tailptr,ax
    mov bl,0
@@full:
   mov al,bl
   popf
   pop bx
   pop ds
ret
chr2keybuf endp

endif ; XT

if TIMER_TOO
; Patch for int 1ch

new_1ch proc
      call stuff2kbb         ; write characters into keyboard buffer
      db 0eah                ; Code for jmp far
old_1ch dw 0,0
new_1ch endp
endif

; Patch for int 16h

new_16h proc
      cmp  ah,MOUSE_FN       ; helloh, are you there ?
	jnz  short @@no_new
      dec  ah                ;  bios would let remain ah unchanged
      mov  cx,IDENTCODE
      push cs
      pop  es                ; es:bx := buffer adress
      mov  bx,offset rd_buffer
@@exit:
      iret
@@no_new:
      call stuff2kbb         ; write character into keyboard buffer
      db 0eah                ; Code for jmp far
old_16h dw 0,0
new_16h endp

; write characters into keyboard buffer
; until it is full

stuff2kbb proc     	     ; stuff to keyboard buffer
      xpusha
      xor cx,cx
      xchg cl,charsave       ; character left from last trial ?
      or cl,cl               ; 0 == nothing left
        jnz short @@after_rd ; save character from last trial
@@loop:
      call rd_from_buf
      mov cl,al
        jc short @@exit      ; nothing to store
@@after_rd:
      mov ah,5
      push cx
      mov ch,1ch             ; scancode, only relevant for ENTER
if XT
      call chr2keybuf
else
      pushf                  ; to simulate int
      call dword ptr old_16h ; store to keyboard buffer
endif
      pop cx
      or  al,al              ; 0 == save was successful
	jz  short @@loop
      mov charsave,cl        ; save for next trial
@@exit:
      xpopa
      ret
stuff2kbb endp

; the next two variables should be in this order before rd_buffer
; so that possibly they can be accessed from another program

dw offset buf_end_poi
dw RD_BUFLEN

; buffer for read characters,
; can overwrite initialisation code

rd_buffer equ $

        quiet_flag db FALSE

; change interrupts and install mouse handler

get_opt proc
        mov si,80h            ; si => Kommandozeilenparam
        seges
        lodsb                 ; count
        mov bh,0
        mov bl,al
        mov es:[si+bx],bh        ; 0
        or  al,al
        jz  @@parm_done
@@findslash:
        seges
        lodsb
        or al,al
        jz  @@parm_done
        cmp al," "
        jz short @@findslash     ; +DEC CX
        cmp al,"/"
        jz  short @@good_sep
        cmp al,"-"
        jnz @@parm_err
@@good_sep:
@@loop:
        seges
        lodsb
        cmp al,'?'
        jz short @@parm_err
        and al,not ('a'-'A')  ; toupper
        cmp al,'U'
        mov ah,DE_INSTALL
        jz short @@exit

        cmp al,'R'
        mov ah,REACTIVATE
        jz short @@exit

        cmp al,'N'
        jnz short @@no_safe
        mov cs:safe_flag,TRUE
        jmp @@findslash
@@no_safe:
        cmp al,'Q'
        jnz short @@no_quiet
        mov cs:quiet_flag,TRUE
        jmp @@findslash
@@no_quiet:
        cmp al,'M'
        jnz short @@no_mark_byte
        call parse_num
        cmp ax,255
        ja @@parm_err
        cmp ax,0
        jb short @@parm_err
        mov scr_mark_mask,al
        jmp @@findslash
@@no_mark_byte:
        cmp al,'T'
        mov ah,TICK_TOO
        jz short @@exit
@@parm_err:
        mov ah,FALSE
        ret
@@parm_done:
        mov ah,TRUE
@@exit:
        ret
get_opt endp


parse_num proc
        mov bx,10
        mov ax,0
        mov dh,0
@@addloop:
        seges
        mov dl,[si]
        or dl,dl
        jz  short @@done
        inc si
        sub dl,'0'
        jc short @@done
        cmp dl,9
        ja short @@done
        push dx
        mul bx
        pop dx
        add ax,dx
        jmp short @@addloop
@@done:
        ret
parse_num endp

inst_tst proc   ; exit: Z = installed
        PUSHR <ax,dx,cx>
        mov ah,MOUSE_FN        ; test for installed, call patched int16h
        mov al,MOUSE_FN
        push ax
        int 16h                ; es:bx -> rd_buffer
        pop dx
        dec dh
        cmp ah,dh
        jnz short @@exit
        cmp cx,IDENTCODE
@@exit:
        POPR <cx,dx,ax>
        ret
inst_tst endp

cmp_fptr proc ; cmp ax:bx and cx:dx
        xpusha
        mov si,0
        mov di,0

; si:ax *= 16
        rept 4
          shl ax,1
          rcl si,1
        endm
        add ax,bx
        adc si,0

; di:cx *= 16
        rept 4
          shl cx,1
          rcl di,1
        endm
        add cx,dx
        adc di,0

        cmp cx,ax
        jnz short @@exit
        cmp si,di
@@exit:
        xpopa
        ret
cmp_fptr endp

      ms_hnd_ptr dw 0,0

re_activate proc
;LOCAL  hndoffs,hndseg:WORD = AUTO_SIZE
LOCAL  hndadr:DWORD = AUTO_SIZE
       push bp
       mov  bp,sp
       sub  sp,AUTO_SIZE
      PUSHR <ds,es>
      call inst_tst
      mov al,NOT_INSTALLED
      jnz short @@exit

      mov ah,MOUSE_FN ; rd_buffer -> es:bx
      mov al,MOUSE_FN
      int 16h

      sub bx,rd_buffer-inst_ms_handler ; bx -> inst_ms_handler
      mov word ptr hndadr,bx
      mov bx,es
      mov word ptr hndadr+2,bx
      call dword ptr [hndadr]

@@exit:
      POPR <es,ds>
       add  sp,AUTO_SIZE
       pop bp
      ret
re_activate endp

de_inst proc
LOCAL  pcmoffs,pcmseg:WORD,safeflg:BYTE,tckflg:BYTE = AUTO_SIZE
       push bp
       mov  bp,sp
       sub  sp,AUTO_SIZE
       PUSHR <ds,es>
      call inst_tst
      mov al,NOT_INSTALLED
      jz short @@cont_de_inst
      jmp @@goexit
@@cont_de_inst:
; now test for all patched vectors, if they point to pcmouse
      mov ah,MOUSE_FN ; rd_buffer -> es:bx
      mov al,MOUSE_FN
      int 16h
      mov pcmoffs,bx
      mov ax,es
      mov pcmseg,ax
      push bx
      sub bx,rd_buffer-tick_flg
      mov al,es:[bx]
      mov tckflg,al
      pop bx

      sub bx,rd_buffer-safe_flag
      mov al,es:[bx]
      mov safeflg,al   ; use safe_flag of installed copy
        

rstvec macro vec,old_vec_dist
      mov bx,pcmoffs
      sub bx,old_vec_dist
      lds dx,[es:bx]
      mov ax,(25h shl 8) + vec           ; set vector
      int 21h
endm

cmpvec macro vec,new_vec_dist
      mov ax,(35h shl 8) + vec           ; get vector
      int 21h                            ; to es:bx

      mov ax,es
      mov cx,pcmseg
      mov dx,pcmoffs
      sub dx,new_vec_dist
      call cmp_fptr      ; cmp ax:bx and cx:dx
      jnz @@wrong_vec
endm

     cmp safeflg,TRUE
        jz short @@no_21_test
      cmpvec 21h,rd_buffer-new_21h

@@no_21_test:
      cmpvec 16h,rd_buffer-new_16h
      cmpvec 10h,rd_buffer-new_10h

if TIMER_TOO
      cmp tckflg,TRUE
        jnz short @@no_tick1
      cmpvec 1ch,rd_buffer-new_1ch
@@no_tick1:
endif

        jmp short @@de_inst

@@wrong_vec:
        mov al,WRO_VEC
@@goexit:
        jmp short @@exit

@@de_inst:

     cmp safeflg,TRUE
        jz short @@no_21_deinst
        rstvec 21h,rd_buffer-old_21h

@@no_21_deinst:
        rstvec 16h,rd_buffer-old_16h
        rstvec 10h,rd_buffer-old_10h

if TIMER_TOO
      cmp tckflg,TRUE
        jnz short @@no_tick2
        rstvec 1ch,rd_buffer-old_1ch
@@no_tick2:
endif

; reset driver is done at end of last exec, too
        mov ax,0h
        int 33h     ; reset mouse driver & HW

        mov es,pcmseg             
        mov bx,pcmoffs		    ; es:bx -> installed rd_buffer
        sub bx,rd_buffer-killed_flg ; es:bx -> killed flag
        mov byte ptr [es:bx],TRUE   ; else new_exec will restore mouse driver
        mov bx,pcmoffs
        sub bx,rd_buffer-pspadr     ; es:bx -> pspadr
        mov es,[es:bx]              ; es -> memory to be freed
        mov ah,49h ; free memory
        int 21h

        mov al,ALL_OK
        jmp @@exit

@@exit:
       POPR <es,ds>
       add  sp,AUTO_SIZE
       pop bp
       ret
de_inst endp

init proc
      mov ax,es
      mov cs:pspadr,ax

      mov ax,cs
      mov ds,ax

      call get_opt

      push ax

      cmp cs:quiet_flag,TRUE
      jz short @@no_onsign
      mov dx,offset onsign
      mov ah,9
      int 21h
@@no_onsign:

      pop ax

      cmp ah,TICK_TOO
        jnz @@no_tick
        mov cs:tick_flg,TRUE
        jmp short @@cont_inst
@@no_tick:
      cmp ah,TRUE
        jz short @@cont_inst
      cmp ah,FALSE
        mov dx,offset help_str
        jz @@do_exit
      cmp ah,REACTIVATE
        jnz short @@tst_de_inst
      call re_activate
        cmp al,NOT_INSTALLED
        jz short @@not_yet1
        mov dx,offset re_inst_str
         jmp @@do_exit

@@tst_de_inst:
      cmp ah,DE_INSTALL
        jnz short @@cont_inst
      call de_inst
        cmp al,NOT_INSTALLED
@@not_yet1:
        mov dx,offset not_yet_str
         jz @@do_exit
        cmp al,ALL_OK
        mov dx,offset ok_de_inst
         jz @@do_exit
        mov dx,offset wro_de_inst
         jmp @@do_exit


@@cont_inst:

if not XT
; Test for 80188 or successor

      mov cl,33
      shl ax,cl
      or  cl,cl              ; 188+ maximally shift 32 positions
      mov dx,offset wro_cpu_str
      jz @@errexit

; Test for modern Bios with int 16,5

      mov ax,40h
      mov es,ax
      test byte ptr [es:96h],10000b ; enhanced keyboard installed ?
      jz @@errexit

endif ; XT

; use function 21h (instead of 0) to ensure that new
; mouse driver is installed

      mov ax,21h             ; Test, if mouse driver installed
      int 33h
      inc ax   		     ; installed => 0
	jz  @@mouse_there

      mov dx,offset nomouse_str
@@errexit:
      mov ah,9
      int 21h
      mov  dx,offset noins_str
@@do_exit:
      mov  ah,9
      int  21h
      mov  ax,4c01h          ; errorlevel 1 == no mouse driver
      int  21h

@@mouse_there:
      call inst_tst
      jnz short @@install

      mov dx,offset msgstr
      mov ah,9
      int 21h
      mov  ax,4c02h          ; errorlevel 2 == re installed
      int  21h

@@install:

; free environment
; so it can be used for the next program's environment

      mov es,cs:pspadr
      mov es,[es:2ch] ; segadr environment
      mov ah,49h ; free memory
      int 21h

      mov ax,3516h
      int 21h                ; get vector
      mov word ptr old_16h,bx
      mov word ptr cs:[old_16h+2],es
if TIMER_TOO
      mov ax,351ch
      int 21h                ; get vector
      mov word ptr old_1ch,bx
      mov word ptr cs:[old_1ch+2],es
endif

      mov ax,3510h
      int 21h
      mov word ptr cs:[old_10h],bx
      mov word ptr cs:[old_10h+2],es

; with option /S don't install int 21h patch

     cmp cs:safe_flag,TRUE
        jz short @@no_21_inst
      mov ax,3521h
      int 21h
      mov word ptr cs:[old_21h],bx
      mov word ptr cs:[old_21h+2],es
      mov dx,offset new_21h
      mov ax,2521h           ; set vect
      int 21h

@@no_21_inst:
      mov dx,offset new_10h
      mov ax,2510h           ; set vect
      int 21h
      mov dx,offset new_16h
      mov ax,2516h           ; set vect
      int 21h
if TIMER_TOO
      cmp cs:tick_flg,TRUE
        jnz short @@no_tick_set
      mov dx,offset new_1ch
      mov ax,251ch           ; set vect
      int 21h
@@no_tick_set:
endif

      call inst_ms_handler

      cmp cs:quiet_flag,TRUE
      jz short @@no_how_to
      mov dx,offset how_to
      mov ah,9
      int 21h
@@no_how_to:

      mov dx,(end_mouse-res_beg+15+256) shr 4
      mov ax,3100h
      int 21h                ; terminate stay resident

init endp

onsign db 13,10,'PC-Mouse, version ',PVERSION,13,10,10
       db 'Copyright (c) 1992,1995 Jrgen G. Weber',13,10,10
       db 'Jrgen Weber',13,10
       db 'Wiesentalstrae 1',13,10
       db 'D-74523 Schwbisch Hall',13,10
       db 'Germany - European Union',13,10,10
       db 'Free for personal use.',13,10
       db 10,'$'

how_to:
       db 'PC-Mouse is installed.',13,10,10
       db 'Use the left button to select',13,10
       db 'a part of the screen or double',13,10
       db 'click a word. Paste the selected',13,10
       db 'text by clicking the right button.',13,10,'$'
msgstr db 13,10
       db 'PC-Mouse was already installed.',13,10,'$'
not_yet_str db 13,10,'PC-Mouse was not installed yet.',13,10,'$'
ok_de_inst db 13,10,'PC-Mouse is un-installed.',13,10,'$'
re_inst_str db 13,10,'PC-Mouse is re-activated.',13,10,'$'
wro_de_inst db 13,10,'Could not un-install PC-Mouse.',13,10,'$'
nomouse_str db 13,10,7,'No mouse driver found or driver too old.',13,10,'$'
noins_str db 'PC-Mouse not installed.',13,10,'$'
wro_cpu_str db 'PC-Mouse neads at least an 80286 with',13,10
            db 'extended keyboard support.',13,10,'$'
help_str db 13,10,'Options: /U    : Un-install PC-Mouse',13,10
               db '         /T    : Use Timer Int',13,10
               db '         /Q    : Quiet: no messages',13,10
               db '         /N    : No mouse handler saving',13,10
               db '         /R    : Reactivate PC-Mouse',13,10
               db '         /Mnnn : Use Marker Byte nnn',13,10
         db 13,10,'$'

if  ($-rd_buffer) lt RD_BUFLEN
        db  RD_BUFLEN-($-rd_buffer) dup (?)
endif

end_mouse equ rd_buffer+RD_BUFLEN
code ends

; Stack segment is only used during initialisation

stck segment para stack 'stack'
  db 256 dup (?)
stck ends

end init


