PROCEDURE BSBvals; 
   VAR Stim: STIMULUS;
       Stimulus_set: CHAR;
       Stimulus_number: INTEGER;
  
   PROCEDURE BSBvals_initialization;
       BEGIN
       CASE Test_stimulus_set OF
            'F','f': Stim:= F_set [Test_stimulus_nr];
            'G','g': Stim:= G_set [Test_stimulus_nr];
            'T','t': Stim:= T_set [Test_stimulus_nr];
            END;
       IF NOT Restart THEN Stim.Val:= Inp;
       END;
 
   PROCEDURE Display_stimulus;
	VAR I, Row_nr, Elements_per_line, 
        Unit_nr, Elements_per_unit, Truncated_value: INTEGER;
        Stim_interpretation: String;
        Sign_char, Value_char: CHAR;
	BEGIN
        Interpret (Threshold, Stim.Val, Stim_Interpretation);
        Clear_block; Scroll_block;
	WRITELN ('            Name: ', Stim.Name);
        WRITELN ('  Interpretation: ', Stim_interpretation);
        WRITELN;
        Elements_per_unit :=  8;  {One byte.  Basic reporting unit.}
	Elements_per_line := 24;  {Three bytes. Number of elements in a line.}
	FOR I:= 1 TO Dimensionality DO 
                BEGIN
                IF (I MOD Elements_per_unit = 1) THEN
                         BEGIN
                         Unit_nr:= 1 + I DIV Elements_per_unit;
                         WRITE ( I:6);
                         WRITE (' ',Stim_interpretation [Unit_nr], ' '); 
                         END;

                IF Stim.Val [I] > 0 THEN 
                     BEGIN
                     Sign_char := '+';
                     Truncated_value:= TRUNC (10*Stim.Val[I]/Upper_limit);
                     IF Truncated_value >= 10 THEN Value_char:= 'L' ELSE
                                  Value_char:= CHR (48 + Truncated_value);
                     END;

                IF Stim.Val [I] < 0 THEN 
                     BEGIN
                     Sign_char := '-';
                     Truncated_value:= TRUNC (ABS(10*Stim.Val[I]/Lower_limit));
                     IF Truncated_value >= 10 THEN Value_char:= 'L' ELSE
                                  Value_char:= CHR (48 + Truncated_value);
                     END;

                IF Stim.Val [I] = 0 THEN 
                     BEGIN
                     Sign_char := ' ';
                     Value_char:= '0';
                     END;

                WRITE (Sign_char:1, Value_char:1);
                IF (I MOD Elements_per_line = 0) 
                   THEN BEGIN WRITE ( I:4); WRITELN  END;
                END;
	END;


BEGIN {Procedure BSB_vals.}
BSBvals_initialization;
Display_stimulus;
END;  {Procedure BSB_vals.} 
