(* 

changes strings into characters by a table file.
the reverse of CH2STR.

written by jukka-pekka.takala@helsinki.fi, originally
to work with Nota Bene
originally to make high bit characters e-mailable, such as

 a[umlaut]
 e+

this program performs conversion from the right side of the table to the 
left side, i.e., reverses the conversion done by CH2STR but using the
same table.


For revision history, see STR2CH.DOC
*)


const StrL=17;
      InSz = 2048;
      OutSz = 4096;
      ArrSiz = 255;
      OvrLen = 10;

var fi,fo, ftbl: text;
    fin,fon,ftbln:string[50];
    ExmArr : Array[0..ArrSiz] of String[StrL]; {note in this program}
    OutArr: Array[0..ArrSiz] of String[1];
    GtLine : String[230];
    OutLine : String;
    OutCh : Char;
    i : integer;
    TblSz : integer;

Procedure DoError;
 var hl:string[60];
begin
 hl := paramstr(0);
 while pos('\',hl)>0 do delete(hl,1,pos('\',hl));
 while pos('.',hl)>0 do delete(hl,pos('.',hl),4);
 writeln('Format: ');
 writeln( hl, ' INFILE OUTFILE TABLE.CTB ');
 writeln('''outfile'' will be overwritten without warning');
 writeln('Max length of strings in conversion table ',StrL);
 writeln('Max no. of such strings: ',ArrSiz);
 writeln('Limit to line length in source file: none');
 halt;
end;

Function UpStr(s: String): String;
 var i : byte;
begin
 for i := 1 to length(s) do
  UpStr[i] := upcase(s[i]);
end;


Procedure InitTable;
 var Line : string;
     k : char;
     kk : string[StrL];
     count:byte;
 begin
   {check file.ext for some security }
   if copy(Ftbln,pos('.',Ftbln),4) <> '.CTB'
     then begin writeln('Need a *.CTB file'); halt; end;
   if copy(Fon,pos('.',Ftbln),4) = '.CTB'
     then begin writeln('cannot output to *.CTB file'); halt; end;
   FillChar( ExmArr, SizeOf(ExmArr), 0);
   FillChar( OutArr, SizeOf(OutArr), 0);
   reset(Ftbl);
   count:= 1;
   repeat
    readln(Ftbl, Line);
     if  (Line[ 1 ] <> ';') and (Line <>'') then
      begin
       k := Line[1];
       OutArr[count]:= copy(Line,1,1);
       kk := copy(Line, 3, Length( Line ) - 2 );
       (*debug write(char(K),' ',kk);readln;*)
       ExmArr[ count ] := kk;
       count := count + 1;
       if count > ArrSiz then begin
            writeln('table too big, max ',arrsiz ); halt; end;
      end;
   until eof(Ftbl);
   TblSz := Count - 1;
 end;

 Function StringToChar( l : String): String;
    var j : byte;
 Begin
   j := Pos(ExmArr[ i ], l );
   while j > 0 do
   Begin
     Delete( l , j,
             Length(ExmArr[ i ]));
     Insert( OutArr[ i ], l, j );
     j := Pos(ExmArr[ i ], l );
     end;
  StringToChar := l;
  End;


 begin
   if paramcount<>3 then DoError;
   fin:=paramstr(1); fin:=upStr(fin);
   fon:=paramstr(2); fon:=upStr(fon);
   assign(fi,fin);
   assign(fo,fon);
   ftbln:=paramstr(3); ftbln:=upStr(ftbln);
   assign(ftbl, ftbln);

   InitTable;

   reset(fi);
   rewrite(fo);
   OutLine := '';

   repeat
     While Eoln(Fi) and (not eof(Fi)) do
      begin
        ReadLn(Fi);
        Writeln(Fo);
        OutLine := '';
     End;
     Read(Fi, GtLine);
     OutLine := OutLine+GtLine;
      if Length(OutLine) > 1 then
       For i := 1 to TblSz do

         if ExmArr[ i ] <>'' then
          OutLine := StringToChar(OutLine);

      If eoln(Fi) then
         Write(Fo, Outline)
       Else
        Begin
         Write(Fo, Copy(OutLine, 1, Length(OutLine)-OvrLen ));
         Delete(OutLine, 1, Length(OutLine)-OvrLen );
        End;
    until Eof(Fi);
    close(fi);
    write(fo,^z);
    close(fo);
    end.
