;**********************************************************************
; CURDRI.ASM              Clipper .OBJ to get the current drive letter
; Author..: Sal Ricciardi
;
; Usage:  cdrive = curdrive()
;
; Create .OBJ with:   TASM curdri  (Borland Turbo Assembler 2.5)
;
; To link into your Clipper 5 app:
;   RTLINK FILE yourapp.obj, CURDRI.OBJ LIB CLIPPER, EXTEND
;
; To link into your Clipper Summer 87 app:
;   PLINK86 FILE yourapp.obj, CURDRI.OBJ LIB CLIPPER, EXTEND
;
;**********************************************************************
              .MODEL LARGE
              EXTRN  __retc:FAR
              PUBLIC curdrive
              .DATA
cdrive        db    ?                           ;one byte for drive letter
              .CODE
curdrive      PROC  FAR                         ;entry point
              push  ax                          ;save registers
              push  bx                          ;
              push  cx                          ;
              push  dx                          ;
              push  es                          ;
              mov   ah,19h                      ;get current drive
              int   21h                         ;dos interrupt
              add   al,'A'                      ;convert number to letter
              mov   cdrive,al                   ;store in cdrive
              push  ds                          ;push FAR pointer to
              mov   ax,OFFSET cdrive            ;cdrive
              push  ax                          ;
              call  __retc                      ;post Clipper return value
              add   sp,4                        ;adjust the stack
              pop   es                          ;restore registers
              pop   dx                          ;
              pop   cx                          ;
              pop   bx                          ;
              pop   ax                          ;
              ret                               ;return to caller
curdrive      ENDP
              END
