@echo off
if %1/==/ goto Syntax
if %z%/==/ goto Syntax
::
REM Create a file containing the name of this batch
REM file followed by the directory on which it was
REM invoked, a backslash, and a Ctrl-Z character.
::
echo %0 %1\%z% >%1\ch.$$$
::
REM Create a file listing the subdirectories of the
REM directory on which this batch file was invoked
::
dir %1 /a:d/b >%1\lf.$$$
::
:loop             ;over all dirnames
::
copy %1\lf.$$$ %1\df.$$$ >nul
::
REM If there are no more subdirectories to deal with,
REM delete all files and this directory.
::
if not exist %1\df.$$$ goto cut
::
REM Create a temporary batch file that will re-invoke
REM PD.BAT on a subdirectory of the current directory.
::
copy %1\ch.$$$+%1\df.$$$ %1\x.bat >nul
::
REM Filter out the line that handles the first of the
REM subdirectories in the list, and store the result
REM as the list of remaining directories.
::
type %1\x.bat | find /v "%0 %1" > %1\lf.$$$
::
REM Make a recursive call to this batch file, to delete
REM all files and subdirectories in one particular
REM subdirectory.
::
call %1\x
goto loop
:cut              ;cut-off branch
echo Pruning directory %1
::
REM Turn off the read-only and hidden attributes for
REM all files in the directory; leave the system attribute
REM so there's no chance of deleting the system files.
::
attrib -r -h %1\*.* 
echo y | del %1 >nul
rd %1
goto end
:Syntax
echo PD.BAT - Prune Directory
echo SYNTAX:  SET z=^Z
echo          PD [[[drive:\]path\]dirname
:end
