@ECHO OFF
ECHO SETVERD.BAT - Removes all entries from SETVER table

REM Make sure SETVERD.BAT is in current directory
IF EXIST SETVERD.BAT GOTO AnyEntries
ECHO Please run SETVERD.BAT from the current directory
GOTO End

:AnyEntries
REM First be sure there *ARE* any entries
SETVER | FIND "No entries" > SV1$$$$$.$$$
COPY SV1$$$$$.$$$ SV2$$$$$.$$$ > NUL
IF NOT EXIST SV2$$$$$.$$$ GOTO YesEntries
TYPE SV2$$$$$.$$$
GOTO End

:YesEntries
REM If SETVER device not loaded, print a reminder
SETVER | FIND "device" > SV1$$$$$.$$$
COPY SV1$$$$$.$$$ SV2$$$$$.$$$ > NUL
IF NOT EXIST SV2$$$$$.$$$ GOTO SVLoaded
TYPE SV2$$$$$.$$$
DEL SV2$$$$$.$$$
ECHO       (However, that won't stop SETVERD.BAT from working.) ECHO.
GOTO SVLoaded

REM These next three lines become SV1$$$$$.BAT.  Each
REM begins with two Tab characters.
		ECHO   Removing %1	from SETVER table
		ECHO SETVER %1 %2 >> RESETVER.BAT
		SETVER %1 /D /Q

:SVLoaded
REM Creating ancillary files...
REM Create SV1$$$$$.BAT - note that there are two Tab
REM   characters between the first pair of quotes
TYPE SETVERD.BAT | FIND "		" | FIND /V "FIND" > SV1$$$$$.BAT
REM Create SV1$$$$$.CMD
ECHO N SV1$$$$$.CMD > SV1$$$$$.SCR
ECHO E 100 "sv1$$$$$ " >> SV1$$$$$.SCR
ECHO RCX >> SV1$$$$$.SCR
ECHO 9 >> SV1$$$$$.SCR
ECHO W >> SV1$$$$$.SCR
ECHO Q >> SV1$$$$$.SCR
DEBUG < SV1$$$$$.SCR > NUL
DEL SV1$$$$$.SCR

ECHO @ECHO OFF > RESETVER.BAT
ECHO ECHO RESETVER.BAT: Restoring SETVER table >> RESETVER.BAT
ECHO CTTY NUL >> RESETVER.BAT

ECHO Now removing all entries from SETVER table
ECHO.
SETVER | FIND "." | FIND /V "device" > SV1$$$$$.$$$

:Loop
COPY SV1$$$$$.CMD + SV1$$$$$.$$$ SV2$$$$$.BAT > NUL
CALL SV2$$$$$.BAT
TYPE SV2$$$$$.BAT | FIND /V "sv1$$$$$" > SV1$$$$$.$$$
COPY SV1$$$$$.$$$ SV2$$$$$.BAT > NUL
IF EXIST SV2$$$$$.BAT GOTO Loop

ECHO CTTY CON >> RESETVER.BAT
ECHO ECHO Restoration complete >> RESETVER.BAT
ECHO.
ECHO All entries removed from SETVER table.  Reboot to activate changes.
ECHO.
ECHO Run RESETVER.BAT to *restore* the removed entries.

:End
IF EXIST SV1$$$$$.$$$ DEL SV1$$$$$.$$$
IF EXIST SV2$$$$$.$$$ DEL SV2$$$$$.$$$
IF EXIST SV1$$$$$.BAT DEL SV1$$$$$.BAT
IF EXIST SV1$$$$$.CMD DEL SV1$$$$$.CMD
