;SYSCAP.ASM
;
;SysCap Version 1.0 Copyright 1995 Gregory A. Wolking
;First published in PC Magazine, April 25 1995, US Edition
;
;Source code for SYSCAP.EXE, a DOS program/device driver that captures the
;current text-mode screen image and writes it to the file you specify.
;
;Assembly notes:
;With MASM 5.1:
;	MASM syscap;
;	LINK syscap;
;
;With MASM 6.1:
;	ML syscap.asm
;If you use the PWB, the standard "DOS EXE" build options are sufficient.
;
;IMPORTANT: You must not use EXEPACK, PKLITE, LZEXE, or any similar
;	    software to compress the resulting .EXE file, otherwise
;	    the program will not work when loaded as a device driver.
;
;It's also important to note that even though this program has no separate
;data segment, it cannot be compiled as a "tiny" model (i.e., .COM)
;executable file or it will not work at all. While I could have declared
;the data in a separate data segment, this would make it much more
;complex than it needs to be.
;
;Notation conventions:
;UPPERCASE = numeric constants or LABELs.
;MixedCase = local variables and procedure names.

MDA		EQU	0		;Adapter constants
CGA		EQU	1
MCGA		EQU	2
EGA		EQU	3
VGA		EQU	4
MONO		EQU	0		;Display constants
COLOR		EQU	1
MAX_SPEC	EQU	64		;Max filespec length

myseg	SEGMENT PUBLIC PARA 'CODE'
assume	CS:myseg, DS:myseg, ES:nothing, SS:stackseg

;DOS Device driver header.
;Note that it _must_ be at offset 0 in the code segment.

	ORG	0000h
	DD	0FFFFFFFFh	;Pointer to next device driver
	DW	08000h		;Device attribute (character device)
	DW	Strategy	;Offset of "strategy" routine.
	DW	Interrupt	;Offset of "interrupt" routine.
	DB	"$CAPTURE"	;Device name.

LINES		EQU	$	;Table of line counts
		DB 25
		DB 43
		DB 50
Sizes		LABEL	WORD	;Table of corresponding page sizes
		DW 100h 	;in paragraphs.
		DW 1BEh
		DW 204h

Data_Start	DW 0		;Pointer to start of captured screen.
Buf_Size	DW 0		;# of bytes in capture buffer.
Vid_Mode	DB ?		;Video mode
Vid_Page	DB ?		;Display page
Vid_Rows	DB ?		;# screen rows
Vid_Cols	DB ?		;# screen columns
Vid_Display	DB ?		;Display type (COLOR or MONO)
Vid_Adapter	DB ?		;Adapter type (MDA, CGA, MCGA, etc.)
Vid_Segment	DW ?		;Video RAM segment

Old_Stack_Off	DW ?		;Storage for DOS stack pointer.
Old_Stack_Seg	DW ?

Parm_Ptr	LABEL	DWORD	;Pointer to command-line params.
Parm_Offset	DW ?		;Offset.
Parm_Segment	DW ?		;Segment.

Packet_Ptr	LABEL	DWORD	;Pointer to DOS driver request packet.
Packet_Off	DW ?		;Offset.
Packet_Seg	DW ?		;Segment.

Error_Code	DB	0		;Exit code storage.
Run_Mode	DB	0		;Run-mode flag.
Switch_Byte	DB	0		;Switch storage.
FF_Char 	DB	12		;Form feed character.

SWITCHES	EQU	$		;List of switch chars.
		DB	"ACFTV?"	;Order of list is important!
SWITCH_COUNT	EQU	$ - SWITCHES	;# of valid switch chars.

APPEND		EQU	00000001b	;Bit masks for corresponding
CLEAR		EQU	00000010b	;switch characters. Since Parse_Args
FORMFEED	EQU	00000100b	;calculates the bit to set from the
TRIM		EQU	00001000b	;
VERBATIM	EQU	00010000b
HELP		EQU	00100000b
ALL_BLANK	EQU	01000000b	;Last two bits used by Grab_Screen
ROW_BLANK	EQU	10000000b

WHITE_SPACE	EQU	$		;List of whitespace chars:
		DB	9, 10, 13, 32	;  tab, LF, CR, space.
NUM_WHITE	EQU	$ - WHITE_SPACE ;# of whitespace chars.

SEPARATOR	EQU	$		;Separator between captures
		DB	13,10,"--------------",13,10
SEP_LEN 	EQU	$ - SEPARATOR

FILE_SPEC	EQU	$		;Storage for output filespec.
		DB	"SYSCAP.TXT"	;Default output filespec.
		DB	MAX_SPEC - ($ - FILE_SPEC) DUP (0)	;Pad with 0's.
		DB	0		;One more byte for terminator.

		DB	256 DUP (?)	;Local stack for device driver mode.
STACK_TOP	EQU	$		;Top of local stack.


BUFFER_START	EQU	$		;Work buffer.
		DB	1024 DUP (?)	;Leave room for command line parms.

	;Save some space in .EXE file by
	;putting the banner in the middle
	;of the work buffer.
BANNER	EQU	$
	DB	"SysCap  Version 1.0  Copyright 1995 Gregory A. Wolking",13,10
	DB	"First published in PC Magazine, April 25 1995, US Edition",13,10
	DB	13,10
	DB	"Captures text-mode screen image to the specified file.",13,10
	DB	13,10
	DB	"Usage (in CONFIG.SYS): DEVICE=d:\path\SYSCAP.EXE [filespec] [switches]",13,10
	DB	"   or (at DOS prompt): SYSCAP [filespec] [switches]",13,10
	DB	13,10
	DB	"All command-line arguments must be separated by at least one space or tab.",13,10
	DB	"Default [filespec] is ",34,"SYSCAP.TXT",34,13,10
	DB	"Switches:",13,10
	DB	"  /A = Append to capture file instead of replacing it.",13,10
	DB	"  /C = Clear screen and home cursor after capture.",13,10
	DB	"  /F = Add form feed to end of capture file.",13,10
	DB	"  /T = Trim trailing blank lines from the end of the screen.",13,10
	DB	"  /V = Verbatim capture (overrides /T but not /F).",13,10
	DB	"ERRORLEVEL return codes:",13,10
	DB	"  1 = Invalid or unrecognized screen mode.",13,10
	DB	"  2 = Error creating capture file.",13,10
	DB	"  3 = Error while writing to capture file."
BAN_LEN	EQU	$ - BANNER
	ORG	BUFFER_START + 4200
LAST_BYTE	EQU	$
	DB	0


;-------------------------------------
;Main code when run from command line.
;-------------------------------------

Main:
	push	cs			;Force DS = CS since all of our
	pop	ds			;  data is in the code segment.
	mov	Run_Mode, HELP		;Set "run as .EXE" flag.
	mov	ah, 62h			;Get PSP segment in BX.
	int	21h
	mov	Parm_Segment, bx	;Store command line pointer.
	mov	Parm_Offset, 81h
	push	ds			;Save DS
	mov	ds, bx			;DS = PSP Segment.
	mov	si, 80h 		;DS:SI -> command line length byte.
	lodsb				;AL = length of command line.
	xor	ah, ah			;AX = length of command line.
	add	si, ax			;Point to end of command line.
	mov	BYTE PTR [si], 13	;Terminate command line with CR.
	pop	ds			;Restore DS
	push	cs			;Simulate FAR call.
	call	EXE_Mode_Entry		;Call "Interrupt" routine.
	test	Switch_Byte, HELP	;Help flag set?
	jz	Main_Done		;Done if not.
	mov	bx, 1			;Handle for standard output.
	mov	dx, BANNER		;Point to banner
	mov	cx, BAN_LEN		;CX = length of banner.
	call	Write_Device
Main_Done:
	mov	al, Error_Code		;Set ERRORLEVEL.
	mov	ah, 4Ch
	int	21h			;Back to DOS.
;-----------------------------
;End of direct execution code.
;-----------------------------

;---------------------------------
;Device-driver "Interrupt" routine
;---------------------------------
Interrupt:
	push	ax			;Save AX and flags on DOS stack
	pushf
	mov	cs:Old_Stack_Off, sp	;Save DOS stack pointer.
	mov	cs:Old_Stack_Seg, ss
	cli				;Interrupts off.
	mov	ax, cs			;Set SS:SP to local stack area.
	mov	sp, STACK_TOP
	mov	ss, ax
	sti				;Interrupts on.
	push	es			;Save registers on local stack.
	push	ds
	push	ax
	push	bx
	push	cx
	push	dx
	push	si
	push	di

	push	cs			;Make sure DS points to our segment.
	pop	ds
	cld				;String instructions forward
	mov	Packet_Off, bx		;Save pointer to request packet.
	mov	Packet_Seg, es
	mov	ax, es:[bx + 18]	;Get pointer to command-line
	mov	Parm_Offset, ax 	;from request packet and save it.
	mov	ax, es:[bx + 20]
	mov	Parm_Segment, ax

EXE_Mode_Entry:				;.EXE-mode entry point.
	push	cs			;ES = CS
	pop	es
	call	Get_Vid_Config		;Get video information.
	cmp	al, 3			;Mode 0-3?
	jbe	Mode_Ok			;Continue if so.
	cmp	al, 7			;Mode 7?
	jz	Mode_Ok			;Continue if so
	mov	Error_Code, 1		;Set exit code if not.
	jmp	Finish

Mode_OK:
	call	Copy_Parms		;Copy parameters to work buffer.
	call	Parse_Args		;Parse command-line parameters.
	test	Switch_Byte, HELP	;If run as EXE and /? specified,
	jnz	Strategy		;we're done.
	call	Grab_Screen		;Copy screen to buffer.
	test	Switch_Byte, CLEAR	;Clear screen?
	jz	No_CLS			;Skip if not.
	call	Clear_Screen
No_CLS:
	call	Write_Capture		;Write Capture buffer.
Finish:
	cmp	Run_Mode, 0		;Running as .EXE file?
	jnz	Strategy		;Skip if so.
	cmp	Error_Code, 0		;Check error status.
	lds	bx, Packet_Ptr		;DS:BX -> Request packet
	jnz	Driver_Error		;Skip if any error occurred.
	mov	ax, 0100h		;Set driver return status
					; (request complete, no error)
	jmp	Set_Driver_Size

Driver_Error:
	mov	ax, 1			;Signal CONFIG.SYS error
	mov	[bx + 23], ax
	mov	ax, 810Ch		;Set driver return status.
					; (request complete, error 0Ch)
Set_Driver_Size:
	mov	[bx + 3], ax		;Store return status in packet.
	xor	ax, ax			;Set end of driver=beginning.
	mov	[bx + 14], ax		;Net effect: Driver size is 0 bytes,
	mov	[bx + 16], cs		;  so DOS doesn't install driver.
All_Done:
	pop	di			;Restore saved registers
	pop	si			;from local stack.
	pop	dx
	pop	cx
	pop	bx
	pop	ax
	pop	ds
	pop	es
	cli				;Restore DOS stack.
	mov	sp, cs:Old_Stack_Off
	mov	ss, cs:Old_Stack_Seg
	sti
	popf				;Restore AX and flags from DOS stack.
	pop	ax
Strategy:				;Device Driver "strategy" entry point.
	retf				;Driver is invoked by a FAR call from
					;DOS.

;-------------------------
;Write capture buffer to specified file
;Creates or appends to capture file as indicated by the Append flag.
;INPUT: None
;OUTPUT: Error_Code set appropriately if error occurred.
;Destroys ax, bx, cx, dx
;-------------------------
Write_Capture	PROC

	test	Switch_Byte, APPEND	;Append flag set?
	jz	Create_File		;Skip if not (try to create file).
	mov	dx, FILE_SPEC		;DS:DX -> filespec.
	mov	ax, 3D01h		;Request write access.
	int	21h			;Open file.
	jc	Create_File		;Skip if open failed.
	mov	bx, ax			;BX = file handle.
	mov	ax, 4202h		;Move file pointer relative to EOF.
	xor	cx, cx			;DX:CX = pointer offset; using 0
	xor	dx, dx			;  puts pointer at end of file.
	int	21h
	jc	Write_Error		;Skip if function call failed.
	mov	dx, SEPARATOR		;Append separator to file.
	mov	cx, SEP_LEN
	call	Write_Device
	jc	Write_Error		;Close file and report error if necessary.
	jmp	Write_Screen

Create_File:
	mov	dx, FILE_SPEC		;Create the output file.
	mov	cx, 20h			;Set archive attribute.
	mov	ah, 3Ch 		;DOS create function truncates file
	int	21h			; to 0	bytes if it already exists.
	jnc	Create_Ok		;Skip if create succeeded.
	mov	Error_Code, 2		;Otherwise set exit code
	jmp	No_Write		; and return to caller.
Create_Ok:
	mov	bx, ax			;BX = file handle.
Write_Screen:
	mov	dx, Data_Start		;Point start of screen data.
	mov	cx, Buf_Size		;Number of bytes to write.
	call	Write_Device
	jc	Write_Error		;Skip if error on write.
	test	Switch_Byte, FORMFEED	;Add a form feed?
	jz	Close_File		;Skip if not.
	lea	dx, FF_Char		;Point to formfeed character.
	mov	cx, 1			;One byte to write.
	call	Write_Device		;Write it.
	jnc	Close_File		;Done if no error.
Write_Error:
	mov	Error_Code, 3		;Otherwise set exit code.
Close_File:
	mov	ah, 3Eh			;Close output file.
	int	21h
No_Write:
	ret

Write_Capture	ENDP

;-------------------------
;Write to file or device.
;INPUT: BX = file handle
;	DS:DX -> data to write.
;	CX = # of bytes to write.
;OUTPUT:AX = # of bytes written.
;	Carry flag set if:
;	   1. INT 21h fails completely.
;	   2. Fewer bytes written than requested
;-------------------------
Write_Device	PROC

	mov	ah, 40h 	;INT 21h function number.
	int	21h		;Perform write.
	jc	Write_Done	;Done if function call failed.
	cmp	ax, cx		;Set carry if less written than requested.
Write_Done:
	ret

Write_Device	ENDP


;-------------------------
;Get video configuration.
;INPUT: None
;RETURNS: Current video mode in AL; 255 if mode not recognized.
;Note: This routine is based on the sample code included with Microsoft
;	MASM 6.1. However, I have modified it to correct a couple of
;	oversights. In particular, the original routine does not set
;	the video segment address properly for 43- and 50-line screen
;	modes when the current display page is other than page 0.
;Destroys bx, cx, dx
;-------------------------

Get_Vid_Config	PROC

	mov	ax, 1A00h		;Get video info for VGA
	int	10h
chkVGA:
	cmp	al, 1Ah			;Is VGA or MCGA present?
	jne	chkEGA			;No?  Then check for EGA
	cmp	bl, 2			;If VGA exists as secondary adapter,
	je	isCGA			;check for CGA and mono as primary
	jb	isMONO
	cmp	bl, 5			;If EGA is primary, do normal
	jbe	chkEGA			;EGA checking
chkMCGA:
	mov	Vid_Adapter, MCGA	;Yes?  Assume MCGA
	mov	Vid_Display, COLOR
	cmp	bl, 8			;Correct assumption?
	ja	gotmode			;Yes?  Continue
isVGA:
	mov	Vid_Adapter, VGA	;Assume it's VGA color
	je	gotmode			;Yes?  Continue
	mov	Vid_Display, MONO	;No?  Must be VGA mono
	jmp	gotmode			;Finished with VGA, so jump
chkEGA:
	mov	ah, 12h			;Call EGA status function
	mov	bl, 10h
	sub	cx, cx			;Clear status bits
	int	10h
	jcxz	chkCGA			;If CX is unchanged, not EGA
isEGA:
	mov	Vid_Adapter, EGA	;Set structure fields for EGA
	mov	Vid_Display, MONO	;Assume EGA mono
	or	bh, bh			;Correct assumption?
	jnz	gotmode			;Yes?  Continue
	mov	Vid_Display, COLOR	;No?  Must be EGA color
	jmp	gotmode			;Finished with EGA, so jump
chkCGA:
	int	11h			;Get equipment list
	and	al, 30h			;If bits 4-5 set, monochrome
	cmp	al, 30h			;Monochrome text mode?
	je	isMONO			;Yes?  Continue
isCGA:
	mov	Vid_Adapter, CGA	;No?  Must be CGA
	mov	Vid_Display, COLOR
	jmp	gotmode
isMONO:
	mov	Vid_Adapter, MDA	;Set MONO
	mov	Vid_Display, MONO
gotmode:
	sub	ax, ax
	push	es
	mov	es, ax
	mov	al, es:[44Ah]		;Get number of display cols
	pop	es
	mov	Vid_Cols, al		;Store in structure
	mov	Vid_Rows, 25		;Assume 25 rows.
	mov	ah, 0Fh
	int	10h			;Get current mode
	mov	Vid_Mode, al		;Record mode
	mov	Vid_Page, bh		;  and current page
	cmp	Vid_Adapter, EGA	;EGA or VGA?
	jl	Set_Vid_Seg		;No?  Exit
	mov	ax, 1130h		;Yes?  Request character info
	sub	bh, bh			;Set BH to valid value
	push	bp			;Call alters ES and BP
	push	es
	int	10h			;Get number of rows/screen
	inc	dl
	mov	Vid_Rows, dl		;Keep in structure
	pop	es			;Restore ES and BP
	pop	bp
Set_Vid_Seg:
	mov	al, Vid_Display		;Multiply display value
	cbw				;  (which is either 0 or 1)
	mov	bx, 800h		;  by 800h, then add to B000h
	mul	bx			;  for segment address of
	add	ax, 0B000h		;  video buffer
	mov	Vid_Segment, ax 	;Save page 0 segment.
	cmp	Vid_Page, 0		;On page 0?
	jz	Get_Vid_Done		;No need to adjust segment if so,
	mov	al, Vid_Rows		;  otherwise get # of rows.
	mov	di, LINES		;Point to lookup table.
	mov	cx, 3			;3 items in table.
	repne	scasb			;Search table for line count.
	jz	Got_Size		;Skip if item found,
	mov	Vid_Mode, 255		;  otherwise signal invalid mode.
	jmp	Get_Vid_Done

Got_Size:
	sub	di, LINES + 1		;Get table byte offset.
	add	di, di			;Convert to word offset.
	mov	bx, Sizes[di]		;BX = page size
	mov	al, Vid_Page		;AL = page number
	cbw				;AX = page number
	mul	bx			;AX = page segment adjustment.
	add	Vid_Segment, ax 	;Apply segment adjustment.
Get_Vid_Done:
	mov	al, Vid_Mode		;Return detected mode in AL
	ret

Get_Vid_Config	ENDP

;-----------------------------
;Copy command line parameters to the work buffer
;INPUT: None
;OUPUT: None
;Destroys ax, si, di
;-----------------------------
Copy_Parms	PROC
	push	ds

	mov	di, BUFFER_START	;ES:DI -> Work buffer.
	lds	si, Parm_Ptr		;DS:SI -> Command Line
Cmd_Loop:
	lodsb				;Read byte.
	cmp	al, 13			;Carriage return?
	jz	Cmd_Copied		;Done if so.
	cmp	al, 10			;Line feed?
	jz	Cmd_Copied		;Done if so.
	stosb				;Store byte
	jmp	Cmd_Loop		;and continue.

Cmd_Copied:
	xor	al, al			;Mark end of command line
	stosb				;with a NUL.

	pop	ds
	ret

Copy_Parms	ENDP

;----------------------------------
;Parse Command-line arguments
;INPUT: ES and DS must point to code segment.
;OUTPUT: Flags and filespec set according to command-line args.
;Destroys ax, bx, cx, si, di
;----------------------------------
Parse_Args	PROC

	mov	si, BUFFER_START	;DS:SI -> work buffer.
	test	Run_Mode, HELP		;If running as .EXE, program name is
	jnz	No_Skip			;not included on command line.

Skip_Parm:
	call	Find_White		;Skip over current parameter
	jc	Parse_Args_Done		;Done if end of args reached.
No_Skip:
	call	Skip_White		;Skip whitespace between parms.
	jc	Parse_Args_Done		;Done if end of args reached.
Next_Parm:
	push	si			;Save position.
	cmp	BYTE PTR [si], '/'	;Is current char a slash?
	jz	Switch			;Skip if so. If not, assume it's
	mov	di, si			;a filespec & save start pos.
	call	Find_White		;Find end of string.
	mov	cx, si			;CX = end of string
	mov	si, di			;DS:SI = start of string.
	sub	cx, si			;CX = # of bytes to copy.
	cmp	cx, MAX_SPEC		;Check length of filespec.
	ja	Resume_Scan		;Skip if too big (use default).
	mov	di, FILE_SPEC		;ES:DI -> Filespec storage.
	rep	movsb			;Copy string
	xor	al, al			;Terminate with 0 byte.
	stosb
	jmp	Resume_Scan		;and continue.

Switch:
	lodsb				;Skip the '/'
	lodsb				;Get the switch character.
	cmp	al, 'a'			;Convert to uppercase
	jb	Not_Lower
	cmp	al, 'z'
	ja	Not_Lower
	sub	al, 20h
Not_Lower:
	mov	di, SWITCHES		;Point to table of switch letters.
	mov	cx, SWITCH_COUNT	;CX = # of valid switch chars.
	repne	scasb			;Search for switch in table.
	jnz	Resume_Scan		;Ignore switch if not found.
	sub	di, SWITCHES + 1	;Get offset into character table.
	mov	cx, di			;CL = switch number.
	mov	ch, 1			;CH = bit 0 set.
	shl	ch, cl			;Shift bit into proper position.
	or	Switch_Byte, ch		;Combine with other switches.
Resume_Scan:
	pop	si			;Restore position.
	jmp	Skip_Parm		;Continue scanning.

Parse_Args_Done:
	mov	al, Switch_Byte		;Get switches.
	and	al, Run_Mode		;Mask help bit with run mode.
	or	Switch_Byte, al		;and store it.
	ret

Parse_Args	ENDP

;-----------------------------------
;Find next whitespace character
;INPUT: DS:SI -> Buffer to scan, ES = DS
;OUTPUT: DS:SI -> First whitespace char
;	 Carry flag set if end of line encountered.
;Destroys ax, cx
;-----------------------------------
Find_White	PROC
	push	di

Find_White_Loop:
	lodsb				;Get character.
	or	al, al			;NUL?
	jz	Find_White_Error	;Error if so.
	mov	di, WHITE_SPACE		;Is it whitespace?
	mov	cx, NUM_WHITE
	repnz	scasb
	jz	Find_White_Exit		;Done if so.
	jmp	Find_White_Loop		;Keep looking if not.

Find_White_Error:
	stc				;Set error status.
Find_White_Exit:
	dec	si			;Adjust position.

	pop	di
	ret

Find_White	ENDP

;-------------------------------------
;Find next non-whitespace character
;INPUT: DS:SI -> Buffer to scan, ES = DS
;OUTPUT: DS:SI -> First non-whitespace character
;	 Carry flag set if end of line encountered.
;Destroys ax, cx
;-------------------------------------
Skip_White	PROC
	push	di

Skip_White_Loop:
	lodsb				;Get character.
	or	al, al			;End of line?
	jz	Skip_White_Err		;Error if so.
	mov	di, WHITE_SPACE		;Is it whitespace?
	mov	cx, NUM_WHITE
	repnz	scasb
	jz	Skip_White_Loop		;Keep looking if so.
	clc				;Otherwise, clear error status
	jmp	Skip_White_Done		;and exit.

Skip_White_Err:
	stc				;Set error status.
Skip_White_Done:
	dec	si			;Adjust position.
	pop	di
	ret

Skip_White	ENDP

;------------------------------
;Copy contents of screen to work buffer.
;INPUT: ES = DS
;OUTPUT: Screen text in buffer.
;Destroys ax, bx, cx, dx, si, di
;------------------------------
Grab_Screen	PROC
	push	ds			;Save DS

	mov	bl, Switch_Byte		;BL = switches flag.
	or	bl, ALL_BLANK		;Set "all blank" bit.
	mov	di, LAST_BYTE		;ES:DI -> End of storage buffer.
	mov	dl, Vid_Cols		;DL = # of columns.
	mov	dh, Vid_Rows		;DH = # of rows.
	mov	al, dl			;AX = # of columns.
	mul	dh			;AX = # of characters.
	dec	ax			;AX = # of characters - 1
	add	ax, ax			;AX = # of words - 1
	mov	ds, Vid_Segment		;DS:SI -> last word in video buffer.
	mov	si, ax			;
	std				;String instructions backward.

Grab_Row:
	mov	cl, dl			;CL = # of chars in row.
	or	bl, ROW_BLANK		;Set "blank row" bit.
	test	bl, VERBATIM		;Verbatim mode?
	jnz	No_CR			;Skip if so,
	mov	al, 0Ah 		;otherwise put CR/LF at end of line.
	stosb
	mov	al, 0Dh
	stosb
No_CR:
	lodsw				;Get screen char.
	test	bl, VERBATIM		;Verbatim mode?
	jnz	Store_It		;Skip if so.
	cmp	al, ' '			;Compare to a space.
	jb	Translate		;Handle control char.
	ja	Non_Blank		;Handle non-space.
	test	bl, ROW_BLANK		;Found anything but spaces yet?
	jnz	Next_Char		;Keep scanning if so.
	jmp	Store_It		;Store character if not.
Translate:
	mov	al, '.' 		;Change to "." if not.
Non_Blank:
	and	bl, TRIM + VERBATIM	;Clear blank row/all blank bits,
					;preserve trim/verbatim bits.
Store_It:
	stosb				;Save char in our buffer.
Next_Char:
	dec	cl
	jnz	No_CR			;Continue with next character.
	test	bl, VERBATIM		;Verbatim mode?
	jnz	Next_Row		;Skip if so.
	test	bl, TRIM		;Trimming CRs?
	jz	Next_Row		;Skip if not?
	test	bl, ALL_BLANK		;All lines blank so far?
	jz	Next_Row		;Skip if not,
	inc	di			; otherwise remove trailing CR/LF.
	inc	di
Next_Row:
	dec	dh			;Check line count.
	jnz	Grab_Row		;Repeat for each line.

	pop	ds			;Restore DS
	mov	ax, LAST_BYTE		;AX = end of buffer.
	sub	ax, di			;AX = # chars in buffer.
	inc	di			;DI -> first char in buffer.
	mov	Buf_Size, ax		;Set buffer size
	mov	Data_Start, di		;Set start of data.
	cld				;String instructions forward.
	ret

Grab_Screen	ENDP

;------------------------------------
;Clear screen using attribute at current cursor position
;INPUT: NONE
;OUTPUT: NONE
;Destroys ax, bx, cx, dx
;------------------------------------
Clear_Screen		PROC

	mov	bh, Vid_Page	;Get current page in BH
	mov	ah, 08h		;Get attribute at cursor
	int	10h
	mov	bh, ah		;BH = attribute.
	mov	ax, 0600h	;BIOS clear/scroll.
	xor	cx, cx		;Set window size from 0, 0
	mov	dh, Vid_Rows	;to end of screen.
	mov	dl, Vid_Cols
	dec	dh		;Adjust row & column to zero offset.
	dec	dl
	int	10h
	mov	bh, Vid_Page	;BH = video page.
	xor	dx, dx		;Move cursor to 0, 0.
	mov	ah, 02h
	int	10h
	ret
Clear_Screen		ENDP

myseg		ENDS

stackseg	SEGMENT PARA STACK 'STACK'	;Stack segment for .EXE mode.
		DB	32 DUP ("Stack   ")
stackseg	ENDS

		END	Main			;Entry point for .EXE mode.
