
#include <stdio.h>
#include <conio.h>
#include <windows.h>
#include <process.h>
#include <winsock.h>
#include "telopts.h"

// ascii definitions

#define ASCII_BEL       0x07
#define ASCII_BS        0x08
#define ASCII_LF        0x0A
#define ASCII_CR        0x0D

int ParseTelnetData (char* pData, int Size, SOCKET s);
int sendn (SOCKET socket, char *ptr, int nbytes);
int KeyBoardThread (SOCKET s);

char IPAddressStr[50];
char InBuff[1024*64];


int main (int argc, char *argv[])
{
	WSADATA		wsaData;
	WORD		wVersion = MAKEWORD(1,1);
	PHOSTENT	ph;
	SOCKET		s;
	SOCKADDR_IN	ServerAddr;
	int			rc, cnt=1;

	if (argc != 2)
	{
		printf ("Usage: zantel <host name>\n");
		exit(1);
	}

	// Start Windows Sockets

 	WSAStartup(wVersion, &wsaData);

	// Get IP Address

	if (!(ph = gethostbyname (argv[1])))
	{
		printf ("Can't get host: %s\n", argv[1]);
		exit(1);
	}

	// Open and Bind a Socket

	if ((s = socket (AF_INET, SOCK_STREAM, IPPROTO_TCP)) < 0)
	{
        printf ("Socket Error\n");
		exit(-1);
	}

	memset ((char *)&ServerAddr, 0, sizeof(ServerAddr));

	ServerAddr.sin_family = AF_INET;
    ServerAddr.sin_addr.s_addr = htonl(INADDR_ANY);
    ServerAddr.sin_port = 0;

	rc = bind (s, (struct sockaddr *)&ServerAddr, sizeof(ServerAddr));

	// Connect to UNIX

	ServerAddr.sin_family= AF_INET; 
	
    ServerAddr.sin_addr.S_un.S_un_b.s_b1 = ph->h_addr[0];
    ServerAddr.sin_addr.S_un.S_un_b.s_b2 = ph->h_addr[1];
    ServerAddr.sin_addr.S_un.S_un_b.s_b3 = ph->h_addr[2];
    ServerAddr.sin_addr.S_un.S_un_b.s_b4 = ph->h_addr[3];

	// Port 23 is for Telnet

    ServerAddr.sin_port= htons(23);

	if ((rc = connect (s, (struct sockaddr *)&ServerAddr, sizeof(ServerAddr))) < 0)
	{
		printf ("Connect Error\n");
		exit(-1);
	}

	// Create an input thread

	DWORD dwThreadID;

	HANDLE hThread = CreateThread (NULL, 0, (LPTHREAD_START_ROUTINE)KeyBoardThread, 
			(void *)s, 0, &dwThreadID);

	// Enter receive loop

	while (cnt && (cnt != SOCKET_ERROR))
	{
		cnt = recv (s, InBuff, sizeof(InBuff), 0);

		ParseTelnetData (InBuff, cnt, s);
	}

	return 0;
}


//
// KeyBoardThread 
//
int KeyBoardThread (SOCKET s)
{
	char ch;

	while (ch = _getch())
	{
		if (ch == 0x1b)
		{
			closesocket (s);
			WSACleanup();
			ExitProcess (0);
		}
		send (s, &ch, 1, 0);
	}

	return 0;
}


UCHAR	ucIAC = 0;
UCHAR	ucTelnetCommand = 0;

//
// ParseTelnetData 
//
int ParseTelnetData (char* pData, int Size, SOCKET s) 
{
	UCHAR	*p = (UCHAR *)pData;
	char	OutBuf[256];
	int		iTelData = 0;

	if (!Size || (Size == SOCKET_ERROR))
		return -1;

	for (int i=0; i<Size; i++, p++)
	{
		// Process command option

		if (ucTelnetCommand)
		{
			switch (ucTelnetCommand)
			{
			case DOTEL:
			{
				// The ONLY thing we will DO is suppress go ahead (SGA). All
				// other requests we return with WONTTEL!

				switch (*p)
				{
				case SGA:
					break;
				default:
				{
					sprintf (OutBuf, "%c%c%c", IAC, WONTTEL, *p);

					int sent = sendn (s, OutBuf, strlen(OutBuf));

					if (sent != (int)strlen(OutBuf))
						return -1;
					break;
				}
				}
				break;
			}
			case DONTTEL:
			case WILLTEL:
			case WONTTEL:
				break;
			}
			ucTelnetCommand = 0;
		}

		// Process command

		else if (ucIAC)
		{
			if (*p != IAC)
			{
				// Handle commands without options

				switch (*p)
				{
				// case EL:        /* received a telnet erase line command */
                // case EC:        /* received a telnet erase character command */
                // case AYT:       /* received a telnet Are-You-There command */
                // case AO:        /* received a telnet Abort Output command */
                // case IP:        /* received a telnet Interrupt Process command */
                // case BREAK:     /* received a telnet Break command */
                // case DM:        /* received a telnet Data Mark command */
                // case NOP:       /* received a telnet No Operation command */
                // case SE:        /* received a telnet Subnegotiation End command */
                // case ABORT:     /* received a telnet Abort Process command */
                // case SUSP:      /* received a telnet Suspend Process command */
                // case TEL_EOF:   /* received a telnet EOF command */
                // case GOAHEAD:   /* telnet go ahead option*/
				// case SB:
				case DOTEL:
				case DONTTEL:
				case WILLTEL:
				case WONTTEL:
					ucTelnetCommand = *p;	// Process later
					break;
				default:
					break;
				}
			}
			ucIAC = 0;
		}

		// Look for IAC escape char

		else if (*p == IAC)	
		{
			ucIAC = IAC;
		}

		// All other characters

		else
		{
			// Is it alpha-numeric?

			if ((*p >= 0x20 && *p <= 0x7E) || *p == ASCII_CR || 
				*p == ASCII_LF || *p == ASCII_BEL || *p == ASCII_BS)
			{
				putchar (*p);
			}
		}
	}

	return 0;
}


//
// sendn
//
int sendn (SOCKET socket, char *ptr, int nbytes)
{
	int	nleft, nwritten;

	nleft = nbytes;

	while (nleft > 0)
	{
		nwritten = send (socket, ptr, nbytes, 0);

		if (nwritten <= 0)			/* error */
		{
			return nwritten;
		}

		nleft -= nwritten;
		ptr += nwritten;
	}
	return (nbytes - nleft);
}




























