/*
    DBGatewayService.cpp

    NOTE: This file is a generated file.
          Do not modify it by hand!
*/

#include "wpch.hpp"
#include "DBGatewayService.hpp"


// Code added here will be included at the top of the .CPP file

//  Include definitions for resources.
#include "WRes.h"
DBGatewayService::DBGatewayService()
{
    
}

void DBGatewayService::EchoFormData()
{
   
     printf("<H1>Query Results</H1>");
    printf("You submitted the following name/value pairs:<p>%c",10);
    printf("<ul>%c",10);

	   for(int idx=0; idx <= TotalEntries; idx++)
        printf("<li> <code>%s = %s</code> length of val %d%c",entries[idx].name,
               entries[idx].val,strlen(entries[idx].val),10);
    	printf("</ul>%c",10);
}        

WBool DBGatewayService::Initialize(WApplication *thisApp, WString DataSource,
                            WString UserID, WString Password)
    {
        /* init the dynamic members */
        thisTransaction = NULL;
        thisQuery = NULL;
        
        /* print out the Content header.. */
        
        cout << "Content-type: text/html\n\n";
        
        /* make sure this is only being used with POSTed forms */  
        if ((thisApp->GetEnvironmentVariable("REQUEST_METHOD")) != "POST")
            {
                cout << "<h2> This script should be referenced with a METHOD of POST."
                     << "If you don't understand this, see this</h2>"
                     << "a href=\"http://www.ncsa.uiuc.edu/SDG/Software/Mosaic/Docs/fill-out-forms/overview.html\">forms overview</a>" 
                     << endl;
                 return FALSE;    
            }      
        
        if ((thisApp->GetEnvironmentVariable("CONTENT_TYPE")) != "application/x-www-form-urlencoded")
            {
                cout << "<h2>This script can only be used to decode form results</h2>";
                    return FALSE;
            }        
                        

        /* initialize the content length instance variable */
         cl = ((thisApp->GetEnvironmentVariable("CONTENT_LENGTH")).ConvertToInteger());
       
         /* initialize the Query and Transaction information */
         thisTransaction = new WTransaction;
         
          if (thisTransaction->Create()) 
            {
                //printf("transaction created\n");
            
              /* initialize ODBC data... */        
                thisTransaction->SetDataSource(WTEXT(DataSource));   
                thisTransaction->SetUserid(WTEXT(UserID));
                thisTransaction->SetPassword(WTEXT(Password));       
                   
                if (!thisTransaction->Connect()) {
                    cout << "<h3> Error: Cannot Connect to " << DataSource
                         << " with thisTransaction. </h3>";
                      return FALSE;
                  }
                  
                /* everything ok.. create the Query object and
                   connect it to the Transaction object
                */
                thisQuery = new WQuery;

                if (!thisQuery->Create(thisTransaction)) 
                    {
                        cout << "<h3> Error: Cannot Create Query Object.</h3>";
                        return FALSE;
                    }    
         
            }
            
                   
        return TRUE;
    } 
    
    
WBool DBGatewayService::ProcessResults()
{
    WShort NumColumns;
    
    if (thisQuery)     /* Valid pointer? */
        {
              cout << "<H1>Query Results</H1>";
        
            /* loop through the columns and print the column
                headers
            */
        
            NumColumns = thisQuery->GetColumnCount();
            
            cout << "<TABLE BORDER><TR>" << endl ;
            
            for (int idx=1; idx <= NumColumns; idx++)
                cout << "<TH>" << (thisQuery->GetColumn(idx)).GetName();
                
             
            /* now print out the rows.. */ 
            while (thisQuery->MoveNext())
                {
                    /* loop over each column in the row
                       printing out the text
                       note: columns are numbered 0.. n
                       but column 0 is used for bookmarks
                    */
                     cout << "<TR><TR>";
                  
                    for (int idx = 1; idx <= NumColumns; idx++)
                        {
                            (thisQuery->GetValue(idx)).GetValue(ColumnValue);
                            cout << "<TD>" << ColumnValue << endl;
                        }
                      
                }
                
              cout << "</TABLE><P>";    
        }
        
    
    return TRUE;
}    
    
    
WBool DBGatewayService::ExecuteSQL()
{
    if (thisQuery)
        {
            /* Add the SELECT.. boy do I love C++ for this... */
            QueryString = "SELECT " + QueryString;
            
          /* specify the SQL stmt for this query object */   
          if (!thisQuery->SetSQL(QueryString))
            {
                cout << "<h3> Error: Cannot Associate SQL with Query Object. </h3>";
                return FALSE;
            }    
              
          if (!thisQuery->Open())
            {
                cout << "<h3> Error: Cannot Execute SQL. </h3>";
                return FALSE;
            }    
        } 
    else
        {
            cout << "<h3> Error: Invalid Query Object. </h3>";
            return FALSE;
        }    
   
   return TRUE;
}                
    
DBGatewayService::LoadFormData(FILE *stdinput)
{
    int idx;
    
      /* parse out the form variables */
    for(idx=0;cl && (!feof(stdinput));idx++) 
        {
            TotalEntries=idx;
            entries[idx].val = CGILib::fmakeword(stdinput,'&',&cl);
            CGILib::plustospace(entries[idx].val);
            CGILib::unescape_url(entries[idx].val);
            entries[idx].name = CGILib::makeword(entries[idx].val,'=');
        }   
}      


WBool DBGatewayService::BuildSelectList()
{
    int idx;
     /* build select String here */
            
        for (idx=0; idx <= TotalEntries; idx++)
           {
              /* build select list based upon checked form items */
                if (strstr(entries[idx].name, "Check"))
                    QueryString = QueryString + entries[idx].val + ", ";
           }
                
            /* error check here */               
            if (QueryString == "SELECT ") {
                 cout << "<p><h3>Must select at least one column</h3>";
                 return FALSE;
               } 
             else
                {
                    /* get rid of the trailing comma */
                    QueryString = QueryString.Left(QueryString.GetLength()-2);
                }    
                
               QueryString = QueryString + " FROM AddressBook ";
               
            return TRUE;
}    

DBGatewayService::BuildCriteriaClause()
{
    int idx;
    
      for (idx=0; idx <= TotalEntries; idx++)
        {
           /* build where clause based upon what's
              been entered
           */
           if (strcmp(entries[idx].val, "") && !strstr(entries[idx].name, "Check_")) 
                {
                  /* find the location of 'where' in selectlist */
                     if (strstr(WhereClause.GetAnsiText()," WHERE "))
                         Conjunction = " AND ";
                     else 
                         Conjunction = " WHERE "; 
                              
                    WhereClause = WhereClause + Conjunction + entries[idx].name + " "+
                          " LIKE " + "'" + entries[idx].val 
                          + "%'";
                }
        }
        
      QueryString = QueryString + WhereClause;  
    
}    

WString DBGatewayService::GetQueryString()
{
    return QueryString;
}    
DBGatewayService::~DBGatewayService()
{
      /* do some cleanup... */
    if (thisQuery)
        {
           thisQuery->Destroy();
           delete thisQuery;
           thisQuery=NULL;
        }
        
    if (thisTransaction)
        {
            thisTransaction->Destroy();
            delete thisTransaction;
            thisQuery=NULL;
        }    
  
}
