/*
    TRYQSORT.C  Demonstrates use of the library
                routine 'qsort' to sort strings.

    Ray Duncan * PC Magazine May 1988
*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#define ITEM_LENGTH 80              /* max string length */
#define N_ITEMS     25              /* max number of strings */
                                    /* strings stored here */
static char items[N_ITEMS * ITEM_LENGTH];

main(int argc, char *argv[])
{
    int i, j;                       /* some scratch variables */

    while(1)                        /* get strings & sort them */
    {
        puts("\nEnter strings to be sorted...");
        i = 0;                      /* initialize string count */
        while(i < N_ITEMS)          /* enforce maximum entries */
        {
            printf("%2d: ", i+1);   /* prompt user */
                                    /* read the keyboard */
            gets(&items[ITEM_LENGTH * i]);
                                    /* last entry if empty line */
            if(items[ITEM_LENGTH * i] == 0) break;
            i++;                    /* bump string counter */
        }
        if(i==0) exit(0);           /* if no strings exit */
                                    /* sort the strings */
        qsort(items, i, ITEM_LENGTH, strcmp);
        puts("\nHere are the sorted strings...");
        j = 0;                      /* initialize string counter */
        while (j < i)               /* display sorted strings */
        {
            printf("%2d: %s\n", j+1, &items[ITEM_LENGTH * j]);
            j++;                    /* bump string counter */
        }
    }
}
