//  ____________________________________________________
// |                                                    |
// |  Project:     POWER VIEW INTERFACE                 |
// |  File:        PVTABLE.CPP                          |
// |  Compiler:    WPP386 (10.6)                        |
// |                                                    |
// |  Subject:     Tables support implementation        |
// |                                                    |
// |  Author:      Emil Dotchevski                      |
// |____________________________________________________|
//
// E-mail: zajo@geocities.com
// URL:    http://www.geocities.com/SiliconValley/Bay/3577

#define uses_stdio
#define uses_string
#define uses_icons
#define uses_check
#define uses_dc
#define uses_desk
#define uses_dialog
#define uses_label
#define uses_list
#define uses_system
#define uses_stddlg
#define uses_table
#define uses_win

#define DECLARE_PVTABLE_H
#include "PVuses.h"
#undef  DECLARE_PVTABLE_H

#define cmTABLE_UPDATE    cmUSER99

static Ttable_data *data_ptr;
static boolean dialog_table_fl = 0;


//Ttable_iterator publics:

Ttable_iterator::Ttable_iterator( int _xl, int _yl ):
  Titem( _xl, _yl ),
  h_beg_print( _h_beg_print ),
  h_size( _h_size ),
  h_count( _h_count ),
  h_current( _h_current ),
  v_beg_print( _v_beg_print ),
  v_count( _v_count ),
  v_current( _v_current )
{
  grow_mode = gmGROW_BOTH;
  h_beg_print=h_count=h_size=h_current=v_beg_print=v_count=v_current=hsel_org=vsel_org=0;
#ifndef NOMOUSE
  set_events_mask( evMOUSE_REP, 1 );
#endif
  set_flags( tfDOUBLE_CLICK_OK|tfWHOLE_LINES, 1 );
}

Ttable_iterator::Ttable_iterator( int _xl, int _yl,
                                  uint &hsize,
                                  uint &hbeg_print, uint &hcount, uint &hcurrent,
                                  uint &vbeg_print, uint &vcount, uint &vcurrent ):
  Titem( _xl, _yl ),
  h_beg_print( hbeg_print ),
  h_size( hsize ),
  h_count( hcount ),
  h_current( hcurrent ),
  v_beg_print( vbeg_print ),
  v_count( vcount ),
  v_current( vcurrent )
{
  grow_mode = gmGROW_BOTH;
  h_beg_print=h_count=h_size=h_current=v_beg_print=v_count=v_current=hsel_org=vsel_org=0;
#ifndef NOMOUSE
  set_events_mask( evMOUSE_REP, 1 );
#endif
  set_flags( tfDOUBLE_CLICK_OK|tfWHOLE_LINES, 1 );
}

void Ttable_iterator::redraw( void )
{
  Titem::redraw();
  if( owner != NULL ) owner->redraw();
}

void Ttable_iterator::set_title( char *title )
{
  if( ( owner == NULL ) || ( owner->owner == NULL ) ) return;
  ((Twindow *) owner->owner)->set_title( title );
#ifdef TABLEINFO
  if( !owner->flags(tfDIALOG) && current_table==owner )
    ((Twindow *) table_info->owner)->set_title( title );
#endif
}

void Ttable_iterator::left( void )
{
  if( !h_current ) return;
  h_current--;
  uint n=0,w=0;
  for( Ttable_data *d=data;
       d!=NULL && n<h_current && w<h_beg_print;
       n++,w+=d->width+1,d=d->nextc );
  if( w<h_beg_print ) h_beg_print -= h_beg_print-w;
}

void Ttable_iterator::right( void )
{
  if( h_current>=h_count-1 ) return;
  h_current++;
  int n=0,w=0;
  for( Ttable_data *d=data;
       d!=NULL && n<=h_current;
       n++,w+=d->width+1,d=d->nextc );
  w -= xl+1;
  if( w<0 ) return;
  if( h_beg_print<w ) h_beg_print += w-h_beg_print;
}

void Ttable_iterator::up( void )
{
  cursor_up_left( v_current, v_beg_print, yl, 2 );
}

void Ttable_iterator::down( void )
{
  cursor_down_right( v_current, v_beg_print, yl, v_count, 2 );
}

void Ttable_iterator::top( void )
{
  cursor_top_home( v_current, v_beg_print );
}

void Ttable_iterator::bottom( void )
{
  cursor_bottom_end( v_current, v_beg_print, yl, v_count );
}

void Ttable_iterator::at( uint i )
{
  cursor_at( i, v_current, v_beg_print, yl, v_count );
}

void Ttable_iterator::update_commands( void )
{
}

void Ttable_iterator::pgup( void )
{
  for( uint i = 1; i < yl; i++ ) up();
}

void Ttable_iterator::pgdn( void )
{
  for( uint i = 1; i < yl; i++ ) down();
}

//Ttable_iterator protected:

void Ttable_iterator::draw( void )
{
  uint row, col;
  char buf[256];
  Ttable_data *c;
  char ta;
  int l, i, j, rx, ry, rxl, ryl;
  get_clip_rect( rx, ry, rxl, ryl );
  int end=min(yl,ry+ryl);
  rxl+=rx;
  for( i=max(0,ry),row=v_beg_print+i; i<end; i++,row++ )
  {
    c = data;
    col = 0;
    j = -h_beg_print-1;
    while( c != NULL )
    {
      if( j>rxl ) break;
      if( c->where == whTABLE )
      {
        goto_xy( j, i ); j += c->width + 1;
        if( j>=rx )
        {
          txtf( "%c", frame_standard[3] );
          ta = text_attr;
          *buf = 0;
          if( row < v_count )
            fetch( buf, row, col, c->width );
          buf[c->width] = 0;
          if( ( l = c->width - strlen( buf ) ) < 0 ) l = 0;
          if( c->align == atRIGHT ) txtf( "|r%c ", l );
          direct_txt( buf );
          if( c->align == atLEFT ) txtf( "|r%c ", l );
          text_attr = ta;
        }
      }
      c = c->nextc; col++;
    }
    goto_xy( j, i ); txtf( "%c", frame_standard[3] );
  }
}

void Ttable_iterator::get_focused( void )
{
  Titem::get_focused();
  update_commands();
}

void Ttable_iterator::event_handler( Tevent &ev )
{
  uint vc=v_current, hc=h_current;
  Titem::event_handler( ev );
  if( state( isFOCUSED ) )
    switch( ev.code )
    {
      case evKEY_PRESS:
        switch( ev.ASCII )
        {
          case kUP: case kSHIFT_UP:
            up(); break;
          case kDOWN: case kSHIFT_DOWN:
            down(); break;
          case kPG_UP: case kSHIFT_PG_UP:
            pgup(); break;
          case kPG_DN: case kSHIFT_PG_DN:
            pgdn(); break;
          case kHOME: case kSHIFT_HOME:
            top(); break;
          case kEND: case kSHIFT_END:
            bottom(); break;
          default:
            if( flags(tfWHOLE_LINES) )
              goto not_handled;
            else
              switch( ev.ASCII )
              {
                case kLEFT: case kSHIFT_LEFT:
                  left(); break;
                case kRIGHT: case kSHIFT_RIGHT:
                  right(); break;
                default:
                  goto not_handled;
              }
        }
        if( (hc!=h_current || vc!=v_current) && !(get_shifts()&smSHIFT) )
          hsel_org=h_current, vsel_org=v_current;
        handled( ev ); redraw();
        item_acted = this;
      not_handled:
        break;
#ifndef NOMOUSE
      case evMOUSE_DOWN:
        if( ev.INSIDE )
        {
          uint i, j=(uint) -1;
          uint ih, jh=(uint) -1;
          do
          {
            boolean vinside = (ev.LOCAL_Y>=0 && ev.LOCAL_Y<yl);
            if( vinside || ev.code==evMOUSE_REP )
            {
              if( ev.LOCAL_Y >= 0 ) i = ev.LOCAL_Y; else i = 0;
              i = v_beg_print + i;
              if( !vinside )
              {
                if( i > v_current ) down(); else up();
                i = v_current;
              }
              if( i >= v_count ) i = v_count - 1;
              if( j != i )
              {
                v_current = i;
                if( ev.code==evMOUSE_DOWN ) vsel_org = v_current;
                redraw();
              }
              j = v_current;
            }
            if( !flags(tfWHOLE_LINES) )
            {
              boolean hinside = (ev.LOCAL_X>=0 && ev.LOCAL_X<xl);
              if( hinside || ev.code==evMOUSE_REP )
              {
                if( ev.LOCAL_X >= 0 ) ih = ev.LOCAL_X; else ih = 0;
                ih = h_beg_print + ih;
                int xx=0, n=0;
                for( Ttable_data *d=data; d!=NULL; xx+=d->width+1,d=d->nextc,n++ )
                  if( xx+d->width>ih ) break;
                ih = n;
                if( !hinside )
                {
                  if( ih > h_current ) right(); else left();
                  ih = h_current;
                }
                if( ih >= h_count ) ih = h_count - 1;
                if( jh != ih )
                {
                  h_current = ih;
                  if( ev.code==evMOUSE_DOWN ) hsel_org = h_current;
                  redraw();
                }
                jh = h_current;
              }
            }
            if( ev.CLICKS && flags(tfDOUBLE_CLICK_OK) && ev.INSIDE &&
                (v_beg_print+ev.LOCAL_Y <= v_count) )
            {
              put_command( NULL, cmOK );
              break;
            }
          }
          while( get_mouse( ev, evMOUSE_REP|evMOUSE_DRAG ) );
          item_acted = this;
          handled( ev );
        }
#endif
    }
}

void Ttable_iterator::drop( void *data )
{
  if( owner != NULL ) owner->drop( data );
}


//Tlist_iterator publics:

Tlist_iterator::Tlist_iterator( int _xl, int _yl ):
  Ttable_iterator( _xl, _yl,
                   _hsize,
                   _hbeg_print, _h_count, _h_current,
                   _vbeg_print, _vcount, _vcurrent ),
  Tlb_list( _vcount, _vcurrent, _vbeg_print, yl,
            _hsize, _hbeg_print, xl )
{
}

Tlist_iterator::Tlist_iterator( int _xl, int _yl, Tlb_list *_list ):
  Ttable_iterator( _xl, _yl,
                   _list->_hsize, _list->_hbeg_print,
                   _h_count, _h_current,
                   _list->_vbeg_print, _list->_vcount, _list->_vcurrent ),
  Tlb_list( _list )
{
}


//Ttable

static void dispose_table_data( Ttable_data *t )
{
  if( t == NULL ) return;
  if( t->nested != NULL ) dispose_table_data( t->nested );
  dispose_table_data( t->next );
  FREE( t->title );
  FREE( t );
}

static void transfer( Ttable_data *t )
{
  if( t == NULL ) return;
  t->where = t->parent->where;
  if( t->nested != NULL ) transfer( t->nested );
  transfer( t->next );
}

static void fix_parent( Ttable_data *t )
{
  Ttable_data *p;
  boolean table_ok = 0;
#ifdef TABLEINFO
  boolean info_ok = 0;
#endif

  t = t->parent->nested;
  p = t;
  while( p != NULL )
  {
    if( p->where == whTABLE ) table_ok = 1;
#ifdef TABLEINFO
    if( p->where == whINFO  ) info_ok = 1;
#endif
    p = p->next;
  }
  t = t->parent;
  if( t->parent == NULL ) return;
  if( table_ok )
    if( t->where == whTABLE )
      return;
    else
      t->where = whTABLE;
#ifdef TABLEINFO
  else
    if( info_ok )
      t->where = whINFO;
    else
      t->where = whMUTE;
#endif
  fix_parent( t );
}

static void move_info( Ttable_data *t, int where  )
{
  t->where = where;
  if( t->nested != NULL ) transfer( t->nested );
  fix_parent( t );
}

static void get_item( Ttable_data *t, char *s )
{
  if( t->parent->parent != NULL )
  {
    get_item( t->parent, s );
    strcat( s, "/" );
  }
  strcat( s, t->title );
}

void full_title( Ttable_data *t, char *result )
{
  *result = 0;
  get_item( t, result );
}

static void calc_depth( Ttable_data *t )
{
  Ttable_data *p;

  while( t != NULL )
  {
    t->depth = 1;
    if( t->nested != NULL ) calc_depth( t->nested );
    p = t->parent;
    if( t->depth >= p->depth ) p->depth = t->depth + 1;
    t = t->next;
  }
}


//Ttable publics:

#ifdef TABLEINFO
static int open_tables_num=0;
#endif

Ttable::Ttable( Ttable_data *_data, Ttable_iterator *_iterator ):
  Titem( _iterator->xl, 1 )
{
  Tfile_window *win;
  Ttable_data *t;
  uint width;

  set_flags( tfDIALOG, dialog_table_fl );
#ifdef TABLEINFO
  if( !flags(tfDIALOG) && !open_tables_num++ && table_info!=NULL )
    table_info->owner->set_state( isHIDDEN, 0 );
#endif
  data = _data;
  iterator = _iterator;
  title_vtab = 0;
  calc_depth( data->nested );
  first_col = data;
  while( first_col->nested != NULL ) first_col = first_col->nested;
  iterator->data = first_col;
  title_cols = 0;
  width = (uint) -1;
  t = first_col;
  while( t != NULL )
  {
    title_cols++;
    width += t->width;
    t = t->nextc;
  }
  width += title_cols;
  title_rows = data->depth - 1;
  drop_id = (long) this;
#ifndef NOMOUSE
  set_events_mask( evMOUSE_REP, 1 );
#endif
  grow_mode = flags(tfDIALOG)? gmDONT_GROW : gmGROW_BOTH;
  if( __pure_table() )
  {
    iterator->set_state( isON_TOP, 1 );
    resize( iterator->xl, title_rows+iterator->yl );
    vbar = NEW( Tvscroll_bar( yl, iterator->v_count, iterator->v_beg_print ) );
      vbar->set_flags( sfHIDEABLE, 1 );
      vbar->set_flags( sfHANDLE_KEYBOARD, 0 );
      vbar->delta = -title_rows;
      vbar->set_state( isHIDDEN, 0 );
      put_in( vbar, xl, 0 );
    hbar = NEW( Thscroll_bar( xl, iterator->h_size, iterator->h_beg_print ) );
      hbar->set_flags( sfHIDEABLE+sfHANDLE_KEYBOARD, 1 );
      put_in( hbar, 0, yl );
  }
  else
  {
    iterator->resize( iterator->xl - i_sb_up_len - 1,
                      iterator->yl - 2 - title_rows );
    resize( iterator->xl, title_rows+iterator->yl );
    win = NEW( Tfile_window( iterator->h_beg_print, iterator->h_size,
                            iterator->v_beg_print, iterator->v_count,
                            0,
                            data->title, this ) );
    win->vbar->delta = -title_rows;
    win->hbar->set_flags( sfHANDLE_KEYBOARD, 1 );
    win->drop_id = (long) this;
    vbar = win->vbar;
    hbar = win->hbar;
  }
  put_in( iterator, 0, title_rows );
  iterator->drop_id = (long) this;
}

Ttable::~Ttable( void )
{
  dispose_table_data( data );
#ifdef TABLEINFO
  if( !flags(tfDIALOG) )
  {
    current_table = NULL;
    if( !--open_tables_num && table_info!=NULL )
      table_info->owner->set_state( isHIDDEN, 1 );
  }
#endif
}

void Ttable::resize( int _xl, int _yl )
{
  Ttable_data *t;
  int w, h, rh, rw, tmp;

  Titem::resize( _xl, _yl );
  w = 0; h = -1; iterator->h_count = 0;
  for( t=first_col; t!=NULL && ++iterator->h_count; t=t->nextc )
    if( t->where == whTABLE )
    {
      if( t->max_width > t->min_width )
        w += t->max_width;
      else
        h += t->width;
      h++;
    }
  iterator->h_size = h;
  if( w == 0 ) return;
  rh = xl - h;
  rw = w;
  iterator->h_size = (uint) -1;
  for( t=first_col; t!=NULL; t=t->nextc )
    if( t->where == whTABLE )
    {
      w = t->max_width; h = t->min_width;
      tmp = ( w*rh ) / rw;
      if( tmp<h ) tmp = h;
      if( tmp>w ) tmp = w;
      t->width = tmp;
      iterator->h_size += tmp+1;
    }
}

#ifdef TABLEINFO
void Ttable::redraw( void )
{
  Ttable_data *c;

  Titem::redraw();
  if( !flags(tfDIALOG) )
  {
    c = first_col;
    while( c != NULL )
    {
      if( c->where == whINFO )
      {
        table_info->redraw();
        return;
      }
      c = c->nextc;
    }
  }
}
#endif

uint Ttable::col_width( Ttable_data *t )
{
  uint n, width;

  if( t->nested == NULL )
    return t->width;
  else
  {
    width = 0; n = (uint)-1;
    t = t->nested;
    while( t != NULL )
    {
      if( t->where == whTABLE )
      {
        width += col_width( t );
        n++;
      }
      t = t->next;
    }
    return width + n;
  }
}

void Ttable::get_title( uint col, uint row, char *r )
{
  char s[256];
  Ttable_data *p, *t;
  int i, j;
  int rw;
  boolean fl;

  *r = 0; data_ptr = NULL;
  t = first_col;
  for( i = 2; i <= col; i++ ) t = t->nextc;
  rw = title_rows - row;
  i = 0; fl = 1;
  for( ;; )
  {
    i++;
    p = t->parent;
    rw -= ( p->depth - 1 - t->depth );
    if( i > rw ) break;
    if( p->nested != t ) fl = 0;
    t = p;
  }
  if( fl )
  {
    data_ptr = t;
    if( t->where != whTABLE ) return;
    p = t; while( p->parent != NULL ) p = p->parent;
    if( ( row != p->depth - t->depth ) ) *s = 0; else strcpy( s, t->title );
    i = col_width( t );
    if( strlen( s ) > i ) s[i] = 0;
    i -= strlen( s );
    j = i/2; i -= j;
    sprintf( r, "|b|r%c %s|r%c |1%c", j, s, i, frame_standard[3] );
  }
}

void Ttable::set_title_vtab( int _title_vtab )
{
  int delta;

  delta = title_vtab - _title_vtab;
  title_vtab = _title_vtab;
  vbar->delta = -( title_rows + title_vtab );
  if( iterator == NULL ) return;
  iterator->resize( iterator->xl, iterator->yl + delta );
  iterator->drag( iterator->x, iterator->y - delta );
}


//Ttable protected:

#ifdef TABLEINFO
void Ttable::get_focused( void )
{
  Titem::get_focused();
  if( !flags(tfDIALOG) )
  {
    current_table = this;
    ((Twindow *) table_info->owner)->set_title( ((Twindow *) owner)->title );
    table_info->owner->set_state( isHIDDEN, 0 );
  }
}

boolean Ttable::release_focus( void )
{
  if( Titem::release_focus() )
  {
    if( !flags(tfDIALOG) && state(isHIDDEN) )
    {
      table_info->owner->set_state( isHIDDEN, 1 );
      current_table=NULL;
    }
    return 1;
  }
  return 0;
}
#endif

void Ttable::draw( void )
{
  int row, col;
  char buf[256];

  for( row = 1; row <= title_rows; row++ )
  {
    goto_xy( -iterator->h_beg_print, ( row - 1 ) + title_vtab );
    for( col = 1; col <= title_cols; col++ )
    {
      get_title( col, row, buf );
      txt( buf );
    }
  }
}

#ifdef TABLEINFO
static char *drag_text;
static void Ttable_drag_draw( void )
{
  direct_txt( drag_text );
}
#endif

void Ttable::event_handler( Tevent &ev )
{
  Titem::event_handler( ev );
  switch( ev.code )
  {
#ifdef TABLEINFO
    case evCOMMAND:
      if( ev.CMD_CODE == cmTABLE_UPDATE )
      {
        handled( ev );
        resize( xl, yl );
      }
      break;
#endif
#if !defined( NOMOUSE ) && defined( TABLEINFO )
    case evMOUSE_DOWN:
      if( !flags(tfDIALOG) && ev.INSIDE && ev.LOCAL_Y<title_rows )
      {
        uint c;
        int n;
        Ttable_data *p;
        char s[256];

        c = 0; n = -iterator->h_beg_print;
        p = first_col;
        do
        {
          if( p == NULL ) return;
          c++;
          if( p->where == whTABLE )
          {
            n += p->width;
            n++;
          }
          p = p->nextc;
        }
        while( n <= ev.LOCAL_X );
        n = ev.LOCAL_Y + 1 + title_vtab;
        if( n < 1 ) return;
        *s = 0;
        while( *s == 0 )
        {
          get_title( c, n, s );
          c--;
        }
        if( dont_touch( data_ptr ) ) return;
        drag_text = data_ptr->title;
        _drag_draw( strlen( drag_text ), 1, Ttable_drag_draw );
        pick_up( ev.GLOBAL_X, ev.GLOBAL_Y, (long) table_info, data_ptr );
        handled( ev );
      }
#endif
  }
}

#ifdef TABLEINFO
void Ttable::drop( void *_data )
{
  move_info( (Ttable_data *) _data, whTABLE );
  resize( xl, yl );
  redraw();
  table_info->redraw();
}

//Ttable private:

boolean Ttable::dont_touch( Ttable_data *t )
{
  char n;
  Ttable_data *p;

  t = t->parent;
  if( t == NULL ) return 1;
  n = 0;
  p = t->nested;
  while( p != NULL )
  {
    if( p->where == whTABLE ) n++;
      p = p->next;
  }
  if( n > 1 )
    return 0;
  else
    return dont_touch( t );
}
#endif


//Ttable_info


//Ttable_info publics:

#ifdef TABLEINFO
Ttable_info::Ttable_info( void ):
  Titem( desktop->xl-i_sb_up_len-1, 5 )
{
  Tfile_window *win;

  drop_id = (long) this;
  hbeg_print = 0;
  vbeg_print = 0;
  grow_mode = gmGROW_BOTH;
  win = NEW( Tfile_window( hbeg_print, hcount,
                           vbeg_print, vcount,
                           0,
                           NULL, this ) );
  win->set_flags( ifSELECTABLE+ifTILEABLE+ifCLOSEABLE, 0 );
  win->drop_id = (long) this;
  win->palette = wpTOOL;
  win->set_state( isHIDDEN, 1 );
  desktop->put_in( win, desktop->xl-win->xl, desktop->yl-win->yl );
}

Ttable_info::~Ttable_info( void )
{
  table_info=NULL;
}

//Ttable_info protected:

void Ttable_info::draw( void )
{
  Ttable_data *t;
  int row, col;
  uint hmax;
  char buf[256], at;

  if( current_table == NULL ) return;
  hcount = 0; vcount = 0;
  row = 0;
  hmax = 0;
  t = current_table->first_col;
  while( t != NULL )
  {
    if( t->where == whINFO )
    {
      vcount++;
      goto_xy( -hbeg_print, row++ - vbeg_print );
      draw_item( t );
      direct_txt( ": " );
      hcount += 2;
      if( hcount > hmax ) hmax = hcount;
      hcount = 0;
    }
    t = t->nextc;
  }
  if( current_table->iterator->v_current >=
      current_table->iterator->v_count ) return;
  hcount = hmax;
  row = col = 0;
  hmax = 0;
  t = current_table->first_col;
  while( t != NULL )
  {
    if( t->where == whINFO )
    {
      goto_xy( hcount - hbeg_print, row++ - vbeg_print );
      at = text_attr;
      current_table->iterator->fetch( buf, current_table->iterator->v_current, col, t->width );
      text_attr = at;
      if( strlen( buf ) > hmax ) hmax = strlen( buf );
      direct_txt( buf );
    }
    t = t->nextc; col++;
  }
  hcount += hmax;
}

static void get_depth( Ttable_data *p, int &x )
{
  if( p->parent->parent != NULL ) get_depth( p->parent, x );
  if( x < 0 ) return;
  if( x <= strlen( p->title ) ) data_ptr = p;
  x -= strlen( p->title ); x--;
}

void Ttable_info::event_handler( Tevent &ev )
{
  Ttable_data *t;
  int xx, yy;

  Titem::event_handler( ev );
  if( current_table == NULL ) return;
  switch( ev.code )
  {
    case evMOUSE_DOWN:
      if( ev.INSIDE )
      {
        t = current_table->first_col;
        yy = -vbeg_print;
        while( t != NULL )
        {
          if( t->where == whINFO )
          {
            if( yy == ev.LOCAL_Y )
            {
              xx = ev.LOCAL_X + hbeg_print;
              data_ptr = t; get_depth( t, xx );
              drag_text = data_ptr->title;
              _drag_draw( strlen( drag_text ), 1, Ttable_drag_draw );
              pick_up( ev.GLOBAL_X, ev.GLOBAL_Y, (long) current_table, data_ptr );
              break;
            }
            yy++;
          }
          t = t->nextc;
        }
        handled( ev );
      }
  }
}

void Ttable_info::drop( void *data )
{
  move_info( (Ttable_data *) data, whINFO );
  redraw();
  message( current_table, cmTABLE_UPDATE );
}

void Ttable_info::draw_item( Ttable_data *t )
{
  if( t->parent->parent != NULL )
  {
    draw_item( t->parent );
    direct_txt( "/" );
    hcount++;
  }
  txtf( "|b%s", t->title );
  hcount += strlen( t->title );
}
#endif


//Ttable_data interface functions

static char *current_title;
static Ttable_data *previous_data;
static Ttable_data *current_item;
static Ttable_data *current_parent;
static Ttable_iterator *table_iterator;

static Ttable_data *new_item( void )
{
  Ttable_data *p;

  p = NEW( Ttable_data );
  if( current_item != NULL )
    current_item->next = p;
  else
    if( current_parent != NULL ) current_parent->nested = p;
  current_item = p;
  current_item->next = NULL;
  current_item->parent = current_parent;
  current_item->where = whTABLE;
  current_item->nested = NULL;
  return p;
}

void construct_table( char *title, Ttable_iterator *iterator )
{
  table_iterator = iterator;
  current_title = title;
  previous_data = NULL;
  current_item = NULL;
  current_parent = NULL;
  subdata( title );
  dialog_table_fl = 0;
}

void dialog_table( char *title, Ttable_iterator *iterator )
{
  construct_table( title, iterator );
  dialog_table_fl = 1;
  _pure_table();
}

void subdata( char *t )
{
  Ttable_data *data;

  data = new_item();
  data->title = STRDUP( t );
  data->width = 0;
  data->depth = 0;
  data->min_width = 0;
  data->max_width = 0;
  data->nextc = NULL;
  data->old_parent = current_parent;
  data->old_item = current_item;
  current_parent = data;
  current_item = NULL;
}

Ttable *endt( void )
{
  Ttable_data *p;
  Ttable *t;
  Tbox *b;

  p = current_parent;
  current_item = current_parent->old_item;
  current_parent = current_parent->old_parent;
  if( current_parent != NULL ) return NULL;
  t = NEW( Ttable( p, table_iterator ) );
  if( dialog_table_fl )
  {
    t->vbar->set_state(isHIDDEN,0);
    b = NEW( Tbox( current_title, t ) );
    b->resize( b->xl-1, b->yl );
    t->put_in( b, -1, -1 );
    hspace(); vspace();
    put_item( t, b->xl, b->yl-1 );
    hspaces( -1 );
  }
  return t;
}

Ttable_data *tdata( char *t, uint _min, uint _max )
{
  Ttable_data *d;

  d = new_item();
  d->title = STRDUP( t );
  d->width = _max;
  d->min_width = _min;
  d->max_width = _max;
  d->align = atLEFT; if( __tright() ) d->align = atRIGHT;
  d->nextc = NULL;
  if( previous_data != NULL ) previous_data->nextc = d;
  previous_data = d;
  return d;
}

void move_table_data( Ttable *table, Ttable_data *data, char where )
{
  move_info( data, where );
#ifdef TABLEINFO
  table_info->redraw();
#endif
  message( table, cmTABLE_UPDATE );
}


//prefixes

static boolean pure_ = 0;
static boolean tright_ = 0;

void _pure_table( void )
{
  pure_ = 1;
}

boolean __pure_table( void )
{
  boolean result = pure_;
  pure_ = 0;
  return result;
}

void _tright( void )
{
  tright_ = 1;
}

boolean __tright( void )
{
  boolean result = tright_;
  tright_ = 0;
  return result;
}

//Initialization

void __init_tables( void )
{
#ifdef TABLEINFO
  table_info = NEW( Ttable_info );
#endif
}
