//  ____________________________________________________
// |                                                    |
// |  Project:     POWER VIEW INTERFACE                 |
// |  File:        PVWIN.CPP                            |
// |  Compiler:    WPP386 (10.6)                        |
// |                                                    |
// |  Subject:     Windows support implementation       |
// |                                                    |
// |  Author:      Emil Dotchevski                      |
// |____________________________________________________|
//
// E-mail: zajo@geocities.com
// URL:    http://www.geocities.com/SiliconValley/Bay/3577

#define uses_stdio
#define uses_string
#define uses_app
#define uses_colors
#define uses_dc
#define uses_desk
#define uses_icons
#define uses_label
#define uses_system
#define uses_cmdgen
#define uses_win

#define _DECLARE_PVWIN
#include "PVuses.h"
#undef  _DECLARE_PVWIN

class Tmoving: public Titem
{
  public:
    Tmoving( boolean _move_or_resize );

  protected:
    virtual void set_palette( void );
    virtual void draw( void );

  private:
    boolean move_or_resize;
};

class Tframe: public Tbox
{
  public:
    Tframe( char *t );

  protected:
    virtual void set_palette( void );
};


//Tclose_icon private:

Tmenu *Tclose_icon::init( Twindow *w )
{
  window = w;
  ::menu();
    submenu( i_close );
      w->construct_system_menu();
    endm();
  return endm();
}

//Tclose_icon publics:

Tclose_icon::Tclose_icon( Twindow *w ):
  Tmenu_bar( init( w ), i_close_len )
{
  client = window;
}

uint Tclose_icon::exec( void )
{
  Tcommands *saved_cmd;
  uint result;

  saved_cmd = get_cmd();
  set_cmd( &window->commands );
  window->owner->pop_item( window );
  result = Tmenu_bar::exec();
  set_cmd( saved_cmd );
  return result;
}

//Tclose_icon protected:

void Tclose_icon::set_palette( void )
{
  Tmenu_bar::set_palette();
  if( !window_state( isACTIVE ) )
    text_attr = rolb( pal_windows.frame_normal, 4 );
}

#ifndef NOMOUSE
void Tclose_icon::event_handler( Tevent &ev )
{
  if( ( ev.code == evMOUSE_DOWN ) && ev.INSIDE && ev.CLICKS )
  {
    if( state( isMODAL ) ) stop( cmWIN_CLOSE );
    put_command( owner, cmWIN_CLOSE );
    cancelled();
    handled( ev );
  }
  Tmenu_bar::event_handler( ev );
}
#endif

Tmenu_item *Tclose_icon::shortcut_ptr( uint ascii )
{
  Tmenu_item *result;

  result = Tmenu_bar::shortcut_ptr( ascii );
  if( ( result == NULL ) && ( ascii == kALT_SPACE ) ) result = menu->items;
  return result;
}

//Twindow publics:

Twindow::Twindow( char *t, int _xl, int _yl ):
  Titem( _xl, _yl ),
  commands( local_commands )
{
  palette = __palette();
  title = NULL;
  if( ( t != NULL ) && ( *t != 0 ) ) title = STRDUP( t );
  xl_min = 0; yl_min = 0; xl_max = 0; yl_max = 0;
  xl_saved = _xl; yl_saved = _yl;
  icon_x = 1000; icon_y = 1000;
  frame_beg_flag = 0;
  local_tools = __context();
  close_icon = NULL;
  maximize_icon = NEW( Ticon( i_maximize, cmWIN_MAXIMIZE, 0 ) );
    put_in( maximize_icon, 0, 0 );
    maximize_icon->drag_mode = dmDRAG_HOR;
  minimize_icon = NEW( Ticon( i_minimize, cmWIN_MINIMIZE, 0 ) );
    minimize_icon->drag_mode = dmDRAG_HOR;
    put_in( minimize_icon, 0, 0 );
  resize_icon = NEW( Ticon( i_resize, 0, 0 ) );
    resize_icon->set_events_mask( ~evCOMMAND, 0 );
    resize_icon->drag_mode = dmDRAG_BOTH;
    put_in( resize_icon, 0, 0 );
  set_flags( ifSELECTABLE+ifICONIZEABLE+ifTILEABLE, 1 );
  grow_mode = gmGROW_REL + gmGROW_BOTH;
  drag_mode = dmDRAG_REL + dmDRAG_BOTH;
  on_top_flag = 0;
  shortcut = 0;
  commands<<0<<cmWIN_ON_TOP;
  resize( xl, yl );
}

Twindow::~Twindow( void )
{
  if( shortcut ) win_nums>>shortcut;
  set_context( 0 );
  if( get_cmd() == &commands ) set_cmd( NULL );
  FREE( title );
}

void Twindow::set_state( uint _state_word, boolean enable )
{
  uint s;
  int gx, gy, xx, yy;

  if( _state_word & isICONIZED )
    if( !flags( ifICONIZEABLE ) )
      _state_word &= ~isICONIZED;
    else
      if( enable && state( wsMAXIMIZED ) ) set_state( wsMAXIMIZED, 0 );
  if( _state_word & wsMAXIMIZED )
    if( !flags( ifRESIZEABLE ) )
      _state_word &= ~wsMAXIMIZED;
    else
      if( enable && state( isICONIZED ) ) set_state( isICONIZED, 0 );
  if( !_state_word ) return;
  s = state_word;
  Titem::set_state( _state_word, enable );
  if( s != state_word )
  {
    if( ( _state_word & isFOCUSED ) && enable ) owner->pop_item( this );
    if( _state_word & ( isHIDDEN ) )
      if( state( isHIDDEN ) )
      {
        commands>>0>>cmWIN_CLOSE;
        if( shortcut )
        {
          win_nums>>shortcut;
          shortcut = 0;
        }
      }
      else
      {
        commands<<0;
        if( flags( ifCLOSEABLE ) ) commands<<cmWIN_CLOSE;
        if( !shortcut && flags( ifSELECTABLE ) && owner==desktop )
          for( char i=1; i<=9; i++ )
            if( !( win_nums & i ) )
            {
              win_nums<<i;
              shortcut = i;
              break;
            }
      }
    desktop->update_commands();
  }
  on_top_flag = state( isON_TOP )? cmWIN_ON_TOP : 0;
  if( (s&(isICONIZED+wsMAXIMIZED)) == (state_word&(isICONIZED+wsMAXIMIZED)) ) return;
  boolean iconized_on   = (s&isICONIZED ) < (state_word&isICONIZED );
  boolean maximized_on  = (s&wsMAXIMIZED) < (state_word&wsMAXIMIZED);
  boolean iconized_off  = (s&isICONIZED ) > (state_word&isICONIZED );
  boolean maximized_off = (s&wsMAXIMIZED) > (state_word&wsMAXIMIZED);
  if( iconized_on || maximized_on )
  {
    x_saved  = x;  y_saved  = y;
    xl_saved = xl; yl_saved = yl;
    commands<<cmWIN_RESTORE;
  }
  if( iconized_off || maximized_off ) commands>>cmWIN_RESTORE;
  redraw();
  if( iconized_on )
  {
    if( xl_min > 0 ) Titem::resize( xl_min, 1 ); else Titem::resize( 23, 1 );
    if( icon_x != 1000 )
      drag( icon_x, icon_y );
    else
      if( owner == desktop ) ( (Tdesktop *) owner )->arrange_one_icon( this );
    commands>>0>>cmWIN_MINIMIZE;
  }
  if( iconized_off )
  {
    icon_x = x; icon_y = y;
    Titem::resize( xl_saved, yl_saved );
    Titem::drag( x_saved, y_saved );
    redraw();
    commands<<cmWIN_MINIMIZE;
    if( state( isALIVE ) ) commands<<0;
  }
  if( maximized_on )
  {
    xx = xl_max; if( !xx ) xx = owner->xl;
    yy = yl_max; if( !yy ) yy = owner->yl;
    direct_resize( xx, yy );
    owner->make_global( x, y, gx, gy );
    if( gx < 0 ) xx = 0; else xx = gx;
    if( ( scr_columns - xx ) < xl ) xx = scr_columns - xl;
    if( gy < desktop_y ) yy = desktop_y; else yy = gy;
    if( ( scr_rows - yy ) < yl ) yy = scr_rows - yl;
    owner->make_local( xx, yy, gx, gy );
    drag( gx, gy );
    commands>>cmWIN_MAXIMIZE;
    maximize_icon->set_cmd( cmWIN_RESTORE );
  }
  if( maximized_off )
  {
    direct_resize( xl_saved, yl_saved );
    Titem::drag( x_saved, y_saved );
    commands<<cmWIN_MAXIMIZE;
    maximize_icon->set_cmd( cmWIN_MAXIMIZE );
  }
  if( state( wsMAXIMIZED ) )
    maximize_icon->set_title( i_maximized );
  else
    maximize_icon->set_title( i_maximize );
}

void Twindow::set_flags( uint _flags_word, boolean enable )
{
  Titem::set_flags( _flags_word, enable );
  if( close_icon != NULL )
    close_icon->set_state( isHIDDEN+isDISABLED, !flags( ifCLOSEABLE ) );
  maximize_icon->set_state( isHIDDEN+isDISABLED, !flags( ifRESIZEABLE ) );
  minimize_icon->set_state( isHIDDEN+isDISABLED, !flags( ifICONIZEABLE ) );
  resize_icon->set_state( isHIDDEN+isDISABLED, !flags( ifRESIZEABLE ) );
  flags( ifCLOSEABLE )? commands<<cmWIN_CLOSE : commands>>cmWIN_CLOSE;
  flags( ifMOVABLE )? commands<<cmWIN_MOVE : commands>>cmWIN_MOVE;
  flags( ifRESIZEABLE )? commands<<cmWIN_MAXIMIZE<<cmWIN_SIZE :
                         commands>>cmWIN_MAXIMIZE>>cmWIN_SIZE;
  flags( ifICONIZEABLE )? commands<<cmWIN_MINIMIZE : commands>>cmWIN_MINIMIZE;
}

void Twindow::pop_up( void )
{
  if( owner != NULL ) owner->pop_item( this );
  Titem::pop_up();
}

void Twindow::drag( int newx, int newy )
{
  int xx, yy, gx, gy;

  owner->make_global( newx, newy, gx, gy );
  if( gy < desktop_y ) gy = desktop_y;
  if( gy >= scr_rows ) gy = scr_rows - 1;
  xx = 0;
  if( !state( isICONIZED ) )
  {
    if( flags( ifICONIZEABLE ) ) xx += i_minimize_len;
    if( flags( ifRESIZEABLE ) )  xx += i_maximize_len;
  }
  if( ( gx + xl ) <= xx ) gx = xx - xl + 1;
  xx = 0;
  if( flags( ifCLOSEABLE ) && !state( isICONIZED ) ) xx = i_close_len;
  if( gx >= ( (int) scr_columns - xx ) ) gx = scr_columns - xx - 1;
  owner->make_local( gx, gy, xx, yy );
  Titem::drag( xx, yy );
}

void Twindow::resize( int newxl, int newyl )
{
  int xlmax, ylmax;
  boolean was_maximized;

  xlmax = xl_max; if( !xlmax ) xlmax = desktop_xl;
  ylmax = yl_max; if( !ylmax ) ylmax = desktop_yl;
  was_maximized = state( wsMAXIMIZED );
  direct_resize( newxl, newyl );
  if( was_maximized && ( ( xl < xlmax ) || ( yl < ylmax ) ) )
  {
    x_saved = x;   y_saved = y;
    xl_saved = xl; yl_saved = yl;
    set_state( wsMAXIMIZED, 0 );
  }
}

boolean Twindow::valid( uint command )
{
  static boolean message_flag = 0;

  if( Titem::valid( command ) )
    if( ( command != cmVALID ) /*|| !lowmemory */|| message_flag )
      return 1;
    else
    {
      return 1;
//      message_flag = 1;
//      _terror(); ok( "Sorry, memory not enough to complete request." );
//      message_flag = 0;
    }
  return 0;
}

void Twindow::put_in( Titem *v, int _x, int _y )
{
  Titem::put_in( v, _x, _y );
  if( ( first() != close_icon ) && ( close_icon != NULL ) )
    pop_item( close_icon );
  if( frame_beg_flag )
  {
    frame_beg_flag = 0;
    beg_frame_item = v;
  }
  end_frame_item = v;
}

boolean Twindow::cenabled( uint cmd )
{
  return ( commands & cmd ) != 0;
}

boolean Twindow::cdisabled( uint cmd )
{
  return ( commands & cmd ) == 0;
}

void Twindow::cenable( uint cmd )
{
  if( commands & cmd ) return;
  commands << cmd;
}

void Twindow::cdisable( uint cmd )
{
  if( !( commands & cmd ) ) return;
  commands >> cmd;
}

void Twindow::cstate( uint cmd, boolean enable )
{
  if( enable ) cenable( cmd ); else cdisable( cmd );
}

void Twindow::set_title( char *t )
{
  if( title != NULL ) FREE( title );
  title = NULL;
  if( ( t != NULL ) && ( *t != 0 ) ) title = STRDUP( t );
  redraw();
}

void Twindow::title2str( char *t, int max_len )
{
  if( title != NULL )
    memcpy( t, title, max_len ),
    t[max_len] = 0;
  else
    *t = 0;
}

void Twindow::construct_frame( char *fr )
{
  int x_l, y_l;
  char t[256];
  char c1, c2, c3, l1, l2, rt, tl;

  x_l = 1;
  if( !state( isICONIZED ) )
  {
    if( flags( ifICONIZEABLE ) ) x_l += i_minimize_len;
    if( flags( ifRESIZEABLE ) ) x_l += i_maximize_len;
  }
  if( x_l < i_close_len+2 ) x_l = i_close_len+2;
  title2str( t, xl - x_l - x_l - 2 );
  x_l = xl - 2; y_l = yl - 2;
  tl = strlen( t )+2;
  l2 = (char) ( (xl-tl) >> 1 ); rt = (char) ( xl-l2-tl-1 );
  l2 -= (l1=i_close_len)+1;
  if( state( isACTIVE ) )
  {
    c1 = '6';
    c2 = '1';
  }
  else
  {
    c1 = '5';
    c2 = '0';
  }
  c3 = shortcut? shortcut+'0' : i_upper_frame;
  if( state( isICONIZED ) )
    sprintf( fr, "|%c|r%c%c%c|r%c%c %s |r%c%c%c",
      c1, l1, i_upper_frame, c3, l2, i_upper_frame, t, rt, i_upper_frame, i_upper_frame_r
    );
  else
    if( *t )
      sprintf( fr, "|%c|r%c%c%c|r%c%c %s |r%c%c%c|n|%c%c|r%c%c%c|l%c%c|r%c%c%c",
        c1, l1, i_upper_frame, c3, l2, i_upper_frame, t, rt, i_upper_frame, i_upper_frame_r,
        c2, frame_normal[3], x_l, frame_normal[4], frame_normal[5], y_l,
        frame_normal[6], x_l, frame_normal[7], frame_normal[8]
      );
    else
      sprintf( fr, "|%c%c|r%c%c%c|n%c|r%c%c%c|l%c%c|r%c%c%c",
        c2, frame_normal[0], x_l, frame_normal[1], frame_normal[2],
        frame_normal[3], x_l, frame_normal[4], frame_normal[5], y_l,
        frame_normal[6], x_l, frame_normal[7], frame_normal[8]
      );
}

void Twindow::construct_system_menu( void )
{
  if( flags( ifRESIZEABLE|ifICONIZEABLE ) )
#ifdef CYR
    mitem( "|~", "Ctrl+F5 ", cmWIN_RESTORE );
#else
    mitem( "|~Restore", "Ctrl+F5 ", cmWIN_RESTORE );
#endif
  if( flags( ifMOVABLE ) )
#ifdef CYR
    mitem( "|~", "Ctrl+F7 ", cmWIN_MOVE );
#else
    mitem( "|~Move", "Ctrl+F7 ", cmWIN_MOVE );
#endif
  if( flags( ifRESIZEABLE ) )
#ifdef CYR
    mitem( "|~", "Ctrl+F8 ", cmWIN_SIZE );
#else
    mitem( "|~Size", "Ctrl+F8 ", cmWIN_SIZE );
#endif
  if( flags( ifICONIZEABLE ) )
#ifdef CYR
    mitem( "|~", "Ctrl+F9 ", cmWIN_MINIMIZE );
#else
    mitem( "Mi|~nimize", "Ctrl+F9 ", cmWIN_MINIMIZE );
#endif
  if( flags( ifRESIZEABLE ) )
#ifdef CYR
    mitem( "|~ ", "Ctrl+F10", cmWIN_MAXIMIZE );
#else
    mitem( "Ma|~ximize", "Ctrl+F10", cmWIN_MAXIMIZE );
#endif
  if( flags( ifSELECTABLE ) || !state( isON_TOP ) )
#ifdef CYR
    mitem( "|~ ", on_top_flag, cmWIN_ON_TOP );
#else
    mitem( "On |~Top", on_top_flag, cmWIN_ON_TOP );
#endif
  if( flags( ifCLOSEABLE ) )
#ifdef CYR
    mitem( "|~", "Ctrl+F4 ", cmWIN_CLOSE );
#else
    mitem( "|~Close", "Ctrl+F4 ", cmWIN_CLOSE );
#endif
}

static Tframe *win_frame;

Titem *Twindow::frame( char *t )
{
  frame_beg_flag = 1;
  win_frame = NEW( Tframe( t ) );
  put_in( win_frame, 0, 0 );
  return win_frame;
}

Titem *Twindow::frame( void )
{
  return frame( "" );
}

void Twindow::endfr( void )
{
  int n;
  Titem *p;

  if( last == NULL ) return;
  p = first();
  while( p != end_frame_item ) p = p->next;
  win_frame->drag( p->x + p->bound_x, p->y + p->bound_y );
  win_frame->resize( p->bound_xl, p->bound_yl );
  while( p != beg_frame_item )
  {
    p = p->next;
    n = win_frame->x - ( p->x + p->bound_x );
    if( n>0 )
    {
      win_frame->resize( win_frame->xl + n, win_frame->yl );
      win_frame->drag( p->x + p->bound_x, win_frame->y );
    }
    n = win_frame->y - ( p->y + p->bound_y );
    if( n>0 )
    {
      win_frame->resize( win_frame->xl, win_frame->yl + n );
      win_frame->drag( win_frame->x, p->y + p->bound_y );
    }
    n = ( ( p->x + p->bound_x ) + p->bound_xl ) -
          ( win_frame->x + win_frame->xl );
    if( n>0 ) win_frame->resize( win_frame->xl + n, win_frame->yl );
    n = ( ( p->y + p->bound_y ) + p->bound_yl ) -
          ( win_frame->y + win_frame->yl );
    if( n>0 ) win_frame->resize( win_frame->xl, win_frame->yl + n );
  }
  win_frame->resize( win_frame->xl + 2, win_frame->yl + 2 );
  win_frame->drag( win_frame->x - 1, win_frame->y - 1 );
}

//Twindow protected:

void Twindow::calc_bounds( int delta_xl, int delta_yl )
{
  int oxl, oyl, nxl, nyl, xx, yy;
  boolean was_iconized, was_maximized;

  was_maximized = state( wsMAXIMIZED );
  was_iconized  = state( isICONIZED );
  set_state( wsMAXIMIZED+isICONIZED, 0 );
  if( flags( ifRESIZEABLE ) )
  {
    maximize_icon->set_title( i_maximize );
    maximize_icon->drag( xl - i_maximize_len, 0 );
    resize_icon->drag( xl - i_resize_len, yl - 1 );
  }
  if( flags( ifICONIZEABLE ) )
  {
    nxl = xl-i_minimize_len;
    if( flags( ifRESIZEABLE ) ) nxl -= i_maximize_len;
    minimize_icon->drag( nxl, 0 );
  }
  if( delta_xl || delta_yl )
  {
    oxl = owner->xl; oyl = owner->yl;
    nxl = oxl - delta_xl; nyl = oyl - delta_yl;
    if( drag_mode & dmDRAG_REL )
    {
      xx = ( x * oxl ) / nxl;
      yy = ( y * oyl ) / nyl;
      if( !( drag_mode & dmDRAG_HOR ) )
        xx = x,
        icon_x = ( icon_x * oxl ) / nxl;
      if( !( drag_mode & dmDRAG_VER ) )
        yy = y,
        icon_y = ( icon_y * oyl ) / nyl;
      drag( xx, yy );
    }
    nxl = xl; nyl = yl;
    if( grow_mode & gmGROW_REL )
    {
      if( !( grow_mode & gmGROW_HOR ) )
        xl_saved = ( xl_saved * oxl ) / nxl,
        nxl = ( xl * oxl ) / nxl;
      if( !( grow_mode & gmGROW_VER ) )
        yl_saved = ( yl_saved * oyl ) / nyl,
        nyl = ( yl * oyl ) / nyl;
      if( ( ( x + xl ) <= nxl ) && ( ( x + nxl ) > oxl ) ) nxl = oxl - x;
      if( ( ( y + yl ) <= nyl ) && ( ( y + nyl ) > oyl ) ) nyl = oyl - y;
    }
    resize( nxl,nyl );
  }
  if( was_maximized ) set_state( wsMAXIMIZED, 1 );
  if( was_iconized  ) set_state( isICONIZED, 1 );
}

void Twindow::set_palette( void )
{
  switch( palette )
  {
    case wpSTANDARD:
      text_attr = pal_windows.standard_normal;
      bold_attr = pal_windows.standard_bold;
      selected_attr = pal_windows.standard_selected;
      disabled_attr = pal_windows.standard_disabled;
      break;
    case wpEDITOR:
      text_attr = pal_windows.editor_normal;
      bold_attr = pal_windows.editor_bold;
      selected_attr = pal_windows.editor_selected;
      disabled_attr = pal_windows.editor_disabled;
      break;
    case wpTOOL:
      text_attr = pal_windows.tool_normal;
      bold_attr = pal_windows.tool_bold;
      selected_attr = pal_windows.tool_selected;
      disabled_attr = pal_windows.tool_disabled;
      break;
    case wpHELP:
      text_attr = pal_windows.help_normal;
      bold_attr = pal_windows.help_bold;
      selected_attr = pal_windows.help_selected;
      disabled_attr = pal_windows.help_disabled;
      break;
    case wpALERT:
      text_attr = pal_windows.alert_normal;
      bold_attr = pal_windows.alert_bold;
      selected_attr = pal_windows.alert_selected;
      disabled_attr = pal_windows.alert_disabled;
      break;
  }
  shortcut_attr = pal_windows.shortcut;
  attr[0] = (char) ( ( text_attr & 0xF0 ) | pal_windows.frame_normal );
  attr[1] = (char) ( ( text_attr & 0xF0 ) | pal_windows.frame_selected );
  attr[2] = pal_windows.icon_normal;
  attr[3] = pal_windows.icon_selected;
  attr[4] = pal_windows.icon_pressed;
  attr[5] = pal_windows.title_normal;
  attr[6] = pal_windows.title_selected;
}

void Twindow::draw( void )
{
  char window_frame[256];

  construct_frame( window_frame );
  txt( window_frame );
}

void Twindow::initialize( void )
{
  Titem::initialize();
  close_icon = NEW( Tclose_icon( this ) );
  put_in( close_icon, 0, 0 );
  if( !shortcut && owner==desktop && flags( ifSELECTABLE ) && !state( isHIDDEN ) )
    for( char i=1; i<=9; i++ )
      if( !( win_nums & i ) )
      {
        win_nums<<i;
        shortcut = i;
        break;
      }
}

void Twindow::get_focused( void )
{
  Titem::get_focused();
  set_cmd( &commands );
  set_context( local_tools );
}

boolean Twindow::release_focus( void )
{
  if( Titem::release_focus() )
  {
    set_cmd( NULL );
    set_context( 0 );
    return 1;
  }
  return 0;
}

void Twindow::event_handler( Tevent &ev )
{
  int restore_x, restore_y, restore_xl, restore_yl, tmpx, tmpy;
  Tevent ev1;
  boolean selected, iconized, moved;
  Tmoving *mv_ptr;
  uint mask_svd, old_shifts;

  Titem::event_handler( ev );
  iconized = state( isICONIZED );
  selected = state( isSELECTED|isMODAL ) && !state( isHIDDEN );
  switch( ev.code )
  {
    case evCOMMAND:
      if( ( ev.destination == this ) || selected )
      {
        switch( ev.CMD_CODE )
        {
          case cmWIN_CLOSE:
            if( flags( ifCLOSEABLE ) ) put_command( this, cmDONE );
            break;
          case cmWIN_MOVE:
            if( !flags( ifMOVABLE ) ) break;
          case cmWIN_SIZE:
            moved = 1;
            if( ev.CMD_CODE == cmWIN_SIZE )
            {
              moved = 0;
              if( !flags( ifRESIZEABLE ) ) break;
            }
            mv_ptr = NEW( Tmoving( moved ) );
            owner->put_in( mv_ptr, xCENTER, owner->yl - 6 );
            old_shifts = get_shifts();
            put_shifts( old_shifts & ~smNUM );
            restore_x  = x;  restore_y  = y;
            restore_xl = xl; restore_yl = yl;
            do
            {
              get_key( ev, evKEY_PRESS );
              if( moved )
                switch( ev.ASCII )
                {
                  case kUP:
                    drag( x, y - 1 ); break;
                  case kDOWN:
                    drag( x, y + 1 ); break;
                  case kLEFT:
                    drag( x - 1, y ); break;
                  case kRIGHT:
                    drag( x + 1, y ); break;
                  case kPG_UP:
                    drag( x, 0 ); break;
                  case kPG_DN:
                    drag( x, owner->yl - yl ); break;
                  case kHOME:
                    drag( 0, y ); break;
                  case kEND:
                    drag( owner->xl - xl, y ); break;
                  case kESC:
                    drag( restore_x, restore_y );
                }
              else
                switch( ev.ASCII )
                {
                  case kUP:
                    direct_resize( xl, yl - 1 ); break;
                  case kDOWN:
                    direct_resize( xl, yl + 1 ); break;
                  case kLEFT:
                    direct_resize( xl - 1, yl ); break;
                  case kRIGHT:
                    direct_resize( xl + 1, yl ); break;
                  case kESC:
                    direct_resize( restore_xl, restore_yl );
                }
            }
            while( ( ev.ASCII != kENTER ) && ( ev.ASCII != kESC ) );
          _break:
            tmpx = xl; tmpy = yl;
            direct_resize( restore_xl, restore_yl );
            resize( tmpx, tmpy );
            DELETE( mv_ptr );
            put_shifts( old_shifts & ~( smSCROLL+smCTRL+smLCTRL ) );
            break;
          case cmWIN_MAXIMIZE:
            if( flags( ifRESIZEABLE ) ) set_state( wsMAXIMIZED, 1 );
            break;
          case cmWIN_MINIMIZE:
            if( flags( ifICONIZEABLE ) ) set_state( isICONIZED, 1 );
            break;
          case cmWIN_RESTORE:
            set_state( isICONIZED, 0 );
            set_state( wsMAXIMIZED, 0 );
            break;
          case cmWIN_ON_TOP:
            set_state( isON_TOP, !state( isON_TOP ) );
            break;
          default:
            goto hot1;
        }
        handled( ev );
      }
    hot1:
      break;
    case evKEY_PRESS:
      if( state( isFOCUSED ) )
      {
        switch( ev.ASCII )
        {
          case kCTRL_F4:
            message( this, cmWIN_CLOSE ); break;
          case kENTER:
            if( !iconized ) goto hot;
          case kCTRL_F5:
            message( this, cmWIN_RESTORE ); break;
          case kCTRL_F7:
            message( this, cmWIN_MOVE ); break;
          case kCTRL_F8:
            message( this, cmWIN_SIZE ); break;
          case kCTRL_F9:
            message( this, cmWIN_MINIMIZE );
            owner->tab_next( 0 );
            while( owner->current!=NULL &&
                   owner->current!=this &&
                   owner->current->state( isICONIZED ) ) owner->tab_next( 0 );
            break;
          case kCTRL_F10:
            message( this, cmWIN_MAXIMIZE ); break;
          default:
            goto hot;
        }
        handled( ev );
        break;
      }
    hot:
      if( shortcut && ev.ASCII==kALT_1+((shortcut-1)<<8) )
      {
        set_state( isICONIZED, 0 );
        focus();
        handled( ev );
        break;
      }
      if( iconized )
      {
        if( ev.ASCII==kALT_SPACE )
        {
          do_system_menu();
          handled( ev );
        }
        break;
      }
      if( selected )
      {
        if( ev.ASCII <= 255 )
        {
          ev1 = ev;
          if( ( ev1.ASCII = lat2alt( ev1.ASCII ) ) != 0 )
          {
            mask_svd = event_mask; event_mask = 0;
            handle_event( ev1 );
            event_mask = mask_svd;
            if( ev1.code == evNOTHING ) handled( ev );
          }
        }
        if( ev.code != evNOTHING )
        {
          switch ( ev.ASCII )
          {
            case kTAB:
            case kSHIFT_TAB:
              tab_next( ev.ASCII == kSHIFT_TAB ); break;
            case kUP:
            case kLEFT:
            case kDOWN:
            case kRIGHT:
              local_next( ( ev.ASCII == kUP ) || ( ev.ASCII == kLEFT ) ); break;
            default:
              goto hot2;
          }
          handled( ev );
        }
      }
    hot2:
      break;
#ifndef NOMOUSE
      case evMOUSE_DOWN:
        if( ev.INSIDE )
        {
          handled( ev );
          owner->pop_item( this );
          if( !ev.LOCAL_Y )
            if( ev.CLICKS )
              if( !state( isICONIZED ) && !state( wsMAXIMIZED ) )
                message( this, cmWIN_MAXIMIZE );
              else
                message( this, cmWIN_RESTORE );
            else
            {
              int delta_x = ev.LOCAL_X;
              moved = 0;
              while( get_mouse( ev, evMOUSE_DRAG ) )
              {
                owner->make_local( ev.GLOBAL_X, ev.GLOBAL_Y, tmpx, tmpy );
                drag( tmpx - delta_x, tmpy );
                moved = 1;
              }
              if( !moved ) do_system_menu();
            }
          else
            if( !iconized && flags( ifRESIZEABLE ) &&
                ( ev.LOCAL_Y == ( yl - 1 ) ) &&
                ( ev.LOCAL_X >= xl - i_resize_len ) )
            {
              restore_xl = xl; restore_yl = yl;
              resize_icon->pressed = 1;
              resize_icon->redraw();
              while( get_mouse( ev, evMOUSE_DRAG ) )
                direct_resize( ev.LOCAL_X + 1, ev.LOCAL_Y + 1 );
              resize_icon->pressed = 0;
              resize_icon->redraw();
              tmpx = xl; tmpy = yl;
              direct_resize( restore_xl, restore_yl );
              resize( tmpx, tmpy );
            }
        }
        break;
#endif
    }
}

void Twindow::direct_resize( int newxl, int newyl )
{
  int xlmin, ylmin, xlmax, ylmax;

  if( state( isICONIZED ) ) return;
  xlmin = xl_min; ylmin = yl_min; xlmax = xl_max; ylmax = yl_max;
  if( !xlmin ) xlmin = 23;
  if( !ylmin ) ylmin = 5;
  if( !xlmax ) xlmax = desktop_xl;
  if( !ylmax ) ylmax = desktop_yl;
  if( newyl < ylmin ) newyl = ylmin;
  if( newyl > ylmax ) newyl = ylmax;
  if( newxl < xlmin ) newxl = xlmin;
  if( newxl > xlmax ) newxl = xlmax;
  Titem::resize( newxl, newyl );
}

void Twindow::do_system_menu( void )
{
  Tmenu_box *m;
  int xx,yy;
  Tcommands *saved_cmd;

  if( state( isICONIZED ) )
  {
    saved_cmd = get_cmd();
    set_cmd( &commands );
    m = construct_menu_box( close_icon->menu->items->what.submenu );
    m->client = this;
    make_global( 0, -m->yl, xx, yy );
    if( yy < 0 ) yy += m->yl + 1;
    application->make_local( xx, yy, xx, yy );
    application->put_in( m, xx, yy );
    show_menu_cursor( m->menu );
    m->exec();
    m->menu = NULL;
    set_cmd( saved_cmd );
  }
}

//Tmoving publics:

Tmoving::Tmoving( boolean _move_or_resize ):
  Titem( 40, 4 )
{
  set_events_mask( (uint)-1, 0 );
  set_flags( (uint)-1, 0 ); set_flags( ifVISIBLE, 1 );
  set_state( isON_TOP, 1 );
  move_or_resize = _move_or_resize;
}

//Tmoving protected:

void Tmoving::set_palette( void )
{
  text_attr = pal_windows.help_normal;
  bold_attr = pal_windows.help_bold;
  selected_attr = (char) ( pal_windows.frame_selected | ( text_attr & 0xF0 ) );
}

void Tmoving::draw( void )
{
#ifdef CYR
  static char m[] = "";
  static char s[] = " ";
#else
  static char m[] = "move";
  static char s[] = "size";
#endif
  char *what;

  what = s;
  if( move_or_resize ) what = m;
#ifdef CYR
  txtf( "|s%c|r\046%c%c|n%c|t   %s , |s%c|n%c|t       <|bEnter|t>  .      |s%c|n%c|r\046%c%c",
#else
  txtf( "|s%c|r\046%c%c|n%c|t  Use arrow keys to %s the window,  |s%c|n%c|t       press <|bEnter|t> when done.       |s%c|n%c|r\046%c%c",
#endif
  frame_normal[0],frame_normal[1],frame_normal[2],frame_normal[3],
  what,
  frame_normal[5],frame_normal[3],frame_normal[5],frame_normal[6],
  frame_normal[7],frame_normal[8] );
}

//Tframe publics:

Tframe::Tframe( char *t ):
  Tbox( t, NULL )
{
  set_events_mask( (uint)-1, 0 );
}

//Tframe protected:

void Tframe::set_palette( void )
{
  Tbox::set_palette();
  bold_attr = text_attr;
}

//Tscroll_window publics:

Tscroll_window::Tscroll_window( uint &hbeg_print, uint &hcount,
                                uint &vbeg_print, uint &vcount,
                                int delta_h,
                                char *t, Titem *item ):
  Twindow( t, item->xl + i_sb_up_len + 1, item->yl + 2 )
{
  vbar = NEW( Tvscroll_bar( item->yl, vcount, vbeg_print ) );
    vbar->set_flags( sfHIDEABLE+sfHANDLE_KEYBOARD, 0 );
    item->put_in( vbar, item->xl, 0 );
  hbar = NEW( Thscroll_bar( item->xl - delta_h + 1, hcount, hbeg_print ) );
    hbar->set_flags( sfHIDEABLE+sfHANDLE_KEYBOARD, 0 );
    item->put_in( hbar, delta_h - 1, item->yl );
  commands<<cmUP_ARROW<<cmDOWN_ARROW<<cmLEFT_ARROW<<cmRIGHT_ARROW;
  put_in( item, 1, 1 );
  palette = wpEDITOR;
}

//Tfile_window publics:

Tfile_window::Tfile_window( uint &hbeg_print, uint &hcount,
                            uint &vbeg_print, uint &vcount,
                            int delta_h,
                            char *t, Titem *item ):
  Tscroll_window( hbeg_print, hcount, vbeg_print, vcount, delta_h, t, item )
{
}

void Tfile_window::title2str( char *t, int max_len )
{
  if( ( title == NULL ) || ( *title == 0 ) ||
      ( title[1] != ':' ) || ( title[2] != '\\' ) )
    Tscroll_window::title2str( t, max_len );
  else
  {
    strcpy( t, title );
    min_path( t );
    short_path( t, max_len );
  }
}

//PREFIXES

static char palette_ = 0;
static int context_ = 0;

/*
  Description:
    Specify standard palette for dialog box. Call just before a call to
    'dialog'.
*/
void _pstandard( void )
{
  if( !palette_ ) palette_ = wpSTANDARD;
}

/*
  Description:
    Specify editor palette for dialog box. Call just before a call to
    'dialog'.
*/

void _peditor( void )
{
  if( !palette_ ) palette_ = wpEDITOR;
}

/*
  Description:
    Specify help palette for dialog box. Call just before a call to
    'dialog'.
*/
void _ptool( void )
{
  if( !palette_ ) palette_ = wpTOOL;
}

/*
  Description:
    Specify help palette for dialog box. Call just before a call to
    'dialog'.
*/
void _phelp( void )
{
  if( !palette_ ) palette_ = wpHELP;
}

/*
  Description:
    Specify alert palette for dialog box. Call just before a call to
    'dialog'.
*/
void _palert( void )
{
  if( !palette_ ) palette_ = wpALERT;
}

char __palette( void )
{
  char result = wpSTANDARD;

  if( palette_ ) result = palette_;
  palette_ = 0;
  return result;
}

/*
  Description:
    Specify toolbox number of the window that is about to be constructed.
  Entry:
    tools_num - toolbox number.
*/
void _context( int context )
{
  if( !context_ ) context_ = context;
}

int __context( void )
{
  int result;

  result = context_;
  context_ = 0;
  return result;
}
