 REM Analyze.bas v6.9a r1.0 - Symbolic Instruction Code; analyze module.
 REM The public domain DOS programming interpreter utility.

 ' get standard include declarations
 REM $INCLUDE: 'SIC.INC'

 ' backwards compatible for bc 7.1
 REM $INCLUDE: 'bc7.inc'

 ' declare global error routine
 ON ERROR GOTO Error.Routine

 ' program code
 REDIM Program(1 TO Max.Lines) AS STRING

 ' initialize variables
 White.Space = CHR$(32) + CHR$(9)

 ' run program from command line
 Filename = COMMAND$
 IF LEN(Filename) = False THEN
    GOTO Boot.Usage
 END IF
 IF DIR$(Filename) = Nul THEN
    GOTO Boot.Usage
 END IF
 COLOR White, Black
 PRINT "Analyze v" + Version + " r" + Release + ":"
 CALL New.Program
 CALL Read.Program
 CALL Prepare.Program
 CALL Analyze.Program
Error.Resume:
 COLOR Plain, Black
 WHILE INKEY$ <> Nul
 WEND
 PRINT "Exiting to system.."
 END

Boot.Usage:
 COLOR White, Black
 PRINT "Analyze v" + Version + " r" + Release + "; Usage:"
 COLOR Yellow, Black
 PRINT "Analyze <program name>"
 PRINT "   Analyzes program specified on command line."
 COLOR Plain, Black
 END

 ' standard error trap for all Sic functions.
Error.Routine:
 IF POS(0) > 1 THEN
    PRINT
 END IF
 COLOR White, Black
 PRINT "Analyze utility error";Err
 RESUME Error.Resume

' all remaining data statements declare
' analyze functions types and pairs
Analyze.Data1:
 DATA "IF", "ENDIF"
 DATA "DO", "LOOP"
 DATA "FOR", "NEXT"
 DATA "WHILE", "WEND"
 DATA "FORIF", "NEXTIF"
 DATA "LOOPIF", "END LOOPIF"
 DATA "SELECT CASE", "END SELECT"
 DATA "SELECTIF CASE", "END SELECTIF"

Analyze.Data2:
 DATA "IF", "ENDIF", "ELSE", "ELSEIF"
 DATA "SELECT CASE", "END SELECT", "CASE ELSE", "CASE"
 DATA "SELECTIF CASE", "END SELECTIF", "CASEIF ELSE", "CASEIF"

Analyze.Data3:
 DATA "DO", "LOOP", "EXIT DO", "CONTINUE DO"
 DATA "FOR", "NEXT", "EXIT FOR", "CONTINUE FOR"
 DATA "WHILE", "WEND", "EXIT WHILE", "CONTINUE WHILE"
 DATA "FORIF","NEXTIF", "EXIT FORIF", "CONTINUE FORIF"
 DATA "LOOPIF", "END LOOPIF", "EXIT LOOPIF", "CONTINUE LOOPIF"

' check validity of program
SUB Analyze.Program
 COLOR Yellow, Black
 CALL Count.Lines(Last.Line)
 PRINT "Pass 1: Counting matching structures."
 RESTORE Analyze.Data1
 FOR Data.Count = 1 TO 8
    READ Start.Structure$, Stop.Structure$
    Nested.Count = False
    FOR Program.Line = 1 TO Last.Line
       Out2 = Program(Program.Line)
       Out2 = STRIM$(Out2)
       IF LEN(Out2) THEN
	  Temp1$ = STRIM$(Out2)
	  Temp1$ = UCASE$(Temp1$)
          Count.Data1 = False
	  IF LEFT$(Temp1$, LEN(Start.Structure$)) = Start.Structure$ THEN
             Count.Data1 = True
	  END IF
          IF Start.Structure$ = "FOR" THEN
             IF LEFT$(Temp1$, 5) = "FORIF" THEN
                Count.Data1 = False
             END IF
          END IF
          IF Count.Data1 THEN
	     Nested.Count = Nested.Count + 1
          END IF
	  IF Start.Structure$ = "IF" THEN
	     IF LEFT$(Temp1$, 6) = "END IF" THEN
		Nested.Count = Nested.Count - 1
		IF Nested.Count < False THEN
		   PRINT "Analyze error, pass 1: Incomplete "; Start.Structure$; ": Line:"; Program.Line
		   EXIT SUB
		END IF
	     END IF
	  END IF
          IF Stop.Structure$ = "LOOP" THEN
             IF LEFT$(Temp1$, 6) <> "LOOPIF" THEN
                Temp1$ = LEFT$(Temp1$, 4)
             END IF
          END IF
          IF Stop.Structure$ = "NEXT" THEN
             IF LEFT$(Temp1$, 6) <> "NEXTIF" THEN
                Temp1$ = LEFT$(Temp1$, 4)
             END IF
          END IF
          IF Stop.Structure$ = "END SELECT" THEN
             IF LEFT$(Temp1$, 12) <> "END SELECTIF" THEN
                Temp1$ = LEFT$(Temp1$, 10)
             END IF
          END IF
          IF Temp1$ = Stop.Structure$ THEN
	     Nested.Count = Nested.Count - 1
	     IF Nested.Count < False THEN
		PRINT "Analyze error, pass 1: Incomplete "; Start.Structure$; ": Line:"; Program.Line
		EXIT SUB
	     END IF
	  END IF
       END IF
    NEXT
 NEXT
 PRINT "Pass 2: Counting matching imbedded structures."
 RESTORE Analyze.Data2
 FOR Data.Count = 1 TO 3
    READ Start.Structure$, Stop.Structure$, Imbedded1$, Imbedded2$
    Nested.Count = False
    FOR Program.Line = 1 TO Last.Line
       Out2 = Program(Program.Line)
       Out2 = STRIM$(Out2)
       IF LEN(Out2) THEN
	  Temp1$ = STRIM$(Out2)
	  Temp1$ = UCASE$(Temp1$)
	  IF LEFT$(Temp1$, LEN(Start.Structure$)) = Start.Structure$ THEN
	     Nested.Count = Nested.Count + 1
	  END IF
	  IF LEFT$(Temp1$, LEN(Imbedded1$)) = Imbedded1$ THEN
	     Nested.Count = Nested.Count - 1
	     IF Nested.Count < False THEN
		PRINT "Analyze error, pass 2: Incomplete "; Start.Structure$; ": Line:"; Program.Line
		EXIT SUB
	     END IF
	     Nested.Count = Nested.Count + 1
	  ELSE
             Temp2$ = Temp1$
             IF Imbedded2$ <> "ELSEIF" THEN
                IF LEFT$(Temp1$, LEN(Imbedded2$)) = Imbedded2$ THEN
                   Imbedded3 = INSTR(Temp1$, " ")
                   IF Imbedded3 = False THEN
                      PRINT "Analyze error, pass 2: Bad ";Imbedded2$; ": Line:";Program.Line
                      EXIT SUB
                   END IF
                   Temp2$ = LEFT$(Temp1$, Imbedded3 - 1)
                END IF
             END IF
             IF Temp2$ = Imbedded2$ THEN
		Nested.Count = Nested.Count - 1
		IF Nested.Count < False THEN
		   PRINT "Analyze error, pass 2: Incomplete "; Start.Structure$; ": Line:"; Program.Line
		   EXIT SUB
		END IF
		Nested.Count = Nested.Count + 1
	     END IF
	  END IF
	  IF Start.Structure$ = "IF" THEN
	     IF LEFT$(Temp1$, 6) = "END IF" THEN
		Nested.Count = Nested.Count - 1
		IF Nested.Count < False THEN
		   PRINT "Analyze error, pass 2: Incomplete "; Start.Structure$; ": Line:"; Program.Line
		   EXIT SUB
		END IF
	     END IF
	  END IF
          IF Temp1$ = Stop.Structure$ THEN
	     Nested.Count = Nested.Count - 1
	     IF Nested.Count < False THEN
		PRINT "Analyze error, pass 2: Incomplete "; Start.Structure$; ": Line:"; Program.Line
		EXIT SUB
	     END IF
	  END IF
       END IF
    NEXT
 NEXT
 PRINT "Pass 3: Multipass structure match."
 RESTORE Analyze.Data1
 FOR Data.Count = 1 TO 8
    READ Start.Structure$, Stop.Structure$
    FOR Program.Line = 1 TO Last.Line
       Out2 = Program(Program.Line)
       Out2 = STRIM$(Out2)
       IF LEN(Out2) THEN
	  Temp1$ = STRIM$(Out2)
	  Temp1$ = UCASE$(Temp1$)
          Count.Data1 = False
	  IF LEFT$(Temp1$, LEN(Start.Structure$)) = Start.Structure$ THEN
             Count.Data1 = True
          END IF
          IF Start.Structure$ = "FOR" THEN
             IF LEFT$(Temp1$, 5) = "FORIF" THEN
                Count.Data1 = False
             END IF
          END IF
          IF Count.Data1 THEN
	     Nested.Count = 1
	     FOR Nested.Lines = Program.Line + 1 TO Last.Line
		Temp2$ = Program(Nested.Lines)
		Temp2$ = STRIM$(Temp2$)
		IF LEN(Temp2$) THEN
		   Temp2$ = STRIM$(Temp2$)
		   Temp2$ = UCASE$(Temp2$)
                   Count.Data2 = False
		   IF LEFT$(Temp2$, LEN(Start.Structure$)) = Start.Structure$ THEN
                      Count.Data2 = True
                   END IF
                   IF Start.Structure$ = "FOR" THEN
                      IF LEFT$(Temp2$, 5) = "FORIF" THEN
                         Count.Data2 = False
                      END IF
                   END IF
                   IF Count.Data2 THEN
		      Nested.Count = Nested.Count + 1
		   END IF
                   IF Stop.Structure$ = "LOOP" THEN
                      IF LEFT$(Temp2$, 6) <> "LOOPIF" THEN
                         Temp2$ = LEFT$(Temp2$, 4)
                      END IF
                   END IF
                   IF Stop.Structure$ = "NEXT" THEN
                      IF LEFT$(Temp2$, 6) <> "NEXTIF" THEN
                         Temp2$ = LEFT$(Temp2$, 4)
                      END IF
                   END IF
                   IF Stop.Structure$ = "END SELECT" THEN
                      IF LEFT$(Temp1$, 12) <> "END SELECTIF" THEN
                         Temp1$ = LEFT$(Temp1$, 10)
                      END IF
                   END IF
                   IF Temp2$ = Stop.Structure$ THEN
		      Nested.Count = Nested.Count - 1
		      IF Nested.Count = False THEN
			 EXIT FOR
		      END IF
		   END IF
		   IF Start.Structure$ = "IF" THEN
		      IF LEFT$(Temp2$, 6) = "END IF" THEN
			 Nested.Count = Nested.Count - 1
			 IF Nested.Count = False THEN
			    EXIT FOR
			 END IF
		      END IF
		   END IF
		END IF
	     NEXT
	     IF Nested.Count <> False THEN
		PRINT "Analyze error, pass 3: Mismatched "; Start.Structure$; ": Line:"; Program.Line
		EXIT SUB
	     END IF
	  END IF
       END IF
    NEXT
 NEXT
 PRINT "Pass 4: Multipass imbedded struture match."
 RESTORE Analyze.Data2
 FOR Data.Count = 1 TO 3
    READ Start.Structure$, Stop.Structure$, Imbedded1$, Imbedded2$
    FOR Program.Line = 1 TO Last.Line
       Out2 = Program(Program.Line)
       Out2 = STRIM$(Out2)
       IF LEN(Out2) THEN
	  Temp1$ = STRIM$(Out2)
	  Temp1$ = UCASE$(Temp1$)
	  IF LEFT$(Temp1$, LEN(Start.Structure$)) = Start.Structure$ THEN
	     Total.Nested1 = 1
	     Total.Nested2 = 0
	     Nested.Count1 = 1
	     Nested.Count2 = 0
	     FOR Nested.Lines = Program.Line + 1 TO Last.Line
		Temp2$ = Program(Nested.Lines)
		Temp2$ = STRIM$(Temp2$)
		IF LEN(Temp2$) THEN
		   Temp2$ = STRIM$(Temp2$)
		   Temp2$ = UCASE$(Temp2$)
		   IF LEFT$(Temp2$, LEN(Start.Structure$)) = Start.Structure$ THEN
		      Total.Nested1 = Total.Nested1 + 1
		      Nested.Count1 = Nested.Count1 + 1
		   END IF
                   IF Temp2$ = Stop.Structure$ THEN
		      Total.Nested2 = Total.Nested2 - 1
		      Nested.Count1 = Nested.Count1 - 1
		      IF Nested.Count1 = 0 THEN
			 EXIT FOR
		      END IF
		   END IF
		   IF Start.Structure$ = "IF" THEN
		      IF LEFT$(Temp2$, 6) = "END IF" THEN
			 Nested.Count1 = Nested.Count1 - 1
			 IF Nested.Count1 = 0 THEN
			    EXIT FOR
			 END IF
		      END IF
		   END IF
		   IF LEFT$(Temp2$, LEN(Imbedded1$)) = Imbedded1$ THEN
		      Nested.Count2 = Nested.Count2 + 1
		      IF Nested.Count2 > Nested.Count1 THEN
			 PRINT "Analyze error, pass 4: Mismatched "; Start.Structure$; ": Line:"; Program.Line
			 EXIT SUB
		      END IF
		      Nested.Count2 = Nested.Count2 - 1
		   ELSE
                      Temp3$ = Temp2$
                      IF Imbedded2$ <> "ELSEIF" THEN
                         IF LEFT$(Temp2$, LEN(Imbedded2$)) = Imbedded2$ THEN
                            Imbedded3 = INSTR(Temp2$, " ")
                            IF Imbedded3 = False THEN
                               PRINT "Analyze error, pass 4: Bad ";Imbedded2$; ": Line:";Program.Line
                               EXIT SUB
                            END IF
                            Temp3$ = LEFT$(Temp2$, Imbedded3 - 1)
                         END IF
                      END IF
                      IF Temp3$ = Imbedded2$ THEN
			 Nested.Count2 = Nested.Count2 + 1
			 IF Nested.Count2 > Nested.Count1 THEN
			    PRINT "Analyze error, pass 4: Mismatched "; Start.Structure$; ": Line:"; Program.Line
			    EXIT SUB
			 END IF
			 Nested.Count2 = Nested.Count2 - 1
		      END IF
		   END IF
		END IF
	     NEXT
	     IF Total.Nested2 > Total.Nested1 THEN
		PRINT "Analyze error, pass 4: Mismatched "; Start.Structure$; ": Line:"; Program.Line
		EXIT SUB
	     END IF
	  END IF
       END IF
    NEXT
 NEXT
 PRINT "Pass 5: Single pass imbedded control structure match."
 RESTORE Analyze.Data3
 FOR Data.Count = 1 TO 5
    READ Start.Structure$, Stop.Structure$, Imbedded1$, Imbedded2$
    Nested.Count = False
    FOR Program.Line = 1 TO Last.Line
       Out2 = Program(Program.Line)
       Out2 = STRIM$(Out2)
       IF LEN(Out2) THEN
	  Temp1$ = STRIM$(Out2)
	  Temp1$ = UCASE$(Temp1$)
          Count.Data1 = False
	  IF LEFT$(Temp1$, LEN(Start.Structure$)) = Start.Structure$ THEN
             Count.Data1 = True
          END IF
          IF Start.Structure$ = "FOR" THEN
             IF LEFT$(Temp1$, 5) = "FORIF" THEN
                Count.Data1 = False
             END IF
          END IF
          IF Count.Data1 THEN
	     Nested.Count = Nested.Count + 1
	  END IF
          Count.Data2 = False
	  IF LEFT$(Temp1$, LEN(Stop.Structure$)) = Stop.Structure$ THEN
             Count.Data2 = True
          END IF
          IF Stop.Structure$ = "LOOP" THEN
             IF LEFT$(Temp1$, 6) = "LOOPIF" THEN
                Count.Data2 = False
             END IF
          END IF
          IF Stop.Structure$ = "NEXT" THEN
             IF LEFT$(Temp1$, 6) = "NEXTIF" THEN
                Count.Data2 = False
             END IF
          END IF
          IF Count.Data2 THEN
             Nested.Count = Nested.Count - 1
	  END IF
	  IF LEFT$(Temp1$, LEN(Imbedded1$)) = Imbedded1$ THEN
	     IF Nested.Count <= False THEN
		PRINT "Analyze error, pass 5: Badly nested "; Start.Structure$; ": Line:"; Program.Line
		EXIT SUB
	     END IF
	  END IF
	  IF LEFT$(Temp1$, LEN(Imbedded2$)) = Imbedded2$ THEN
	     IF Nested.Count <= False THEN
		PRINT "Analyze error, pass 5: Badly nested "; Start.Structure$; ": Line:"; Program.Line
		EXIT SUB
	     END IF
	  END IF
       END IF
    NEXT
 NEXT
 COLOR White, Black
 PRINT "Analysis completed. Program syntax correct."
END SUB

' gets last line in program
SUB Count.Lines (Temp1%)
 Temp1% = False
 FOR Temp2% = Max.Lines TO 1 STEP -1
    Temp1$ = Program(Temp2%)
    Temp1$ = STRIM$(Temp1$)
    IF LEN(Temp1$) THEN
       EXIT FOR
    END IF
 NEXT
 Temp1% = Temp2%
END SUB

' remove current .sic program from memory
SUB New.Program
 ' erase/redimension program code array
 ERASE Program
 REDIM Program(1 TO Max.Lines) AS STRING
END SUB

' loads a program from disk
SUB Read.Program
 CLOSE
 OPEN Filename FOR INPUT AS #1
 DO WHILE NOT EOF(1)
    LINE INPUT #1, Out2
    Out2 = STRIM$(Out2)
    FOR Blanks = 1 TO LEN(White.Space)
       Imbedded = INSTR(Out2, MID$(White.Space, Blanks, 1))
       IF Imbedded THEN
          Line.Number = INT(VAL(LEFT$(Out2, Imbedded - 1)))
          IF Line.Number > False AND Line.Number <= Max.Lines THEN
             Program(Line.Number) = MID$(Out2, Imbedded)
             EXIT FOR
          END IF
       END IF
    NEXT
 LOOP
 CLOSE
END SUB

' prepares program for analyze/run command
SUB Prepare.Program
 ' concatenate line continuation statements, remove continued lines.
 Program.Line = False
 CALL Count.Lines(Last.Line)
Count.Start1:
 Program.Line = Program.Line + 1
 IF Program.Line > Last.Line THEN
    GOTO Count.End1
 END IF
 IF Program.Line > Max.Lines THEN
    GOTO Count.End1
 END IF
 First.Line = Program.Line
 Out2 = STRIM$(Program(Program.Line))
 IF LEN(Out2) THEN
    DO
       IF RIGHT$(Out2, 1) = "_" THEN
          WHILE RIGHT$(Out2, 1) = "_"
             Out2 = LEFT$(Out2, LEN(Out2) - 1)
          WEND
          FOR Next.Line = Program.Line + 1 TO Last.Line
             Out3 = STRIM$(Program(Next.Line))
             IF LEN(Out3) THEN
                Out2 = Out2 + Out3
                Program.Line = Next.Line
                Program(Next.Line) = Nul
                EXIT FOR
             END IF
          NEXT
       ELSE
          EXIT DO
       END IF
       Out2 = STRIM$(Out2)
    LOOP
    Program(First.Line) = Out2
 END IF
 GOTO Count.Start1
Count.End1:

 ' compress program array,
 ' replaces all white spaces with single space,
 ' replaces all double spaces with single space.
 Program.Line = False
 CALL Count.Lines(Last.Line)
 FOR Program.Line = 1 TO Last.Line
    Out2 = STRIM$(Program(Program.Line))
    IF LEN(Out2) THEN
       Program(Program.Line) = TTRIM$(Out2, True)
    ELSE
       Program(Program.Line) = Nul
    END IF
 NEXT

 ' remove remark at end of line,
 ' search for end of matching double quotes
 ' which might contain an apostrophe.
 FOR Program.Line = 1 TO Last.Line
    Out2 = STRIM$(Program(Program.Line))
    IF LEN(Out2) THEN
       Start.Char = 1
Next.Quotes:
       Quote.Start = False
       FOR Temp = Start.Char TO LEN(Out2)
          IF MID$(Out2, Temp, 1) = CHR$(34) THEN
             Quote.Start = Temp
             EXIT FOR
          END IF
       NEXT
       IF Quote.Start THEN
          Quote.Stop = False
          FOR Temp2 = Quote.Start + 1 TO LEN(Out2)
             IF MID$(Out2, Temp2, 1) = CHR$(34) THEN
                Quote.Stop = Temp2
                EXIT FOR
             END IF
          NEXT
          IF Quote.Stop THEN
             Start.Char = Quote.Stop + 1
             GOTO Next.Quotes
          END IF
       END IF
       FOR Temp = Start.Char TO LEN(Out2)
          IF MID$(Out2, Temp, 1) = "'" THEN
             Out2 = LEFT$(Out2, Temp - 1)
             EXIT FOR
          END IF
       NEXT
       Out2 = STRIM$(Out2)
       IF LEN(Out2) THEN
          Program(Program.Line) = Out2
       ELSE
          Program(Program.Line) = "REM"
       END IF
    END IF
 NEXT
END SUB

' replaces white spaces with blanks
' var = -1 skip blanks in quotes
FUNCTION TTRIM$(Var$, Var)
 VarX$ = Var$
 Temp = False
 DO
    Temp = Temp + 1
    IF Temp > LEN(VarX$) THEN
       EXIT DO
    END IF
    IF Var THEN
       IF MID$(VarX$, Temp, 1) = CHR$(34) THEN
          DO
             Temp = Temp + 1
             IF Temp > LEN(VarX$) THEN
                EXIT DO
             END IF
             IF MID$(VarX$, Temp, 1) = CHR$(34) THEN
                EXIT DO
             END IF
          LOOP
       END IF
    END IF
    FOR Blanks = 1 TO LEN(White.Space)
       IF MID$(VarX$, Temp, 1) = MID$(White.Space, Blanks, 1) THEN
          MID$(VarX$, Temp, 1) = " "
       END IF
    NEXT
 LOOP
 Temp = False
 DO
    Temp = Temp + 1
    IF Temp > LEN(VarX$) THEN
       EXIT DO
    END IF
    IF Var THEN
       IF MID$(VarX$, Temp, 1) = CHR$(34) THEN
          DO
             Temp = Temp + 1
             IF Temp > LEN(VarX$) THEN
                EXIT DO
             END IF
             IF MID$(VarX$, Temp, 1) = CHR$(34) THEN
                EXIT DO
             END IF
          LOOP
       END IF
    END IF
    IF MID$(VarX$, Temp, 2) = "  " THEN
       VarX$ = LEFT$(VarX$, Temp) + MID$(VarX$, Temp + 2)
       Temp = Temp - 1
    END IF
 LOOP
 TTRIM$ = VarX$
END FUNCTION

' strips leading/trailing white spaces from string
FUNCTION STRIM$(Var$)
 XVar$ = Var$
 DO
    Blanks = 0
    FOR Count = 1 TO LEN(White.Space)
       IF LEFT$(XVar$, 1) = MID$(White.Space, Count, 1) THEN
          XVar$ = MID$(XVar$, 2)
          Blanks = -1
       END IF
    NEXT
    IF Blanks = 0 THEN
       EXIT DO
    END IF
 LOOP
 DO
    Blanks = 0
    FOR Count = 1 TO LEN(White.Space)
       IF RIGHT$(XVar$, 1) = MID$(White.Space, Count, 1) THEN
	  XVar$ = LEFT$(XVar$, LEN(XVar$) - 1)
          Blanks = -1
       END IF
    NEXT
    IF Blanks = 0 THEN
       EXIT DO
    END IF
 LOOP
 STRIM$ = XVar$
END FUNCTION
