;***********************************************************************
; ALPHA.ASM     Version mit Bereichsprfung bei AlphaPunktSetzen
; Copyright     (C) 1991, Hans-Jrgen Herrler und Dieter Sosna
;***********************************************************************
                
DATA    SEGMENT BYTE PUBLIC

        ; Pascal Variable
        EXTRN   AlphaMax                : word
        EXTRN   AlphaMin                : word
        EXTRN   maxTemp                 : word
        EXTRN   minTemp                 : word
        EXTRN   AlphaColor              : Byte;

        ; Pascal Prozedur (Unit Graph)
        EXTRN   PutPixel                : far
        EXTRN   GetMaxX                 : far
        EXTRN   GetMaxY                 : far

DATA    ENDS

CODE    SEGMENT BYTE PUBLIC
        ASSUME CS:CODE, DS:DATA

        PUBLIC  AlphaLine
        PUBLIC  InitAlphaPuffer
        PUBLIC  AlphaPufferAktualisieren

AlphaPunktSetzen PROC NEAR

        ; Input: ax = X, bx = Y
        ; --> Punkt wird gesetzt in der Farbe AlphaColor

        push    ax
        push    bx
        push    cx
        push    dx
        push    bp

        ; Test, ob X und Y im zulssigen Bereich sind
        test    ax,8000h
        jnz     APS3
        test    bx,8000h
        jnz     APS3
        mov     dx,ax
        call    GetMaxX
        cmp     dx,ax
        jg      APS3
        call    GetMaxY
        cmp     bx,ax
        jg      APS3
        mov     ax,dx

        xor     dx,dx                   ; Boolean-Flag "Setzen" := False
        mov     di,ax
        shl     di,1                    ; di := 2 * X

        cmp     bx,[di+Offset AlphaMax] ; Y > AlphaMax[X] ?
        jle     APS1

        inc     dx                      ; Setzen := True
        cmp     bx,[di+Offset maxTemp]  ; Y > maxTemp[X] ?
        jle     APS1
        mov     [di+Offset maxTemp],bx  ; maxTemp[X] := Y

APS1:   cmp     bx,[di+Offset AlphaMin] ; Y < AlphaMin[X] ?
        jnl     APS2
        inc     dx                      ; Setzen := True
        cmp     bx,[di+Offset minTemp]  ; Y < minTemp[X] ?
        jnl     APS2
        mov     [di+Offset minTemp],bx  ; minTemp[X] := Y

APS2:   cmp     dx,00                   ; Setzen = False ?
        je      APS3
        push    ax                      ; Parameter bergeben: x, y, Farbe
        push    bx
        xor     ax,ax
        mov     al,[AlphaColor]
        push    ax
        call    PUTPIXEL                ; Unit Graph

APS3:   pop     bp
        pop     dx
        pop     cx
        pop     bx
        pop     ax
        ret

AlphaPunktSetzen ENDP

Betrag          PROC    NEAR
        ; Input:        cx = Integer1   dx = Integer2
        ; Output:       cx = Absoluter Betrag(Integer1 - Integer2)
        ;               dx = 1, falls Integer2 >= Integer1, sonst dx = -1

        add     cx,8000h
        add     dx,8000h
        cmp     dx,cx
        jc      Betr1

        ; falls Integer2 >= Integer1
        push    cx
        mov     cx,dx
        pop     dx
        sub     cx,dx
        mov     dx,0001h
        jmp     Betr2

        ; falls Integer2 < Integer1
Betr1:  sub     cx,dx
        mov     dx,0FFFFh

Betr2:  ret

Betrag          ENDP

AlphaLine       PROC    FAR

        ; Parameter auf dem Stack
P2X     EQU     6
P2Y     EQU     P2X + 2
P1X     EQU     P2Y + 2
P1Y     EQU     P1X + 2
        ; lokale Variablen
XStep   EQU     -2
YStep   EQU     XStep - 2
DeltaX  EQU     YStep - 2
DeltaY  EQU     DeltaX - 2

        push    bp
        mov     bp,sp
        sub     sp,0008h                ; Platz fr lokale Variablen

        ; DeltaX := Abs(LongInt(P1X)-LongInt(P2X))

        mov     cx,[bp+P1X]
        mov     ax,cx                   ; ax = X
        mov     dx,[bp+P2X]
        call    Betrag
        mov     [bp+DeltaX],cx
        mov     [bp+XStep],dx

        ; DeltaY := Abs(LongInt(P1Y)-LongInt(P2Y))
        mov     cx,[bp+P1Y]
        mov     bx,cx                   ; bx = Y
        mov     dx,[bp+P2Y]
        call    Betrag
        mov     [bp+DeltaY],cx
        mov     [bp+YStep],dx

        ; IF DeltaX >= DeltaY THEN Flach := True ELSE Flach := False
        push    ax
        mov     ax,[bp+DeltaX]
        cmp     ax,[bp+DeltaY]
        pop     ax
        jc      Steil

        ; Flach: Hier ist X die unabhngige Variable
        mov     dx,[bp+DeltaX]
        mov     cx,dx                   ; cx = Schleifenzhler
        shr     dx,1                    ; dx = Control = DeltaX / 2
        call    AlphaPunktSetzen

Loop1:  add     ax,[bp+XStep]           ; Inc(X, XStep)
        sub     dx,[bp+DeltaY]          ; Dec(Control, DeltaY)
        jg      ALine1

        ; Falls Control <= 0:
        add     bx,[bp+YStep]           ; Inc(Y, YStep)
        add     dx,[bp+DeltaX]          ; Inc(Control, DeltaX)

ALine1: call    AlphaPunktSetzen
        loop    Loop1
        jmp     ALine3

Steil:  mov     dx,[bp+DeltaY]
        mov     cx,dx                   ; cx = Schleifenzhler
        shr     dx,1                    ; dx = Control = DeltaY / 2
        call    AlphaPunktSetzen

Loop2:  add     bx,[bp+YStep]           ; Inc(Y, YStep)
        sub     dx,[bp+DeltaX]          ; Dec(Control, DeltaX)
        jg      ALine2

        ; Falls Control <= 0:
        add     ax,[bp+XStep]           ; Inc(X, XStep)
        add     dx,[bp+DeltaY]          ; Inc(Control, DeltaY)

ALine2: call    AlphaPunktSetzen
        loop    Loop2

ALine3: mov     sp,bp
        pop     bp
        ret     0008h

AlphaLine       ENDP

InitAlphaPuffer PROC FAR

        cld                             ; Richtung: aufsteigend
        push    ds
        pop     es
        call    GetMaxX
        inc     ax
        push    ax

        mov     cx,ax
        mov     ax,0FFFFh
        mov     di,Offset AlphaMax
        rep
        stosw

        call    GetMaxY
        inc     ax
        mov     di,Offset AlphaMin
        pop     cx
        push    cx
        rep
        stosw

        mov     si,Offset AlphaMax
        mov     di,Offset maxTemp
        pop     cx
        push    cx
        rep
        movsw

        mov     si,Offset AlphaMin
        mov     di,Offset minTemp
        pop     cx
        rep
        movsw

        ret

InitAlphaPuffer ENDP

AlphaPufferAktualisieren        PROC FAR

        cld                             ; Richtung: aufsteigend
        push    ds
        pop     es
        call    GetMaxX
        inc     ax
        push    ax

        mov     si,Offset maxTemp
        mov     di,Offset AlphaMax
        pop     cx
        push    cx
        rep
        movsw

        mov     si,Offset minTemp
        mov     di,Offset AlphaMin
        pop     cx
        rep
        movsw

        ret

AlphaPufferAktualisieren        ENDP

        ENDS
        END
