Program AltTest;
{
  Overview/Description:
    Exercise the AltMon module.  No operator interaction is required,
    simply invoke, sit back and watch the show.

  Compiler/Operating System:
    Turbo-Pascal Ver 5.5
    MS-DOS Ver 3.30

  Maintenance History:
    7 June, 1989  G.S.Cole  //Creation//
}
Uses AltMon, CRT;
CONST
  Page_Delay = 4000;  { delay between display panels }

Procedure Write_Introduction;
CONST
  Message = 'AltTest - Demonstrate use of two video monitors, simultaneously.';
VAR
  I:Byte;
  Trash:Boolean;
begin { Procedure Write_Introduction }
  ClrScr;
  For I := 1 to 20 do
    Writeln(Message);
  Trash := Swap_Monitor;
  ClrScr;
  For I := 1 to 20 do
    Writeln(Message);
  Delay(Page_Delay);
end; { Procedure Write_Introduction }

Procedure Swap_Monitors_Demo;
{
    Demonstrate the ability to swap the active monitor.
    Always exits with the color display as default.
}
VAR
  I:Byte;
  Trash:Boolean;
  Buffer:String[60];
begin { Procedure Swap_Monitors_Demo }
  If NOT Swap_Monitor       { Ensure we start on the color display }
    then Trash := Swap_Monitor;
  If NOT Swap_Monitor
    then Buffer := 'This is the MONOCHROME display.  <<Alternate>>';
  ClrScr;
  For I := 1 to 20 do
    Writeln(Buffer);
  If Swap_Monitor
    then Buffer := 'This is the COLOR display.  <<Primary>>';
  ClrScr;
  For I := 1 to 20 do
    Writeln(Buffer);
  Delay(Page_Delay);
end; { Procedure Swap_Monitors_Demo }

Procedure Video_Attributes;
{
    Demonstrate the appearance of various text attributes,
    and how to set them.
}
VAR
  Attribute_Index:AltMon_Attribute_Type;
begin { Procedure Video_Attributes }
  ClrScr;
  Alt_ClrScr;
  Writeln('Primary display demonstrates some video attributes.');
  Alt_Writeln('Alternate display demonstrates video attributes.');
  For Attribute_Index := Alt_Normal to Alt_Blink_Reverse do
    begin
      Alt_Set_Attribute(Attribute_Index);
      Alt_Writeln('Demonstrate Alternate Video Attributes...');
      TextAttr := Alt_TextAttr;
      Writeln('Demonstrate Video Attributes...');
    end;
  Delay(Page_Delay);
end; { Procedure Video_Attributes }

Procedure Cursor_Demo;
{
    Demonstrate locating and positioning cursor.
}
VAR
  X, Y:Byte;
  Buffer, Buffer2:String[80];
begin { Procedure Cursor_Demo }
  Buffer := 'This line started at X=10, and Y=20.';
  GoToXY(10, 20);
  Write(Buffer);
  Alt_GoToXY(10, 20);
  Alt_Write(Buffer);
  X := WhereX;
  Y := WhereY;
  STR(X, Buffer);
  STR(Y, Buffer2);
  Buffer := '  New X/Y: ' + Buffer + '/' + Buffer2;
  Writeln(Buffer);
  X := Alt_WhereX;
  Y := Alt_WhereY;
  STR(X, Buffer);
  STR(Y, Buffer2);
  Buffer := '  New X/Y: ' + Buffer + '/' + Buffer2;
  NormVideo;
  Alt_NormVideo;
  Alt_Writeln(Buffer);
  Delay(Page_Delay);
end; { Procedure Cursor_Demo }

Procedure Window_Demo1;
{
    Demonstrate reading window limits.
}
VAR
  X, Y:Byte;
  Buffer, Buffer2:String[80];
begin { Procedure Window_Demo1 }
  Writeln('Current Window Minimum X/Y: ', Lo(WindMin), '/', Hi(WindMin));
  Writeln('Current Window Maximum X/Y: ', Lo(WindMax), '/', Hi(WindMax));
  STR(Lo(Alt_WindMin), Buffer);
  STR(Hi(Alt_WindMin), Buffer2);
  Buffer := 'Current Window Minimum X/Y: ' + Buffer + '/' + Buffer2;
  Alt_Writeln(Buffer);
  STR(Lo(Alt_WindMax), Buffer);
  STR(Hi(Alt_WindMax), Buffer2);
  Buffer := 'Current Window Maximum X/Y: ' + Buffer + '/' + Buffer2;
  Alt_Writeln(Buffer);

  TextColor(White);
  TextBackGround(Green);
  Alt_Set_Attribute(Alt_Reverse);
  Window(5, 5, 55, 15);
  Alt_Window(5, 5, 55, 15);
  ClrScr;
  Alt_ClrScr;
  STR(Lo(Alt_WindMin), Buffer);
  STR(Hi(Alt_WindMin), Buffer2);
  Buffer := 'Current Window Minimum X/Y: ' + Buffer + '/' + Buffer2;
  Writeln(Buffer);
  Alt_Writeln(Buffer);
  STR(Lo(Alt_WindMax), Buffer);
  STR(Hi(Alt_WindMax), Buffer2);
  Buffer := 'Current Window Maximum X/Y: ' + Buffer + '/' + Buffer2;
  Writeln(Buffer);
  Alt_Writeln(Buffer);

  X := Alt_WhereX;
  Y := Alt_WhereY;
  STR(X, Buffer);
  STR(Y, Buffer2);
  Buffer := 'New X/Y: ' + Buffer + '/' + Buffer2;
  Writeln(Buffer);
  Alt_Writeln(Buffer);
  Delay(Page_Delay);
end; { Procedure Window_Demo1 }

Procedure Line_Wrap_Demo;
{
    Force a line wrap.  This shows that windows are respected.
}
begin { Procedure Line_Wrap_Demo }
  Alt_Set_Attribute(Alt_Reverse);
  Alt_Write('Of all the fishies in the sea, the ');
  Write('Of all the fishies in the sea, the ');
  Alt_Set_Attribute(Alt_Blink);
  TextColor(Black+Blink);
  Alt_Write('mermaid');
  Write('mermaid');
  Alt_Set_Attribute(Alt_Reverse);
  TextColor(Black);
  Alt_Write(' is the one for me!');
  Write(' is the one for me!');
  Delay(Page_Delay);
end; { Procedure Line_Wrap_Demo }

Procedure Scroll_Demo1;
{
    Force the contents of the current window to scroll.
}
VAR
  I:Byte;
  Buffer:String[40];
begin { Procedure Scroll_Demo1 }
  Buffer := 'Scroll Test RYRYRYRYRYRYRYRYRY';
  For I := 1 to 20 do
    begin
      Writeln(Buffer);
      Alt_Writeln(Buffer);
    end;
  Delay(Page_Delay);
end; { Procedure Scroll_Demo1 }

Procedure Window_Demo2;
VAR
  I:Byte;
  Buffer, Buffer2:String[80];
begin { Procedure Window_Demo2 }
  Window(1, 1, 80, 25);
  Alt_Window(1, 1, 80, 25);
  Alt_NormVideo;
  ClrScr;
  Alt_ClrScr;
  Buffer := '1234567890123456789012345678901234567890123456789012345678901234567890123456789';
  For I := 1 to 24 do
    begin
      Writeln(Buffer);
      Alt_Writeln(Buffer);
    end;
  Window(5, 5, 60, 15);
  Alt_Window(5, 5, 60, 15);
  Alt_Set_Attribute(Alt_Reverse);
  TextColor(White);
  TextBackGround(Blue);
  ClrScr;
  Alt_ClrScr;
  Buffer2 := 'RYRYRYRYRYRYRYRYRYRYRY';
  Buffer := 'Line1 ' + Buffer2 + ' Line1';
  For I := 0 to 9 do
    begin
      Buffer[5] := Chr(I + $30);
      Buffer[34] := Buffer[5];
      Writeln(Buffer);
      Alt_Writeln(Buffer);
    end;
  Delay(Page_Delay);
end; { Procedure Window_Demo2 }

Procedure Insert_Line_Demo;
begin { Procedure Insert_Line_Demo }
  GotoXY(1, 4);
  Alt_GoToXY(1, 4);
  InsLine;
  Alt_InsLine;
  Writeln('New Inserted Line...');
  Alt_Writeln('New Inserted Line...');
  Delay(Page_Delay);
end; { Procedure Insert_Line_Demo }

Procedure Delete_Line_Demo;
begin { Procedure Delete_Line_Demo }
  GotoXY(1, 7);
  Alt_GoToXY(1, 7);
  DelLine;
  Alt_DelLine;
  GotoXY(1, 11);
  Alt_GoToXY(1, 11);
  Write('Line 5 deleted...');
  Alt_Write('Line 5 deleted...');
  Delay(Page_Delay);
end; { Procedure Delete_Line_Demo }

VAR
  I, X, Y:Byte;
  Buffer, Buffer2:String[255];

begin { AltTest Main }
  If Dual_Monitors_Detected then
    begin
      AltMon_Setup;
      TextColor(White);
      TextBackGround(Black);
    end
  else
    begin
      Writeln('Abort!  A monochrome and a color video adapter were not detected.');
      Halt;
    end;

  Alt_Cursor_Disable;
  Write_Introduction;
  Swap_Monitors_Demo;
  Video_Attributes;
  Cursor_Demo;
  Window_Demo1;
{
    Clear to EOL
}
  Alt_NormVideo;
  TextBackGround(White);
  TextColor(Black);
  ClrEOL;
  Writeln('** ClrEOL **');
  Alt_ClrEOL;
  Alt_Writeln('** Alt_ClrEOL **');

  Line_Wrap_Demo;
  Scroll_Demo1;
  Window_Demo2;
  Insert_Line_Demo;
  Delete_Line_Demo;
end. { AltTest Main }